/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import lombok.NonNull;
import me.chanjar.weixin.common.error.WxCpErrorMsgEnum;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpExternalContactService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpBaseResp;
import me.chanjar.weixin.cp.bean.external.WxCpContactWayInfo;
import me.chanjar.weixin.cp.bean.external.WxCpContactWayResult;
import me.chanjar.weixin.cp.bean.external.WxCpMsgTemplate;
import me.chanjar.weixin.cp.bean.external.WxCpMsgTemplateAddResult;
import me.chanjar.weixin.cp.bean.external.WxCpUpdateRemarkRequest;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalContactInfo;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalContactList;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalGroupChatInfo;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalGroupChatList;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalGroupChatStatistic;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalTagGroupInfo;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalTagGroupList;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalUnassignList;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalUserBehaviorStatistic;
import me.chanjar.weixin.cp.bean.external.WxCpUserWithExternalPermission;
import me.chanjar.weixin.cp.bean.external.WxCpWelcomeMsg;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class WxCpExternalContactServiceImpl
implements WxCpExternalContactService {
    private final WxCpService mainService;

    @Override
    public WxCpContactWayResult addContactWay(@NonNull WxCpContactWayInfo info) throws WxErrorException {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        if (info.getContactWay().getUsers() != null && info.getContactWay().getUsers().size() > 100) {
            throw new RuntimeException("\u300c\u8054\u7cfb\u6211\u300d\u4f7f\u7528\u4eba\u6570\u9ed8\u8ba4\u9650\u5236\u4e0d\u8d85\u8fc7100\u4eba(\u5305\u62ec\u90e8\u95e8\u5c55\u5f00\u540e\u7684\u4eba\u6570)");
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/add_contact_way");
        String responseContent = this.mainService.post(url, info.getContactWay().toJson());
        return WxCpContactWayResult.fromJson(responseContent);
    }

    @Override
    public WxCpContactWayInfo getContactWay(@NonNull String configId) throws WxErrorException {
        if (configId == null) {
            throw new NullPointerException("configId is marked non-null but is null");
        }
        JsonObject json = new JsonObject();
        json.addProperty("config_id", configId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_contact_way");
        String responseContent = this.mainService.post(url, json.toString());
        return WxCpContactWayInfo.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp updateContactWay(@NonNull WxCpContactWayInfo info) throws WxErrorException {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)info.getContactWay().getConfigId())) {
            throw new RuntimeException("\u66f4\u65b0\u300c\u8054\u7cfb\u6211\u300d\u65b9\u5f0f\u9700\u8981\u6307\u5b9aconfigId");
        }
        if (info.getContactWay().getUsers() != null && info.getContactWay().getUsers().size() > 100) {
            throw new RuntimeException("\u300c\u8054\u7cfb\u6211\u300d\u4f7f\u7528\u4eba\u6570\u9ed8\u8ba4\u9650\u5236\u4e0d\u8d85\u8fc7100\u4eba(\u5305\u62ec\u90e8\u95e8\u5c55\u5f00\u540e\u7684\u4eba\u6570)");
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/update_contact_way");
        String responseContent = this.mainService.post(url, info.getContactWay().toJson());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp deleteContactWay(@NonNull String configId) throws WxErrorException {
        if (configId == null) {
            throw new NullPointerException("configId is marked non-null but is null");
        }
        JsonObject json = new JsonObject();
        json.addProperty("config_id", configId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/del_contact_way");
        String responseContent = this.mainService.post(url, json.toString());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp closeTempChat(@NonNull String userId, @NonNull String externalUserId) throws WxErrorException {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (externalUserId == null) {
            throw new NullPointerException("externalUserId is marked non-null but is null");
        }
        JsonObject json = new JsonObject();
        json.addProperty("userid", userId);
        json.addProperty("external_userid", externalUserId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/close_temp_chat");
        String responseContent = this.mainService.post(url, json.toString());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpUserExternalContactInfo getExternalContact(String userId) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/crm/get_external_contact?external_userid=" + userId);
        String responseContent = this.mainService.get(url, null);
        return WxCpUserExternalContactInfo.fromJson(responseContent);
    }

    @Override
    public WxCpUserExternalContactInfo getContactDetail(String userId) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get?external_userid=" + userId);
        String responseContent = this.mainService.get(url, null);
        return WxCpUserExternalContactInfo.fromJson(responseContent);
    }

    @Override
    public void updateRemark(WxCpUpdateRemarkRequest request) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/remark");
        this.mainService.post(url, request.toJson());
    }

    @Override
    public List<String> listExternalContacts(String userId) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/list?userid=" + userId);
        try {
            String responseContent = this.mainService.get(url, null);
            return WxCpUserExternalContactList.fromJson(responseContent).getExternalUserId();
        }
        catch (WxErrorException e) {
            if (e.getError().getErrorCode() == WxCpErrorMsgEnum.CODE_84061.getCode()) {
                return Collections.emptyList();
            }
            throw e;
        }
    }

    @Override
    public List<String> listFollowers() throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_follow_user_list");
        String responseContent = this.mainService.get(url, null);
        return WxCpUserWithExternalPermission.fromJson(responseContent).getFollowers();
    }

    @Override
    public WxCpUserExternalUnassignList listUnassignedList(Integer pageIndex, Integer pageSize) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("page_id", (Number)(pageIndex == null ? 0 : pageIndex));
        json.addProperty("page_size", (Number)(pageSize == null ? 100 : pageSize));
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_unassigned_list");
        String result = this.mainService.post(url, json.toString());
        return WxCpUserExternalUnassignList.fromJson(result);
    }

    @Override
    public WxCpBaseResp transferExternalContact(String externalUserid, String handOverUserid, String takeOverUserid) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("external_userid", externalUserid);
        json.addProperty("handover_userid", handOverUserid);
        json.addProperty("takeover_userid", takeOverUserid);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/transfer");
        String result = this.mainService.post(url, json.toString());
        return WxCpBaseResp.fromJson(result);
    }

    @Override
    public WxCpUserExternalGroupChatList listGroupChat(Integer pageIndex, Integer pageSize, int status, String[] userIds, String[] partyIds) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("offset", (Number)(pageIndex == null ? 0 : pageIndex));
        json.addProperty("limit", (Number)(pageSize == null ? 100 : pageSize));
        json.addProperty("status_filter", (Number)status);
        if (ArrayUtils.isNotEmpty((Object[])userIds) || ArrayUtils.isNotEmpty((Object[])partyIds)) {
            JsonObject ownerFilter = new JsonObject();
            if (ArrayUtils.isNotEmpty((Object[])userIds)) {
                json.add("userid_list", (JsonElement)new Gson().toJsonTree((Object)userIds).getAsJsonArray());
            }
            if (ArrayUtils.isNotEmpty((Object[])partyIds)) {
                json.add("partyid_list", (JsonElement)new Gson().toJsonTree((Object)partyIds).getAsJsonArray());
            }
            json.add("owner_filter", (JsonElement)ownerFilter);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/list");
        String result = this.mainService.post(url, json.toString());
        return WxCpUserExternalGroupChatList.fromJson(result);
    }

    @Override
    public WxCpUserExternalGroupChatInfo getGroupChat(String chatId) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("chat_id", chatId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/get");
        String result = this.mainService.post(url, json.toString());
        return WxCpUserExternalGroupChatInfo.fromJson(result);
    }

    @Override
    public WxCpUserExternalUserBehaviorStatistic getUserBehaviorStatistic(Date startTime, Date endTime, String[] userIds, String[] partyIds) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("start_time", (Number)(startTime.getTime() / 1000L));
        json.addProperty("end_time", (Number)(endTime.getTime() / 1000L));
        if (ArrayUtils.isNotEmpty((Object[])userIds) || ArrayUtils.isNotEmpty((Object[])partyIds)) {
            if (ArrayUtils.isNotEmpty((Object[])userIds)) {
                json.add("userid", (JsonElement)new Gson().toJsonTree((Object)userIds).getAsJsonArray());
            }
            if (ArrayUtils.isNotEmpty((Object[])partyIds)) {
                json.add("partyid", (JsonElement)new Gson().toJsonTree((Object)partyIds).getAsJsonArray());
            }
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_user_behavior_data");
        String result = this.mainService.post(url, json.toString());
        return WxCpUserExternalUserBehaviorStatistic.fromJson(result);
    }

    @Override
    public WxCpUserExternalGroupChatStatistic getGroupChatStatistic(Date startTime, Integer orderBy, Integer orderAsc, Integer pageIndex, Integer pageSize, String[] userIds, String[] partyIds) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("day_begin_time", (Number)(startTime.getTime() / 1000L));
        json.addProperty("order_by", (Number)(orderBy == null ? 1 : orderBy));
        json.addProperty("order_asc", (Number)(orderAsc == null ? 0 : orderAsc));
        json.addProperty("offset", (Number)(pageIndex == null ? 0 : pageIndex));
        json.addProperty("limit", (Number)(pageSize == null ? 500 : pageSize));
        if (ArrayUtils.isNotEmpty((Object[])userIds) || ArrayUtils.isNotEmpty((Object[])partyIds)) {
            JsonObject ownerFilter = new JsonObject();
            if (ArrayUtils.isNotEmpty((Object[])userIds)) {
                json.add("userid_list", (JsonElement)new Gson().toJsonTree((Object)userIds).getAsJsonArray());
            }
            if (ArrayUtils.isNotEmpty((Object[])partyIds)) {
                json.add("partyid_list", (JsonElement)new Gson().toJsonTree((Object)partyIds).getAsJsonArray());
            }
            json.add("owner_filter", (JsonElement)ownerFilter);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/statistic");
        String result = this.mainService.post(url, json.toString());
        return WxCpUserExternalGroupChatStatistic.fromJson(result);
    }

    @Override
    public WxCpMsgTemplateAddResult addMsgTemplate(WxCpMsgTemplate wxCpMsgTemplate) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/add_msg_template");
        String result = this.mainService.post(url, wxCpMsgTemplate.toJson());
        return WxCpMsgTemplateAddResult.fromJson(result);
    }

    @Override
    public void sendWelcomeMsg(WxCpWelcomeMsg msg) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/send_welcome_msg");
        this.mainService.post(url, msg.toJson());
    }

    @Override
    public WxCpUserExternalTagGroupList getCorpTagList(String[] tagId) throws WxErrorException {
        JsonObject json = new JsonObject();
        if (ArrayUtils.isNotEmpty((Object[])tagId)) {
            json.add("tag_id", (JsonElement)new Gson().toJsonTree((Object)tagId).getAsJsonArray());
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_corp_tag_list");
        String result = this.mainService.post(url, json.toString());
        return WxCpUserExternalTagGroupList.fromJson(result);
    }

    @Override
    public WxCpUserExternalTagGroupInfo addCorpTag(WxCpUserExternalTagGroupInfo tagGroup) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/add_corp_tag");
        String result = this.mainService.post(url, tagGroup.getTagGroup().toJson());
        return WxCpUserExternalTagGroupInfo.fromJson(result);
    }

    @Override
    public WxCpBaseResp editCorpTag(String id, String name, Integer order) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("id", id);
        json.addProperty("name", name);
        json.addProperty("order", (Number)order);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/edit_corp_tag");
        String result = this.mainService.post(url, json.toString());
        return WxCpBaseResp.fromJson(result);
    }

    @Override
    public WxCpBaseResp delCorpTag(String[] tagId, String[] groupId) throws WxErrorException {
        JsonObject json = new JsonObject();
        if (ArrayUtils.isNotEmpty((Object[])tagId)) {
            json.add("tag_id", (JsonElement)new Gson().toJsonTree((Object)tagId).getAsJsonArray());
        }
        if (ArrayUtils.isNotEmpty((Object[])groupId)) {
            json.add("group_id", (JsonElement)new Gson().toJsonTree((Object)groupId).getAsJsonArray());
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/del_corp_tag");
        String result = this.mainService.post(url, json.toString());
        return WxCpBaseResp.fromJson(result);
    }

    @Override
    public WxCpBaseResp markTag(String userid, String externalUserid, String[] addTag, String[] removeTag) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("userid", userid);
        json.addProperty("external_userid", externalUserid);
        if (ArrayUtils.isNotEmpty((Object[])addTag)) {
            json.add("add_tag", (JsonElement)new Gson().toJsonTree((Object)addTag).getAsJsonArray());
        }
        if (ArrayUtils.isNotEmpty((Object[])removeTag)) {
            json.add("remove_tag", (JsonElement)new Gson().toJsonTree((Object)removeTag).getAsJsonArray());
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/mark_tag");
        String result = this.mainService.post(url, json.toString());
        return WxCpBaseResp.fromJson(result);
    }

    public WxCpExternalContactServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }
}

