/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.tp.message;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import me.chanjar.weixin.common.api.WxErrorExceptionHandler;
import me.chanjar.weixin.common.api.WxMessageDuplicateChecker;
import me.chanjar.weixin.common.api.WxMessageInMemoryDuplicateChecker;
import me.chanjar.weixin.common.session.InternalSession;
import me.chanjar.weixin.common.session.InternalSessionManager;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.common.util.LogExceptionHandler;
import me.chanjar.weixin.cp.bean.message.WxCpTpXmlMessage;
import me.chanjar.weixin.cp.bean.message.WxCpXmlOutMessage;
import me.chanjar.weixin.cp.tp.message.WxCpTpMessageRouterRule;
import me.chanjar.weixin.cp.tp.service.WxCpTpService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxCpTpMessageRouter {
    private static final Logger log = LoggerFactory.getLogger(WxCpTpMessageRouter.class);
    private static final int DEFAULT_THREAD_POOL_SIZE = 100;
    private final List<WxCpTpMessageRouterRule> rules = new ArrayList<WxCpTpMessageRouterRule>();
    private final WxCpTpService wxCpService;
    private ExecutorService executorService;
    private WxMessageDuplicateChecker messageDuplicateChecker;
    private WxSessionManager sessionManager;
    private WxErrorExceptionHandler exceptionHandler;

    public WxCpTpMessageRouter(WxCpTpService wxCpService) {
        this.wxCpService = wxCpService;
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("WxCpTpMessageRouter-pool-%d").build();
        this.executorService = new ThreadPoolExecutor(100, 100, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
        this.messageDuplicateChecker = new WxMessageInMemoryDuplicateChecker();
        this.sessionManager = wxCpService.getSessionManager();
        this.exceptionHandler = new LogExceptionHandler();
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setMessageDuplicateChecker(WxMessageDuplicateChecker messageDuplicateChecker) {
        this.messageDuplicateChecker = messageDuplicateChecker;
    }

    public void setSessionManager(WxSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setExceptionHandler(WxErrorExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    List<WxCpTpMessageRouterRule> getRules() {
        return this.rules;
    }

    public WxCpTpMessageRouterRule rule() {
        return new WxCpTpMessageRouterRule(this);
    }

    public WxCpXmlOutMessage route(WxCpTpXmlMessage wxMessage, Map<String, Object> context) {
        if (this.isMsgDuplicated(wxMessage)) {
            return null;
        }
        ArrayList<WxCpTpMessageRouterRule> matchRules = new ArrayList<WxCpTpMessageRouterRule>();
        for (WxCpTpMessageRouterRule rule : this.rules) {
            if (!rule.test(wxMessage)) continue;
            matchRules.add(rule);
            if (rule.isReEnter()) continue;
            break;
        }
        if (matchRules.size() == 0) {
            return null;
        }
        WxCpXmlOutMessage res = null;
        ArrayList futures = new ArrayList();
        for (WxCpTpMessageRouterRule rule : matchRules) {
            if (rule.isAsync()) {
                futures.add(this.executorService.submit(() -> rule.service(wxMessage, context, this.wxCpService, this.sessionManager, this.exceptionHandler)));
                continue;
            }
            res = rule.service(wxMessage, context, this.wxCpService, this.sessionManager, this.exceptionHandler);
            log.debug("End session access: async=false, sessionId={}", (Object)wxMessage.getSuiteId());
            this.sessionEndAccess(wxMessage);
        }
        if (futures.size() > 0) {
            this.executorService.submit(() -> {
                for (Future future : futures) {
                    try {
                        future.get();
                        log.debug("End session access: async=true, sessionId={}", (Object)wxMessage.getSuiteId());
                        this.sessionEndAccess(wxMessage);
                    }
                    catch (InterruptedException e) {
                        log.error("Error happened when wait task finish", (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        log.error("Error happened when wait task finish", (Throwable)e);
                    }
                }
            });
        }
        return res;
    }

    public WxCpXmlOutMessage route(WxCpTpXmlMessage wxMessage) {
        return this.route(wxMessage, new HashMap<String, Object>(2));
    }

    private boolean isMsgDuplicated(WxCpTpXmlMessage wxMessage) {
        StringBuilder messageId = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)wxMessage.getSuiteId())) {
            messageId.append("-").append(wxMessage.getSuiteId());
        }
        if (StringUtils.isNotEmpty((CharSequence)wxMessage.getInfoType())) {
            messageId.append("-").append(wxMessage.getInfoType());
        }
        if (StringUtils.isNotEmpty((CharSequence)wxMessage.getTimeStamp())) {
            messageId.append("-").append(wxMessage.getTimeStamp());
        }
        return this.messageDuplicateChecker.isDuplicate(messageId.toString());
    }

    private void sessionEndAccess(WxCpTpXmlMessage wxMessage) {
        InternalSession session = ((InternalSessionManager)this.sessionManager).findSession(wxMessage.getSuiteId());
        if (session != null) {
            session.endAccess();
        }
    }
}

