/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.util.Date;
import java.util.List;
import lombok.NonNull;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.cp.api.WxCpOaService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.oa.WxCpApprovalDetailResult;
import me.chanjar.weixin.cp.bean.oa.WxCpApprovalInfo;
import me.chanjar.weixin.cp.bean.oa.WxCpApprovalInfoQueryFilter;
import me.chanjar.weixin.cp.bean.oa.WxCpCheckinData;
import me.chanjar.weixin.cp.bean.oa.WxCpCheckinDayData;
import me.chanjar.weixin.cp.bean.oa.WxCpCheckinMonthData;
import me.chanjar.weixin.cp.bean.oa.WxCpCheckinOption;
import me.chanjar.weixin.cp.bean.oa.WxCpCheckinSchedule;
import me.chanjar.weixin.cp.bean.oa.WxCpCropCheckinOption;
import me.chanjar.weixin.cp.bean.oa.WxCpDialRecord;
import me.chanjar.weixin.cp.bean.oa.WxCpOaApplyEventRequest;
import me.chanjar.weixin.cp.bean.oa.WxCpTemplateResult;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;

public class WxCpOaServiceImpl
implements WxCpOaService {
    private final WxCpService mainService;
    private static final int MONTH_SECONDS = 2592000;
    private static final int USER_IDS_LIMIT = 100;

    @Override
    public String apply(WxCpOaApplyEventRequest request) throws WxErrorException {
        String responseContent = this.mainService.post(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/oa/applyevent"), request.toJson());
        return GsonParser.parse((String)responseContent).get("sp_no").getAsString();
    }

    @Override
    public List<WxCpCheckinData> getCheckinData(Integer openCheckinDataType, Date startTime, Date endTime, List<String> userIdList) throws WxErrorException {
        long startTimestamp;
        if (startTime == null || endTime == null) {
            throw new WxRuntimeException("starttime and endtime can't be null");
        }
        if (userIdList == null || userIdList.size() > 100) {
            throw new WxRuntimeException("\u7528\u6237\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u8d85\u8fc7 100 \u4e2a\uff0c\u82e5\u7528\u6237\u8d85\u8fc7 100 \u4e2a\uff0c\u8bf7\u5206\u6279\u83b7\u53d6");
        }
        long endTimestamp = endTime.getTime() / 1000L;
        if (endTimestamp - (startTimestamp = startTime.getTime() / 1000L) < 0L || endTimestamp - startTimestamp >= 2592000L) {
            throw new WxRuntimeException("\u83b7\u53d6\u8bb0\u5f55\u65f6\u95f4\u8de8\u5ea6\u4e0d\u8d85\u8fc7\u4e00\u4e2a\u6708");
        }
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        jsonObject.addProperty("opencheckindatatype", (Number)openCheckinDataType);
        jsonObject.addProperty("starttime", (Number)startTimestamp);
        jsonObject.addProperty("endtime", (Number)endTimestamp);
        for (String userid : userIdList) {
            jsonArray.add(userid);
        }
        jsonObject.add("useridlist", (JsonElement)jsonArray);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/checkin/getcheckindata");
        String responseContent = this.mainService.post(url, jsonObject.toString());
        JsonObject tmpJson = GsonParser.parse((String)responseContent);
        return (List)WxCpGsonBuilder.create().fromJson(tmpJson.get("checkindata"), new TypeToken<List<WxCpCheckinData>>(){}.getType());
    }

    @Override
    public List<WxCpCheckinOption> getCheckinOption(Date datetime, List<String> userIdList) throws WxErrorException {
        if (datetime == null) {
            throw new WxRuntimeException("datetime can't be null");
        }
        if (userIdList == null || userIdList.size() > 100) {
            throw new WxRuntimeException("\u7528\u6237\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u8d85\u8fc7 100 \u4e2a\uff0c\u82e5\u7528\u6237\u8d85\u8fc7 100 \u4e2a\uff0c\u8bf7\u5206\u6279\u83b7\u53d6");
        }
        JsonArray jsonArray = new JsonArray();
        for (String userid : userIdList) {
            jsonArray.add(userid);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("datetime", (Number)(datetime.getTime() / 1000L));
        jsonObject.add("useridlist", (JsonElement)jsonArray);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/checkin/getcheckinoption");
        String responseContent = this.mainService.post(url, jsonObject.toString());
        JsonObject tmpJson = GsonParser.parse((String)responseContent);
        return (List)WxCpGsonBuilder.create().fromJson(tmpJson.get("info"), new TypeToken<List<WxCpCheckinOption>>(){}.getType());
    }

    @Override
    public List<WxCpCropCheckinOption> getCropCheckinOption() throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/checkin/getcorpcheckinoption");
        String responseContent = this.mainService.post(url, jsonObject.toString());
        JsonObject tmpJson = GsonParser.parse((String)responseContent);
        return (List)WxCpGsonBuilder.create().fromJson(tmpJson.get("group"), new TypeToken<List<WxCpCropCheckinOption>>(){}.getType());
    }

    @Override
    public WxCpApprovalInfo getApprovalInfo(@NonNull Date startTime, @NonNull Date endTime, Integer cursor, Integer size, List<WxCpApprovalInfoQueryFilter> filters) throws WxErrorException {
        if (startTime == null) {
            throw new NullPointerException("startTime is marked non-null but is null");
        }
        if (endTime == null) {
            throw new NullPointerException("endTime is marked non-null but is null");
        }
        if (cursor == null) {
            cursor = 0;
        }
        if (size == null) {
            size = 100;
        }
        if (size < 0 || size > 100) {
            throw new IllegalArgumentException("size\u53c2\u6570\u9519\u8bef,\u8bf7\u4f7f\u7528[1-100]\u586b\u5145\uff0c\u9ed8\u8ba4100");
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("starttime", (Number)(startTime.getTime() / 1000L));
        jsonObject.addProperty("endtime", (Number)(endTime.getTime() / 1000L));
        jsonObject.addProperty("size", (Number)size);
        jsonObject.addProperty("cursor", (Number)cursor);
        if (filters != null && !filters.isEmpty()) {
            JsonArray filterJsonArray = new JsonArray();
            for (WxCpApprovalInfoQueryFilter filter : filters) {
                filterJsonArray.add(new JsonParser().parse(filter.toJson()));
            }
            jsonObject.add("filters", (JsonElement)filterJsonArray);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/oa/getapprovalinfo");
        String responseContent = this.mainService.post(url, jsonObject.toString());
        return (WxCpApprovalInfo)WxCpGsonBuilder.create().fromJson(responseContent, WxCpApprovalInfo.class);
    }

    @Override
    public WxCpApprovalInfo getApprovalInfo(@NonNull Date startTime, @NonNull Date endTime) throws WxErrorException {
        if (startTime == null) {
            throw new NullPointerException("startTime is marked non-null but is null");
        }
        if (endTime == null) {
            throw new NullPointerException("endTime is marked non-null but is null");
        }
        return this.getApprovalInfo(startTime, endTime, null, null, null);
    }

    @Override
    public WxCpApprovalDetailResult getApprovalDetail(@NonNull String spNo) throws WxErrorException {
        if (spNo == null) {
            throw new NullPointerException("spNo is marked non-null but is null");
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("sp_no", spNo);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/oa/getapprovaldetail");
        String responseContent = this.mainService.post(url, jsonObject.toString());
        return (WxCpApprovalDetailResult)WxCpGsonBuilder.create().fromJson(responseContent, WxCpApprovalDetailResult.class);
    }

    @Override
    public List<WxCpDialRecord> getDialRecord(Date startTime, Date endTime, Integer offset, Integer limit) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        if (offset == null) {
            offset = 0;
        }
        if (limit == null || limit <= 0) {
            limit = 100;
        }
        jsonObject.addProperty("offset", (Number)offset);
        jsonObject.addProperty("limit", (Number)limit);
        if (startTime != null && endTime != null) {
            long starttimestamp;
            long endtimestamp = endTime.getTime() / 1000L;
            if (endtimestamp - (starttimestamp = startTime.getTime() / 1000L) < 0L || endtimestamp - starttimestamp >= 2592000L) {
                throw new WxRuntimeException("\u53d7\u9650\u4e8e\u7f51\u7edc\u4f20\u8f93\uff0c\u8d77\u6b62\u65f6\u95f4\u7684\u6700\u5927\u8de8\u5ea6\u4e3a30\u5929\uff0c\u5982\u8d85\u8fc730\u5929\uff0c\u5219\u4ee5\u7ed3\u675f\u65f6\u95f4\u4e3a\u57fa\u51c6\u5411\u524d\u53d630\u5929\u8fdb\u884c\u67e5\u8be2");
            }
            jsonObject.addProperty("start_time", (Number)starttimestamp);
            jsonObject.addProperty("end_time", (Number)endtimestamp);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/dial/get_dial_record");
        String responseContent = this.mainService.post(url, jsonObject.toString());
        JsonObject tmpJson = GsonParser.parse((String)responseContent);
        return (List)WxCpGsonBuilder.create().fromJson(tmpJson.get("record"), new TypeToken<List<WxCpDialRecord>>(){}.getType());
    }

    @Override
    public WxCpTemplateResult getTemplateDetail(@NonNull String templateId) throws WxErrorException {
        if (templateId == null) {
            throw new NullPointerException("templateId is marked non-null but is null");
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("template_id", templateId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/oa/gettemplatedetail");
        String responseContent = this.mainService.post(url, jsonObject.toString());
        return (WxCpTemplateResult)WxCpGsonBuilder.create().fromJson(responseContent, WxCpTemplateResult.class);
    }

    @Override
    public List<WxCpCheckinDayData> getCheckinDayData(Date startTime, Date endTime, List<String> userIdList) throws WxErrorException {
        if (startTime == null || endTime == null) {
            throw new WxRuntimeException("starttime and endtime can't be null");
        }
        if (userIdList == null || userIdList.size() > 100) {
            throw new WxRuntimeException("\u7528\u6237\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u8d85\u8fc7 100 \u4e2a\uff0c\u82e5\u7528\u6237\u8d85\u8fc7 100 \u4e2a\uff0c\u8bf7\u5206\u6279\u83b7\u53d6");
        }
        long endTimestamp = endTime.getTime() / 1000L;
        long startTimestamp = startTime.getTime() / 1000L;
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        jsonObject.addProperty("starttime", (Number)startTimestamp);
        jsonObject.addProperty("endtime", (Number)endTimestamp);
        for (String userid : userIdList) {
            jsonArray.add(userid);
        }
        jsonObject.add("useridlist", (JsonElement)jsonArray);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/checkin/getcheckin_daydata");
        String responseContent = this.mainService.post(url, jsonObject.toString());
        JsonObject tmpJson = GsonParser.parse((String)responseContent);
        return (List)WxCpGsonBuilder.create().fromJson(tmpJson.get("datas"), new TypeToken<List<WxCpCheckinDayData>>(){}.getType());
    }

    @Override
    public List<WxCpCheckinMonthData> getCheckinMonthData(Date startTime, Date endTime, List<String> userIdList) throws WxErrorException {
        if (startTime == null || endTime == null) {
            throw new WxRuntimeException("starttime and endtime can't be null");
        }
        if (userIdList == null || userIdList.size() > 100) {
            throw new WxRuntimeException("\u7528\u6237\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u8d85\u8fc7 100 \u4e2a\uff0c\u82e5\u7528\u6237\u8d85\u8fc7 100 \u4e2a\uff0c\u8bf7\u5206\u6279\u83b7\u53d6");
        }
        long endTimestamp = endTime.getTime() / 1000L;
        long startTimestamp = startTime.getTime() / 1000L;
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        jsonObject.addProperty("starttime", (Number)startTimestamp);
        jsonObject.addProperty("endtime", (Number)endTimestamp);
        for (String userid : userIdList) {
            jsonArray.add(userid);
        }
        jsonObject.add("useridlist", (JsonElement)jsonArray);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/checkin/getcheckin_monthdata");
        String responseContent = this.mainService.post(url, jsonObject.toString());
        JsonObject tmpJson = GsonParser.parse((String)responseContent);
        return (List)WxCpGsonBuilder.create().fromJson(tmpJson.get("datas"), new TypeToken<List<WxCpCheckinMonthData>>(){}.getType());
    }

    @Override
    public List<WxCpCheckinSchedule> getCheckinScheduleList(Date startTime, Date endTime, List<String> userIdList) throws WxErrorException {
        if (startTime == null || endTime == null) {
            throw new WxRuntimeException("starttime and endtime can't be null");
        }
        if (userIdList == null || userIdList.size() > 100) {
            throw new WxRuntimeException("\u7528\u6237\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u8d85\u8fc7 100 \u4e2a\uff0c\u82e5\u7528\u6237\u8d85\u8fc7 100 \u4e2a\uff0c\u8bf7\u5206\u6279\u83b7\u53d6");
        }
        long endTimestamp = endTime.getTime() / 1000L;
        long startTimestamp = startTime.getTime() / 1000L;
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        jsonObject.addProperty("starttime", (Number)startTimestamp);
        jsonObject.addProperty("endtime", (Number)endTimestamp);
        for (String userid : userIdList) {
            jsonArray.add(userid);
        }
        jsonObject.add("useridlist", (JsonElement)jsonArray);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/checkin/getcheckinschedulist");
        String responseContent = this.mainService.post(url, jsonObject.toString());
        JsonObject tmpJson = GsonParser.parse((String)responseContent);
        return (List)WxCpGsonBuilder.create().fromJson(tmpJson.get("schedule_list"), new TypeToken<List<WxCpCheckinSchedule>>(){}.getType());
    }

    public WxCpOaServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }
}

