/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpKfService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpBaseResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfAccountAdd;
import me.chanjar.weixin.cp.bean.kf.WxCpKfAccountAddResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfAccountDel;
import me.chanjar.weixin.cp.bean.kf.WxCpKfAccountLink;
import me.chanjar.weixin.cp.bean.kf.WxCpKfAccountLinkResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfAccountListResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfAccountUpd;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;

public class WxCpKfServiceImpl
implements WxCpKfService {
    private final WxCpService cpService;

    @Override
    public WxCpKfAccountAddResp addAccount(WxCpKfAccountAdd add) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/account/add");
        String responseContent = this.cpService.post(url, WxCpGsonBuilder.create().toJson((Object)add));
        return WxCpKfAccountAddResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp updAccount(WxCpKfAccountUpd upd) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/account/update");
        String responseContent = this.cpService.post(url, WxCpGsonBuilder.create().toJson((Object)upd));
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp delAccount(WxCpKfAccountDel del) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/account/del");
        String responseContent = this.cpService.post(url, WxCpGsonBuilder.create().toJson((Object)del));
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfAccountListResp listAccount() throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/account/list");
        String responseContent = this.cpService.post(url, "{}");
        return WxCpKfAccountListResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfAccountLinkResp getAccountLink(WxCpKfAccountLink link) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/add_contact_way");
        String responseContent = this.cpService.post(url, WxCpGsonBuilder.create().toJson((Object)link));
        return WxCpKfAccountLinkResp.fromJson(responseContent);
    }

    public WxCpKfServiceImpl(WxCpService cpService) {
        this.cpService = cpService;
    }
}

