/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.bean.message;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.cp.bean.article.MpnewsArticle;
import me.chanjar.weixin.cp.bean.article.NewArticle;
import me.chanjar.weixin.cp.bean.messagebuilder.FileBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.ImageBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.MarkdownMsgBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.MiniProgramNoticeMsgBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.MpnewsBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.NewsBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.TaskCardBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.TemplateCardBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.TextBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.TextCardBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.VideoBuilder;
import me.chanjar.weixin.cp.bean.messagebuilder.VoiceBuilder;
import me.chanjar.weixin.cp.bean.taskcard.TaskCardButton;
import me.chanjar.weixin.cp.bean.templatecard.CheckboxOption;
import me.chanjar.weixin.cp.bean.templatecard.HorizontalContent;
import me.chanjar.weixin.cp.bean.templatecard.MultipleSelect;
import me.chanjar.weixin.cp.bean.templatecard.QuoteArea;
import me.chanjar.weixin.cp.bean.templatecard.TemplateCardButton;
import me.chanjar.weixin.cp.bean.templatecard.TemplateCardJump;
import me.chanjar.weixin.cp.bean.templatecard.VerticalContent;
import org.apache.commons.lang3.StringUtils;

public class WxCpMessage
implements Serializable {
    private static final long serialVersionUID = -2082278303476631708L;
    private String toUser;
    private String toParty;
    private String toTag;
    private Integer agentId;
    private String msgType;
    private String content;
    private String mediaId;
    private String thumbMediaId;
    private String title;
    private String description;
    private String musicUrl;
    private String hqMusicUrl;
    private String safe;
    private String url;
    private String btnTxt;
    private List<NewArticle> articles = new ArrayList<NewArticle>();
    private List<MpnewsArticle> mpnewsArticles = new ArrayList<MpnewsArticle>();
    private String appId;
    private String page;
    private Boolean emphasisFirstItem;
    private Map<String, String> contentItems;
    private Boolean enableIdTrans = false;
    private Boolean enableDuplicateCheck = false;
    private Integer duplicateCheckInterval;
    private String taskId;
    private List<TaskCardButton> taskButtons = new ArrayList<TaskCardButton>();
    private String card_type;
    private String source_icon_url;
    private String source_desc;
    private String main_title_title;
    private String main_title_desc;
    private String card_image_url;
    private Float card_image_aspect_ratio;
    private String emphasis_content_title;
    private String emphasis_content_desc;
    private String sub_title_text;
    private List<VerticalContent> vertical_contents;
    private List<HorizontalContent> horizontal_contents;
    private List<TemplateCardJump> jumps;
    private Integer card_action_type;
    private String card_action_url;
    private String card_action_appid;
    private String card_action_pagepath;
    private List<TemplateCardButton> buttons;
    private String checkbox_question_key;
    private Integer checkbox_mode;
    private List<CheckboxOption> options;
    private String submit_button_text;
    private String submit_button_key;
    private List<MultipleSelect> selects;
    private QuoteArea quoteArea;

    public static TextBuilder TEXT() {
        return new TextBuilder();
    }

    public static TextCardBuilder TEXTCARD() {
        return new TextCardBuilder();
    }

    public static ImageBuilder IMAGE() {
        return new ImageBuilder();
    }

    public static VoiceBuilder VOICE() {
        return new VoiceBuilder();
    }

    public static VideoBuilder VIDEO() {
        return new VideoBuilder();
    }

    public static NewsBuilder NEWS() {
        return new NewsBuilder();
    }

    public static MpnewsBuilder MPNEWS() {
        return new MpnewsBuilder();
    }

    public static MarkdownMsgBuilder MARKDOWN() {
        return new MarkdownMsgBuilder();
    }

    public static FileBuilder FILE() {
        return new FileBuilder();
    }

    public static TaskCardBuilder TASKCARD() {
        return new TaskCardBuilder();
    }

    public static TemplateCardBuilder TEMPLATECARD() {
        return new TemplateCardBuilder();
    }

    public static MiniProgramNoticeMsgBuilder newMiniProgramNoticeBuilder() {
        return new MiniProgramNoticeMsgBuilder();
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String toJson() {
        JsonObject messageJson = new JsonObject();
        if (this.getAgentId() != null) {
            messageJson.addProperty("agentid", (Number)this.getAgentId());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getToUser())) {
            messageJson.addProperty("touser", this.getToUser());
        }
        messageJson.addProperty("msgtype", this.getMsgType());
        if (StringUtils.isNotBlank((CharSequence)this.getToParty())) {
            messageJson.addProperty("toparty", this.getToParty());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getToTag())) {
            messageJson.addProperty("totag", this.getToTag());
        }
        if (this.getEnableIdTrans().booleanValue()) {
            messageJson.addProperty("enable_id_trans", (Number)1);
        }
        if (this.getEnableDuplicateCheck().booleanValue()) {
            messageJson.addProperty("enable_duplicate_check", (Number)1);
        }
        if (this.getDuplicateCheckInterval() != null) {
            messageJson.addProperty("duplicate_check_interval", (Number)this.getDuplicateCheckInterval());
        }
        this.handleMsgType(messageJson);
        if (StringUtils.isNotBlank((CharSequence)this.getSafe())) {
            messageJson.addProperty("safe", this.getSafe());
        }
        return messageJson.toString();
    }

    private void handleMsgType(JsonObject messageJson) {
        switch (this.getMsgType()) {
            case "text": {
                JsonObject text = new JsonObject();
                text.addProperty("content", this.getContent());
                messageJson.add("text", (JsonElement)text);
                break;
            }
            case "markdown": {
                JsonObject text = new JsonObject();
                text.addProperty("content", this.getContent());
                messageJson.add("markdown", (JsonElement)text);
                break;
            }
            case "textcard": {
                JsonObject text = new JsonObject();
                text.addProperty("title", this.getTitle());
                text.addProperty("description", this.getDescription());
                text.addProperty("url", this.getUrl());
                text.addProperty("btntxt", this.getBtnTxt());
                messageJson.add("textcard", (JsonElement)text);
                break;
            }
            case "image": {
                JsonObject image = new JsonObject();
                image.addProperty("media_id", this.getMediaId());
                messageJson.add("image", (JsonElement)image);
                break;
            }
            case "file": {
                JsonObject image = new JsonObject();
                image.addProperty("media_id", this.getMediaId());
                messageJson.add("file", (JsonElement)image);
                break;
            }
            case "voice": {
                JsonObject voice = new JsonObject();
                voice.addProperty("media_id", this.getMediaId());
                messageJson.add("voice", (JsonElement)voice);
                break;
            }
            case "video": {
                JsonObject video = new JsonObject();
                video.addProperty("media_id", this.getMediaId());
                video.addProperty("thumb_media_id", this.getThumbMediaId());
                video.addProperty("title", this.getTitle());
                video.addProperty("description", this.getDescription());
                messageJson.add("video", (JsonElement)video);
                break;
            }
            case "news": {
                JsonObject newsJsonObject = new JsonObject();
                JsonArray articleJsonArray = new JsonArray();
                for (NewArticle article : this.getArticles()) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("title", article.getTitle());
                    jsonObject.addProperty("description", article.getDescription());
                    jsonObject.addProperty("url", article.getUrl());
                    jsonObject.addProperty("picurl", article.getPicUrl());
                    articleJsonArray.add((JsonElement)jsonObject);
                }
                newsJsonObject.add("articles", (JsonElement)articleJsonArray);
                messageJson.add("news", (JsonElement)newsJsonObject);
                break;
            }
            case "mpnews": {
                JsonObject newsJsonObject = new JsonObject();
                if (this.getMediaId() != null) {
                    newsJsonObject.addProperty("media_id", this.getMediaId());
                } else {
                    JsonArray articleJsonArray = new JsonArray();
                    for (MpnewsArticle article : this.getMpnewsArticles()) {
                        this.article2Json(articleJsonArray, article);
                    }
                    newsJsonObject.add("articles", (JsonElement)articleJsonArray);
                }
                messageJson.add("mpnews", (JsonElement)newsJsonObject);
                break;
            }
            case "taskcard": {
                JsonObject text = new JsonObject();
                text.addProperty("title", this.getTitle());
                text.addProperty("description", this.getDescription());
                if (StringUtils.isNotBlank((CharSequence)this.getUrl())) {
                    text.addProperty("url", this.getUrl());
                }
                text.addProperty("task_id", this.getTaskId());
                JsonArray buttonJsonArray = new JsonArray();
                for (TaskCardButton button : this.getTaskButtons()) {
                    this.btn2Json(buttonJsonArray, button);
                }
                text.add("btn", (JsonElement)buttonJsonArray);
                messageJson.add("taskcard", (JsonElement)text);
                break;
            }
            case "miniprogram_notice": {
                JsonObject notice = new JsonObject();
                notice.addProperty("appid", this.getAppId());
                notice.addProperty("page", this.getPage());
                notice.addProperty("description", this.getDescription());
                notice.addProperty("title", this.getTitle());
                notice.addProperty("emphasis_first_item", this.getEmphasisFirstItem());
                JsonArray content = new JsonArray();
                for (Map.Entry<String, String> item : this.getContentItems().entrySet()) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("key", item.getKey());
                    jsonObject.addProperty("value", item.getValue());
                    content.add((JsonElement)jsonObject);
                }
                notice.add("content_item", (JsonElement)content);
                messageJson.add("miniprogram_notice", (JsonElement)notice);
                break;
            }
            case "template_card": {
                QuoteArea quoteArea;
                List<MultipleSelect> list;
                JsonObject tempObject;
                List<TemplateCardButton> list2;
                List<TemplateCardJump> jumps;
                List<HorizontalContent> horizontalContents;
                List<VerticalContent> verticalContents;
                JsonObject template = new JsonObject();
                template.addProperty("card_type", this.getCard_type());
                if (StringUtils.isNotBlank((CharSequence)this.getSource_icon_url()) || StringUtils.isNotBlank((CharSequence)this.getSource_desc())) {
                    JsonObject source = new JsonObject();
                    if (StringUtils.isNotBlank((CharSequence)this.getSource_icon_url())) {
                        source.addProperty("icon_url", this.getSource_icon_url());
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.getSource_desc())) {
                        source.addProperty("desc", this.getSource_desc());
                    }
                    template.add("source", (JsonElement)source);
                }
                if (StringUtils.isNotBlank((CharSequence)this.getMain_title_title()) || StringUtils.isNotBlank((CharSequence)this.getMain_title_desc())) {
                    JsonObject main_title = new JsonObject();
                    if (StringUtils.isNotBlank((CharSequence)this.getMain_title_title())) {
                        main_title.addProperty("title", this.getMain_title_title());
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.getMain_title_desc())) {
                        main_title.addProperty("desc", this.getMain_title_desc());
                    }
                    template.add("main_title", (JsonElement)main_title);
                }
                if (StringUtils.isNotBlank((CharSequence)this.getEmphasis_content_title()) || StringUtils.isNotBlank((CharSequence)this.getEmphasis_content_desc())) {
                    JsonObject emphasis_content = new JsonObject();
                    if (StringUtils.isNotBlank((CharSequence)this.getEmphasis_content_title())) {
                        emphasis_content.addProperty("title", this.getEmphasis_content_title());
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.getEmphasis_content_desc())) {
                        emphasis_content.addProperty("desc", this.getEmphasis_content_desc());
                    }
                    template.add("emphasis_content", (JsonElement)emphasis_content);
                }
                if (StringUtils.isNotBlank((CharSequence)this.getSub_title_text())) {
                    template.addProperty("sub_title_text", this.getSub_title_text());
                }
                if (StringUtils.isNotBlank((CharSequence)this.getTaskId())) {
                    template.addProperty("task_id", this.getTaskId());
                }
                if (null != (verticalContents = this.getVertical_contents()) && verticalContents.size() > 0) {
                    JsonArray vContentJsonArray = new JsonArray();
                    for (VerticalContent verticalContent : this.getVertical_contents()) {
                        JsonObject jsonObject = verticalContent.toJson();
                        vContentJsonArray.add((JsonElement)jsonObject);
                    }
                    template.add("vertical_content_list", (JsonElement)vContentJsonArray);
                }
                if (null != (horizontalContents = this.getHorizontal_contents()) && horizontalContents.size() > 0) {
                    JsonArray hContentJsonArray = new JsonArray();
                    for (HorizontalContent horizontalContent : this.getHorizontal_contents()) {
                        JsonObject jsonObject = horizontalContent.toJson();
                        hContentJsonArray.add((JsonElement)jsonObject);
                    }
                    template.add("horizontal_content_list", (JsonElement)hContentJsonArray);
                }
                if (null != (jumps = this.getJumps()) && jumps.size() > 0) {
                    JsonArray jsonArray = new JsonArray();
                    for (TemplateCardJump templateCardJump : this.getJumps()) {
                        JsonObject jsonObject = templateCardJump.toJson();
                        jsonArray.add((JsonElement)jsonObject);
                    }
                    template.add("jump_list", (JsonElement)jsonArray);
                }
                if (null != this.getCard_action_type()) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("type", (Number)this.getCard_action_type());
                    if (StringUtils.isNotBlank((CharSequence)this.getCard_action_url())) {
                        jsonObject.addProperty("url", this.getCard_action_url());
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.getCard_action_appid())) {
                        jsonObject.addProperty("appid", this.getCard_action_appid());
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.getCard_action_pagepath())) {
                        jsonObject.addProperty("pagepath", this.getCard_action_pagepath());
                    }
                    template.add("card_action", (JsonElement)jsonObject);
                }
                if (null != (list2 = this.getButtons()) && list2.size() > 0) {
                    JsonArray jsonArray = new JsonArray();
                    for (TemplateCardButton templateCardButton : this.getButtons()) {
                        JsonObject tempObject5 = templateCardButton.toJson();
                        jsonArray.add((JsonElement)tempObject5);
                    }
                    template.add("button_list", (JsonElement)jsonArray);
                }
                if (StringUtils.isNotBlank((CharSequence)this.getCheckbox_question_key())) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("question_key", this.getCheckbox_question_key());
                    if (null != this.getCheckbox_mode()) {
                        jsonObject.addProperty("mode", (Number)this.getCheckbox_mode());
                    }
                    JsonArray jsonArray = new JsonArray();
                    for (CheckboxOption option : this.getOptions()) {
                        tempObject = option.toJson();
                        jsonArray.add((JsonElement)tempObject);
                    }
                    jsonObject.add("option_list", (JsonElement)jsonArray);
                    template.add("checkbox", (JsonElement)jsonObject);
                }
                if (StringUtils.isNotBlank((CharSequence)this.getSubmit_button_text()) || StringUtils.isNotBlank((CharSequence)this.getSubmit_button_key())) {
                    JsonObject jsonObject = new JsonObject();
                    if (StringUtils.isNotBlank((CharSequence)this.getSubmit_button_text())) {
                        jsonObject.addProperty("text", this.getSubmit_button_text());
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.getSubmit_button_key())) {
                        jsonObject.addProperty("key", this.getSubmit_button_key());
                    }
                    template.add("submit_button", (JsonElement)jsonObject);
                }
                if (null != (list = this.getSelects()) && list.size() > 0) {
                    JsonArray jsonArray = new JsonArray();
                    for (MultipleSelect select : this.getSelects()) {
                        tempObject = select.toJson();
                        jsonArray.add((JsonElement)tempObject);
                    }
                    template.add("select_list", (JsonElement)jsonArray);
                }
                if (null != (quoteArea = this.getQuoteArea())) {
                    JsonObject jsonObject = quoteArea.toJson();
                    template.add("quote_area", (JsonElement)jsonObject);
                }
                messageJson.add("template_card", (JsonElement)template);
                break;
            }
        }
    }

    private void btn2Json(JsonArray buttonJsonArray, TaskCardButton button) {
        JsonObject buttonJson = new JsonObject();
        buttonJson.addProperty("key", button.getKey());
        buttonJson.addProperty("name", button.getName());
        if (StringUtils.isNotBlank((CharSequence)button.getReplaceName())) {
            buttonJson.addProperty("replace_name", button.getReplaceName());
        }
        if (StringUtils.isNotBlank((CharSequence)button.getColor())) {
            buttonJson.addProperty("color", button.getColor());
        }
        if (button.getBold() != null) {
            buttonJson.addProperty("is_bold", button.getBold());
        }
        buttonJsonArray.add((JsonElement)buttonJson);
    }

    private void article2Json(JsonArray articleJsonArray, MpnewsArticle article) {
        JsonObject articleJson = new JsonObject();
        articleJson.addProperty("title", article.getTitle());
        articleJson.addProperty("thumb_media_id", article.getThumbMediaId());
        articleJson.addProperty("author", article.getAuthor());
        articleJson.addProperty("content_source_url", article.getContentSourceUrl());
        articleJson.addProperty("content", article.getContent());
        articleJson.addProperty("digest", article.getDigest());
        articleJson.addProperty("show_cover_pic", article.getShowCoverPic());
        articleJsonArray.add((JsonElement)articleJson);
    }

    public String getToUser() {
        return this.toUser;
    }

    public String getToParty() {
        return this.toParty;
    }

    public String getToTag() {
        return this.toTag;
    }

    public Integer getAgentId() {
        return this.agentId;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public String getContent() {
        return this.content;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public String getThumbMediaId() {
        return this.thumbMediaId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMusicUrl() {
        return this.musicUrl;
    }

    public String getHqMusicUrl() {
        return this.hqMusicUrl;
    }

    public String getSafe() {
        return this.safe;
    }

    public String getUrl() {
        return this.url;
    }

    public String getBtnTxt() {
        return this.btnTxt;
    }

    public List<NewArticle> getArticles() {
        return this.articles;
    }

    public List<MpnewsArticle> getMpnewsArticles() {
        return this.mpnewsArticles;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getPage() {
        return this.page;
    }

    public Boolean getEmphasisFirstItem() {
        return this.emphasisFirstItem;
    }

    public Map<String, String> getContentItems() {
        return this.contentItems;
    }

    public Boolean getEnableIdTrans() {
        return this.enableIdTrans;
    }

    public Boolean getEnableDuplicateCheck() {
        return this.enableDuplicateCheck;
    }

    public Integer getDuplicateCheckInterval() {
        return this.duplicateCheckInterval;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public List<TaskCardButton> getTaskButtons() {
        return this.taskButtons;
    }

    public String getCard_type() {
        return this.card_type;
    }

    public String getSource_icon_url() {
        return this.source_icon_url;
    }

    public String getSource_desc() {
        return this.source_desc;
    }

    public String getMain_title_title() {
        return this.main_title_title;
    }

    public String getMain_title_desc() {
        return this.main_title_desc;
    }

    public String getCard_image_url() {
        return this.card_image_url;
    }

    public Float getCard_image_aspect_ratio() {
        return this.card_image_aspect_ratio;
    }

    public String getEmphasis_content_title() {
        return this.emphasis_content_title;
    }

    public String getEmphasis_content_desc() {
        return this.emphasis_content_desc;
    }

    public String getSub_title_text() {
        return this.sub_title_text;
    }

    public List<VerticalContent> getVertical_contents() {
        return this.vertical_contents;
    }

    public List<HorizontalContent> getHorizontal_contents() {
        return this.horizontal_contents;
    }

    public List<TemplateCardJump> getJumps() {
        return this.jumps;
    }

    public Integer getCard_action_type() {
        return this.card_action_type;
    }

    public String getCard_action_url() {
        return this.card_action_url;
    }

    public String getCard_action_appid() {
        return this.card_action_appid;
    }

    public String getCard_action_pagepath() {
        return this.card_action_pagepath;
    }

    public List<TemplateCardButton> getButtons() {
        return this.buttons;
    }

    public String getCheckbox_question_key() {
        return this.checkbox_question_key;
    }

    public Integer getCheckbox_mode() {
        return this.checkbox_mode;
    }

    public List<CheckboxOption> getOptions() {
        return this.options;
    }

    public String getSubmit_button_text() {
        return this.submit_button_text;
    }

    public String getSubmit_button_key() {
        return this.submit_button_key;
    }

    public List<MultipleSelect> getSelects() {
        return this.selects;
    }

    public QuoteArea getQuoteArea() {
        return this.quoteArea;
    }

    public void setToUser(String toUser) {
        this.toUser = toUser;
    }

    public void setToParty(String toParty) {
        this.toParty = toParty;
    }

    public void setToTag(String toTag) {
        this.toTag = toTag;
    }

    public void setAgentId(Integer agentId) {
        this.agentId = agentId;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public void setThumbMediaId(String thumbMediaId) {
        this.thumbMediaId = thumbMediaId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMusicUrl(String musicUrl) {
        this.musicUrl = musicUrl;
    }

    public void setHqMusicUrl(String hqMusicUrl) {
        this.hqMusicUrl = hqMusicUrl;
    }

    public void setSafe(String safe) {
        this.safe = safe;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setBtnTxt(String btnTxt) {
        this.btnTxt = btnTxt;
    }

    public void setArticles(List<NewArticle> articles) {
        this.articles = articles;
    }

    public void setMpnewsArticles(List<MpnewsArticle> mpnewsArticles) {
        this.mpnewsArticles = mpnewsArticles;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public void setEmphasisFirstItem(Boolean emphasisFirstItem) {
        this.emphasisFirstItem = emphasisFirstItem;
    }

    public void setContentItems(Map<String, String> contentItems) {
        this.contentItems = contentItems;
    }

    public void setEnableIdTrans(Boolean enableIdTrans) {
        this.enableIdTrans = enableIdTrans;
    }

    public void setEnableDuplicateCheck(Boolean enableDuplicateCheck) {
        this.enableDuplicateCheck = enableDuplicateCheck;
    }

    public void setDuplicateCheckInterval(Integer duplicateCheckInterval) {
        this.duplicateCheckInterval = duplicateCheckInterval;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setTaskButtons(List<TaskCardButton> taskButtons) {
        this.taskButtons = taskButtons;
    }

    public void setCard_type(String card_type) {
        this.card_type = card_type;
    }

    public void setSource_icon_url(String source_icon_url) {
        this.source_icon_url = source_icon_url;
    }

    public void setSource_desc(String source_desc) {
        this.source_desc = source_desc;
    }

    public void setMain_title_title(String main_title_title) {
        this.main_title_title = main_title_title;
    }

    public void setMain_title_desc(String main_title_desc) {
        this.main_title_desc = main_title_desc;
    }

    public void setCard_image_url(String card_image_url) {
        this.card_image_url = card_image_url;
    }

    public void setCard_image_aspect_ratio(Float card_image_aspect_ratio) {
        this.card_image_aspect_ratio = card_image_aspect_ratio;
    }

    public void setEmphasis_content_title(String emphasis_content_title) {
        this.emphasis_content_title = emphasis_content_title;
    }

    public void setEmphasis_content_desc(String emphasis_content_desc) {
        this.emphasis_content_desc = emphasis_content_desc;
    }

    public void setSub_title_text(String sub_title_text) {
        this.sub_title_text = sub_title_text;
    }

    public void setVertical_contents(List<VerticalContent> vertical_contents) {
        this.vertical_contents = vertical_contents;
    }

    public void setHorizontal_contents(List<HorizontalContent> horizontal_contents) {
        this.horizontal_contents = horizontal_contents;
    }

    public void setJumps(List<TemplateCardJump> jumps) {
        this.jumps = jumps;
    }

    public void setCard_action_type(Integer card_action_type) {
        this.card_action_type = card_action_type;
    }

    public void setCard_action_url(String card_action_url) {
        this.card_action_url = card_action_url;
    }

    public void setCard_action_appid(String card_action_appid) {
        this.card_action_appid = card_action_appid;
    }

    public void setCard_action_pagepath(String card_action_pagepath) {
        this.card_action_pagepath = card_action_pagepath;
    }

    public void setButtons(List<TemplateCardButton> buttons) {
        this.buttons = buttons;
    }

    public void setCheckbox_question_key(String checkbox_question_key) {
        this.checkbox_question_key = checkbox_question_key;
    }

    public void setCheckbox_mode(Integer checkbox_mode) {
        this.checkbox_mode = checkbox_mode;
    }

    public void setOptions(List<CheckboxOption> options) {
        this.options = options;
    }

    public void setSubmit_button_text(String submit_button_text) {
        this.submit_button_text = submit_button_text;
    }

    public void setSubmit_button_key(String submit_button_key) {
        this.submit_button_key = submit_button_key;
    }

    public void setSelects(List<MultipleSelect> selects) {
        this.selects = selects;
    }

    public void setQuoteArea(QuoteArea quoteArea) {
        this.quoteArea = quoteArea;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxCpMessage)) {
            return false;
        }
        WxCpMessage other = (WxCpMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$toUser = this.getToUser();
        String other$toUser = other.getToUser();
        if (this$toUser == null ? other$toUser != null : !this$toUser.equals(other$toUser)) {
            return false;
        }
        String this$toParty = this.getToParty();
        String other$toParty = other.getToParty();
        if (this$toParty == null ? other$toParty != null : !this$toParty.equals(other$toParty)) {
            return false;
        }
        String this$toTag = this.getToTag();
        String other$toTag = other.getToTag();
        if (this$toTag == null ? other$toTag != null : !this$toTag.equals(other$toTag)) {
            return false;
        }
        Integer this$agentId = this.getAgentId();
        Integer other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !((Object)this$agentId).equals(other$agentId)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$mediaId = this.getMediaId();
        String other$mediaId = other.getMediaId();
        if (this$mediaId == null ? other$mediaId != null : !this$mediaId.equals(other$mediaId)) {
            return false;
        }
        String this$thumbMediaId = this.getThumbMediaId();
        String other$thumbMediaId = other.getThumbMediaId();
        if (this$thumbMediaId == null ? other$thumbMediaId != null : !this$thumbMediaId.equals(other$thumbMediaId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$musicUrl = this.getMusicUrl();
        String other$musicUrl = other.getMusicUrl();
        if (this$musicUrl == null ? other$musicUrl != null : !this$musicUrl.equals(other$musicUrl)) {
            return false;
        }
        String this$hqMusicUrl = this.getHqMusicUrl();
        String other$hqMusicUrl = other.getHqMusicUrl();
        if (this$hqMusicUrl == null ? other$hqMusicUrl != null : !this$hqMusicUrl.equals(other$hqMusicUrl)) {
            return false;
        }
        String this$safe = this.getSafe();
        String other$safe = other.getSafe();
        if (this$safe == null ? other$safe != null : !this$safe.equals(other$safe)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$btnTxt = this.getBtnTxt();
        String other$btnTxt = other.getBtnTxt();
        if (this$btnTxt == null ? other$btnTxt != null : !this$btnTxt.equals(other$btnTxt)) {
            return false;
        }
        List<NewArticle> this$articles = this.getArticles();
        List<NewArticle> other$articles = other.getArticles();
        if (this$articles == null ? other$articles != null : !((Object)this$articles).equals(other$articles)) {
            return false;
        }
        List<MpnewsArticle> this$mpnewsArticles = this.getMpnewsArticles();
        List<MpnewsArticle> other$mpnewsArticles = other.getMpnewsArticles();
        if (this$mpnewsArticles == null ? other$mpnewsArticles != null : !((Object)this$mpnewsArticles).equals(other$mpnewsArticles)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        Boolean this$emphasisFirstItem = this.getEmphasisFirstItem();
        Boolean other$emphasisFirstItem = other.getEmphasisFirstItem();
        if (this$emphasisFirstItem == null ? other$emphasisFirstItem != null : !((Object)this$emphasisFirstItem).equals(other$emphasisFirstItem)) {
            return false;
        }
        Map<String, String> this$contentItems = this.getContentItems();
        Map<String, String> other$contentItems = other.getContentItems();
        if (this$contentItems == null ? other$contentItems != null : !((Object)this$contentItems).equals(other$contentItems)) {
            return false;
        }
        Boolean this$enableIdTrans = this.getEnableIdTrans();
        Boolean other$enableIdTrans = other.getEnableIdTrans();
        if (this$enableIdTrans == null ? other$enableIdTrans != null : !((Object)this$enableIdTrans).equals(other$enableIdTrans)) {
            return false;
        }
        Boolean this$enableDuplicateCheck = this.getEnableDuplicateCheck();
        Boolean other$enableDuplicateCheck = other.getEnableDuplicateCheck();
        if (this$enableDuplicateCheck == null ? other$enableDuplicateCheck != null : !((Object)this$enableDuplicateCheck).equals(other$enableDuplicateCheck)) {
            return false;
        }
        Integer this$duplicateCheckInterval = this.getDuplicateCheckInterval();
        Integer other$duplicateCheckInterval = other.getDuplicateCheckInterval();
        if (this$duplicateCheckInterval == null ? other$duplicateCheckInterval != null : !((Object)this$duplicateCheckInterval).equals(other$duplicateCheckInterval)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        List<TaskCardButton> this$taskButtons = this.getTaskButtons();
        List<TaskCardButton> other$taskButtons = other.getTaskButtons();
        if (this$taskButtons == null ? other$taskButtons != null : !((Object)this$taskButtons).equals(other$taskButtons)) {
            return false;
        }
        String this$card_type = this.getCard_type();
        String other$card_type = other.getCard_type();
        if (this$card_type == null ? other$card_type != null : !this$card_type.equals(other$card_type)) {
            return false;
        }
        String this$source_icon_url = this.getSource_icon_url();
        String other$source_icon_url = other.getSource_icon_url();
        if (this$source_icon_url == null ? other$source_icon_url != null : !this$source_icon_url.equals(other$source_icon_url)) {
            return false;
        }
        String this$source_desc = this.getSource_desc();
        String other$source_desc = other.getSource_desc();
        if (this$source_desc == null ? other$source_desc != null : !this$source_desc.equals(other$source_desc)) {
            return false;
        }
        String this$main_title_title = this.getMain_title_title();
        String other$main_title_title = other.getMain_title_title();
        if (this$main_title_title == null ? other$main_title_title != null : !this$main_title_title.equals(other$main_title_title)) {
            return false;
        }
        String this$main_title_desc = this.getMain_title_desc();
        String other$main_title_desc = other.getMain_title_desc();
        if (this$main_title_desc == null ? other$main_title_desc != null : !this$main_title_desc.equals(other$main_title_desc)) {
            return false;
        }
        String this$card_image_url = this.getCard_image_url();
        String other$card_image_url = other.getCard_image_url();
        if (this$card_image_url == null ? other$card_image_url != null : !this$card_image_url.equals(other$card_image_url)) {
            return false;
        }
        Float this$card_image_aspect_ratio = this.getCard_image_aspect_ratio();
        Float other$card_image_aspect_ratio = other.getCard_image_aspect_ratio();
        if (this$card_image_aspect_ratio == null ? other$card_image_aspect_ratio != null : !((Object)this$card_image_aspect_ratio).equals(other$card_image_aspect_ratio)) {
            return false;
        }
        String this$emphasis_content_title = this.getEmphasis_content_title();
        String other$emphasis_content_title = other.getEmphasis_content_title();
        if (this$emphasis_content_title == null ? other$emphasis_content_title != null : !this$emphasis_content_title.equals(other$emphasis_content_title)) {
            return false;
        }
        String this$emphasis_content_desc = this.getEmphasis_content_desc();
        String other$emphasis_content_desc = other.getEmphasis_content_desc();
        if (this$emphasis_content_desc == null ? other$emphasis_content_desc != null : !this$emphasis_content_desc.equals(other$emphasis_content_desc)) {
            return false;
        }
        String this$sub_title_text = this.getSub_title_text();
        String other$sub_title_text = other.getSub_title_text();
        if (this$sub_title_text == null ? other$sub_title_text != null : !this$sub_title_text.equals(other$sub_title_text)) {
            return false;
        }
        List<VerticalContent> this$vertical_contents = this.getVertical_contents();
        List<VerticalContent> other$vertical_contents = other.getVertical_contents();
        if (this$vertical_contents == null ? other$vertical_contents != null : !((Object)this$vertical_contents).equals(other$vertical_contents)) {
            return false;
        }
        List<HorizontalContent> this$horizontal_contents = this.getHorizontal_contents();
        List<HorizontalContent> other$horizontal_contents = other.getHorizontal_contents();
        if (this$horizontal_contents == null ? other$horizontal_contents != null : !((Object)this$horizontal_contents).equals(other$horizontal_contents)) {
            return false;
        }
        List<TemplateCardJump> this$jumps = this.getJumps();
        List<TemplateCardJump> other$jumps = other.getJumps();
        if (this$jumps == null ? other$jumps != null : !((Object)this$jumps).equals(other$jumps)) {
            return false;
        }
        Integer this$card_action_type = this.getCard_action_type();
        Integer other$card_action_type = other.getCard_action_type();
        if (this$card_action_type == null ? other$card_action_type != null : !((Object)this$card_action_type).equals(other$card_action_type)) {
            return false;
        }
        String this$card_action_url = this.getCard_action_url();
        String other$card_action_url = other.getCard_action_url();
        if (this$card_action_url == null ? other$card_action_url != null : !this$card_action_url.equals(other$card_action_url)) {
            return false;
        }
        String this$card_action_appid = this.getCard_action_appid();
        String other$card_action_appid = other.getCard_action_appid();
        if (this$card_action_appid == null ? other$card_action_appid != null : !this$card_action_appid.equals(other$card_action_appid)) {
            return false;
        }
        String this$card_action_pagepath = this.getCard_action_pagepath();
        String other$card_action_pagepath = other.getCard_action_pagepath();
        if (this$card_action_pagepath == null ? other$card_action_pagepath != null : !this$card_action_pagepath.equals(other$card_action_pagepath)) {
            return false;
        }
        List<TemplateCardButton> this$buttons = this.getButtons();
        List<TemplateCardButton> other$buttons = other.getButtons();
        if (this$buttons == null ? other$buttons != null : !((Object)this$buttons).equals(other$buttons)) {
            return false;
        }
        String this$checkbox_question_key = this.getCheckbox_question_key();
        String other$checkbox_question_key = other.getCheckbox_question_key();
        if (this$checkbox_question_key == null ? other$checkbox_question_key != null : !this$checkbox_question_key.equals(other$checkbox_question_key)) {
            return false;
        }
        Integer this$checkbox_mode = this.getCheckbox_mode();
        Integer other$checkbox_mode = other.getCheckbox_mode();
        if (this$checkbox_mode == null ? other$checkbox_mode != null : !((Object)this$checkbox_mode).equals(other$checkbox_mode)) {
            return false;
        }
        List<CheckboxOption> this$options = this.getOptions();
        List<CheckboxOption> other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        String this$submit_button_text = this.getSubmit_button_text();
        String other$submit_button_text = other.getSubmit_button_text();
        if (this$submit_button_text == null ? other$submit_button_text != null : !this$submit_button_text.equals(other$submit_button_text)) {
            return false;
        }
        String this$submit_button_key = this.getSubmit_button_key();
        String other$submit_button_key = other.getSubmit_button_key();
        if (this$submit_button_key == null ? other$submit_button_key != null : !this$submit_button_key.equals(other$submit_button_key)) {
            return false;
        }
        List<MultipleSelect> this$selects = this.getSelects();
        List<MultipleSelect> other$selects = other.getSelects();
        if (this$selects == null ? other$selects != null : !((Object)this$selects).equals(other$selects)) {
            return false;
        }
        QuoteArea this$quoteArea = this.getQuoteArea();
        QuoteArea other$quoteArea = other.getQuoteArea();
        return !(this$quoteArea == null ? other$quoteArea != null : !((Object)this$quoteArea).equals(other$quoteArea));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxCpMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $toUser = this.getToUser();
        result = result * 59 + ($toUser == null ? 43 : $toUser.hashCode());
        String $toParty = this.getToParty();
        result = result * 59 + ($toParty == null ? 43 : $toParty.hashCode());
        String $toTag = this.getToTag();
        result = result * 59 + ($toTag == null ? 43 : $toTag.hashCode());
        Integer $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : ((Object)$agentId).hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $mediaId = this.getMediaId();
        result = result * 59 + ($mediaId == null ? 43 : $mediaId.hashCode());
        String $thumbMediaId = this.getThumbMediaId();
        result = result * 59 + ($thumbMediaId == null ? 43 : $thumbMediaId.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $musicUrl = this.getMusicUrl();
        result = result * 59 + ($musicUrl == null ? 43 : $musicUrl.hashCode());
        String $hqMusicUrl = this.getHqMusicUrl();
        result = result * 59 + ($hqMusicUrl == null ? 43 : $hqMusicUrl.hashCode());
        String $safe = this.getSafe();
        result = result * 59 + ($safe == null ? 43 : $safe.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $btnTxt = this.getBtnTxt();
        result = result * 59 + ($btnTxt == null ? 43 : $btnTxt.hashCode());
        List<NewArticle> $articles = this.getArticles();
        result = result * 59 + ($articles == null ? 43 : ((Object)$articles).hashCode());
        List<MpnewsArticle> $mpnewsArticles = this.getMpnewsArticles();
        result = result * 59 + ($mpnewsArticles == null ? 43 : ((Object)$mpnewsArticles).hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        Boolean $emphasisFirstItem = this.getEmphasisFirstItem();
        result = result * 59 + ($emphasisFirstItem == null ? 43 : ((Object)$emphasisFirstItem).hashCode());
        Map<String, String> $contentItems = this.getContentItems();
        result = result * 59 + ($contentItems == null ? 43 : ((Object)$contentItems).hashCode());
        Boolean $enableIdTrans = this.getEnableIdTrans();
        result = result * 59 + ($enableIdTrans == null ? 43 : ((Object)$enableIdTrans).hashCode());
        Boolean $enableDuplicateCheck = this.getEnableDuplicateCheck();
        result = result * 59 + ($enableDuplicateCheck == null ? 43 : ((Object)$enableDuplicateCheck).hashCode());
        Integer $duplicateCheckInterval = this.getDuplicateCheckInterval();
        result = result * 59 + ($duplicateCheckInterval == null ? 43 : ((Object)$duplicateCheckInterval).hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        List<TaskCardButton> $taskButtons = this.getTaskButtons();
        result = result * 59 + ($taskButtons == null ? 43 : ((Object)$taskButtons).hashCode());
        String $card_type = this.getCard_type();
        result = result * 59 + ($card_type == null ? 43 : $card_type.hashCode());
        String $source_icon_url = this.getSource_icon_url();
        result = result * 59 + ($source_icon_url == null ? 43 : $source_icon_url.hashCode());
        String $source_desc = this.getSource_desc();
        result = result * 59 + ($source_desc == null ? 43 : $source_desc.hashCode());
        String $main_title_title = this.getMain_title_title();
        result = result * 59 + ($main_title_title == null ? 43 : $main_title_title.hashCode());
        String $main_title_desc = this.getMain_title_desc();
        result = result * 59 + ($main_title_desc == null ? 43 : $main_title_desc.hashCode());
        String $card_image_url = this.getCard_image_url();
        result = result * 59 + ($card_image_url == null ? 43 : $card_image_url.hashCode());
        Float $card_image_aspect_ratio = this.getCard_image_aspect_ratio();
        result = result * 59 + ($card_image_aspect_ratio == null ? 43 : ((Object)$card_image_aspect_ratio).hashCode());
        String $emphasis_content_title = this.getEmphasis_content_title();
        result = result * 59 + ($emphasis_content_title == null ? 43 : $emphasis_content_title.hashCode());
        String $emphasis_content_desc = this.getEmphasis_content_desc();
        result = result * 59 + ($emphasis_content_desc == null ? 43 : $emphasis_content_desc.hashCode());
        String $sub_title_text = this.getSub_title_text();
        result = result * 59 + ($sub_title_text == null ? 43 : $sub_title_text.hashCode());
        List<VerticalContent> $vertical_contents = this.getVertical_contents();
        result = result * 59 + ($vertical_contents == null ? 43 : ((Object)$vertical_contents).hashCode());
        List<HorizontalContent> $horizontal_contents = this.getHorizontal_contents();
        result = result * 59 + ($horizontal_contents == null ? 43 : ((Object)$horizontal_contents).hashCode());
        List<TemplateCardJump> $jumps = this.getJumps();
        result = result * 59 + ($jumps == null ? 43 : ((Object)$jumps).hashCode());
        Integer $card_action_type = this.getCard_action_type();
        result = result * 59 + ($card_action_type == null ? 43 : ((Object)$card_action_type).hashCode());
        String $card_action_url = this.getCard_action_url();
        result = result * 59 + ($card_action_url == null ? 43 : $card_action_url.hashCode());
        String $card_action_appid = this.getCard_action_appid();
        result = result * 59 + ($card_action_appid == null ? 43 : $card_action_appid.hashCode());
        String $card_action_pagepath = this.getCard_action_pagepath();
        result = result * 59 + ($card_action_pagepath == null ? 43 : $card_action_pagepath.hashCode());
        List<TemplateCardButton> $buttons = this.getButtons();
        result = result * 59 + ($buttons == null ? 43 : ((Object)$buttons).hashCode());
        String $checkbox_question_key = this.getCheckbox_question_key();
        result = result * 59 + ($checkbox_question_key == null ? 43 : $checkbox_question_key.hashCode());
        Integer $checkbox_mode = this.getCheckbox_mode();
        result = result * 59 + ($checkbox_mode == null ? 43 : ((Object)$checkbox_mode).hashCode());
        List<CheckboxOption> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        String $submit_button_text = this.getSubmit_button_text();
        result = result * 59 + ($submit_button_text == null ? 43 : $submit_button_text.hashCode());
        String $submit_button_key = this.getSubmit_button_key();
        result = result * 59 + ($submit_button_key == null ? 43 : $submit_button_key.hashCode());
        List<MultipleSelect> $selects = this.getSelects();
        result = result * 59 + ($selects == null ? 43 : ((Object)$selects).hashCode());
        QuoteArea $quoteArea = this.getQuoteArea();
        result = result * 59 + ($quoteArea == null ? 43 : ((Object)$quoteArea).hashCode());
        return result;
    }

    public String toString() {
        return "WxCpMessage(toUser=" + this.getToUser() + ", toParty=" + this.getToParty() + ", toTag=" + this.getToTag() + ", agentId=" + this.getAgentId() + ", msgType=" + this.getMsgType() + ", content=" + this.getContent() + ", mediaId=" + this.getMediaId() + ", thumbMediaId=" + this.getThumbMediaId() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", musicUrl=" + this.getMusicUrl() + ", hqMusicUrl=" + this.getHqMusicUrl() + ", safe=" + this.getSafe() + ", url=" + this.getUrl() + ", btnTxt=" + this.getBtnTxt() + ", articles=" + this.getArticles() + ", mpnewsArticles=" + this.getMpnewsArticles() + ", appId=" + this.getAppId() + ", page=" + this.getPage() + ", emphasisFirstItem=" + this.getEmphasisFirstItem() + ", contentItems=" + this.getContentItems() + ", enableIdTrans=" + this.getEnableIdTrans() + ", enableDuplicateCheck=" + this.getEnableDuplicateCheck() + ", duplicateCheckInterval=" + this.getDuplicateCheckInterval() + ", taskId=" + this.getTaskId() + ", taskButtons=" + this.getTaskButtons() + ", card_type=" + this.getCard_type() + ", source_icon_url=" + this.getSource_icon_url() + ", source_desc=" + this.getSource_desc() + ", main_title_title=" + this.getMain_title_title() + ", main_title_desc=" + this.getMain_title_desc() + ", card_image_url=" + this.getCard_image_url() + ", card_image_aspect_ratio=" + this.getCard_image_aspect_ratio() + ", emphasis_content_title=" + this.getEmphasis_content_title() + ", emphasis_content_desc=" + this.getEmphasis_content_desc() + ", sub_title_text=" + this.getSub_title_text() + ", vertical_contents=" + this.getVertical_contents() + ", horizontal_contents=" + this.getHorizontal_contents() + ", jumps=" + this.getJumps() + ", card_action_type=" + this.getCard_action_type() + ", card_action_url=" + this.getCard_action_url() + ", card_action_appid=" + this.getCard_action_appid() + ", card_action_pagepath=" + this.getCard_action_pagepath() + ", buttons=" + this.getButtons() + ", checkbox_question_key=" + this.getCheckbox_question_key() + ", checkbox_mode=" + this.getCheckbox_mode() + ", options=" + this.getOptions() + ", submit_button_text=" + this.getSubmit_button_text() + ", submit_button_key=" + this.getSubmit_button_key() + ", selects=" + this.getSelects() + ", quoteArea=" + this.getQuoteArea() + ")";
    }
}

