/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpKfService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpBaseResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfAccountAdd;
import me.chanjar.weixin.cp.bean.kf.WxCpKfAccountAddResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfAccountDel;
import me.chanjar.weixin.cp.bean.kf.WxCpKfAccountLink;
import me.chanjar.weixin.cp.bean.kf.WxCpKfAccountLinkResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfAccountListResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfAccountUpd;
import me.chanjar.weixin.cp.bean.kf.WxCpKfCustomerBatchGetResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfGetCorpStatisticRequest;
import me.chanjar.weixin.cp.bean.kf.WxCpKfGetCorpStatisticResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfMsgListResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfMsgSendRequest;
import me.chanjar.weixin.cp.bean.kf.WxCpKfMsgSendResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfServiceStateResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfServiceStateTransResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfServicerListResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfServicerOpResp;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;

public class WxCpKfServiceImpl
implements WxCpKfService {
    private final WxCpService cpService;
    private static final Gson GSON = new GsonBuilder().create();

    @Override
    public WxCpKfAccountAddResp addAccount(WxCpKfAccountAdd add) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/account/add");
        String responseContent = this.cpService.post(url, WxCpGsonBuilder.create().toJson((Object)add));
        return WxCpKfAccountAddResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp updAccount(WxCpKfAccountUpd upd) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/account/update");
        String responseContent = this.cpService.post(url, WxCpGsonBuilder.create().toJson((Object)upd));
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp delAccount(WxCpKfAccountDel del) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/account/del");
        String responseContent = this.cpService.post(url, WxCpGsonBuilder.create().toJson((Object)del));
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfAccountListResp listAccount() throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/account/list");
        String responseContent = this.cpService.post(url, "{}");
        return WxCpKfAccountListResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfAccountLinkResp getAccountLink(WxCpKfAccountLink link) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/add_contact_way");
        String responseContent = this.cpService.post(url, WxCpGsonBuilder.create().toJson((Object)link));
        return WxCpKfAccountLinkResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfServicerOpResp addServicer(String openKfid, List<String> userIdList) throws WxErrorException {
        return this.servicerOp(openKfid, userIdList, "/cgi-bin/kf/servicer/add");
    }

    @Override
    public WxCpKfServicerOpResp delServicer(String openKfid, List<String> userIdList) throws WxErrorException {
        return this.servicerOp(openKfid, userIdList, "/cgi-bin/kf/servicer/del");
    }

    private WxCpKfServicerOpResp servicerOp(String openKfid, List<String> userIdList, String uri) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl(uri);
        JsonObject json = new JsonObject();
        json.addProperty("open_kfid", openKfid);
        JsonArray userIdArray = new JsonArray();
        userIdList.forEach(arg_0 -> ((JsonArray)userIdArray).add(arg_0));
        json.add("userid_list", (JsonElement)userIdArray);
        String responseContent = this.cpService.post(url, json.toString());
        return WxCpKfServicerOpResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfServicerListResp listServicer(String openKfid) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/servicer/list?open_kfid=" + openKfid);
        String responseContent = this.cpService.get(url, null);
        return WxCpKfServicerListResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfServiceStateResp getServiceState(String openKfid, String externalUserId) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/service_state/get");
        JsonObject json = new JsonObject();
        json.addProperty("open_kfid", openKfid);
        json.addProperty("external_userid", externalUserId);
        String responseContent = this.cpService.post(url, json.toString());
        return WxCpKfServiceStateResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfServiceStateTransResp transServiceState(String openKfid, String externalUserId, Integer serviceState, String servicerUserId) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/service_state/trans");
        JsonObject json = new JsonObject();
        json.addProperty("open_kfid", openKfid);
        json.addProperty("external_userid", externalUserId);
        json.addProperty("service_state", (Number)serviceState);
        json.addProperty("servicer_userid", servicerUserId);
        String responseContent = this.cpService.post(url, json.toString());
        return WxCpKfServiceStateTransResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfMsgListResp syncMsg(String cursor, String token, Integer limit, Integer voiceFormat) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/sync_msg");
        JsonObject json = new JsonObject();
        if (cursor != null) {
            json.addProperty("cursor", cursor);
        }
        if (token != null) {
            json.addProperty("token", token);
        }
        if (limit != null) {
            json.addProperty("limit", (Number)limit);
        }
        if (voiceFormat != null) {
            json.addProperty("voice_format", (Number)voiceFormat);
        }
        String responseContent = this.cpService.post(url, json);
        return WxCpKfMsgListResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfMsgSendResp sendMsg(WxCpKfMsgSendRequest request) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/send_msg");
        String responseContent = this.cpService.post(url, GSON.toJson((Object)request));
        return WxCpKfMsgSendResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfMsgSendResp sendMsgOnEvent(WxCpKfMsgSendRequest request) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/send_msg_on_event");
        String responseContent = this.cpService.post(url, GSON.toJson((Object)request));
        return WxCpKfMsgSendResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfCustomerBatchGetResp customerBatchGet(List<String> externalUserIdList) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/customer/batchget");
        JsonArray array = new JsonArray();
        externalUserIdList.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        JsonObject json = new JsonObject();
        json.add("external_userid_list", (JsonElement)array);
        String responseContent = this.cpService.post(url, json.toString());
        return WxCpKfCustomerBatchGetResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfGetCorpStatisticResp getCorpStatistic(WxCpKfGetCorpStatisticRequest request) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/get_corp_statistic");
        String responseContent = this.cpService.post(url, GSON.toJson((Object)request));
        return WxCpKfGetCorpStatisticResp.fromJson(responseContent);
    }

    public WxCpKfServiceImpl(WxCpService cpService) {
        this.cpService = cpService;
    }
}

