/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonObject;
import java.util.List;
import lombok.NonNull;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpOaWeDriveService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpBaseResp;
import me.chanjar.weixin.cp.bean.oa.wedrive.WxCpFileAclAddRequest;
import me.chanjar.weixin.cp.bean.oa.wedrive.WxCpFileAclDelRequest;
import me.chanjar.weixin.cp.bean.oa.wedrive.WxCpFileCreate;
import me.chanjar.weixin.cp.bean.oa.wedrive.WxCpFileDeleteRequest;
import me.chanjar.weixin.cp.bean.oa.wedrive.WxCpFileDownload;
import me.chanjar.weixin.cp.bean.oa.wedrive.WxCpFileInfo;
import me.chanjar.weixin.cp.bean.oa.wedrive.WxCpFileList;
import me.chanjar.weixin.cp.bean.oa.wedrive.WxCpFileListRequest;
import me.chanjar.weixin.cp.bean.oa.wedrive.WxCpFileMove;
import me.chanjar.weixin.cp.bean.oa.wedrive.WxCpFileMoveRequest;
import me.chanjar.weixin.cp.bean.oa.wedrive.WxCpFileRename;
import me.chanjar.weixin.cp.bean.oa.wedrive.WxCpFileUpload;
import me.chanjar.weixin.cp.bean.oa.wedrive.WxCpFileUploadRequest;
import me.chanjar.weixin.cp.bean.oa.wedrive.WxCpSpaceAclAddRequest;
import me.chanjar.weixin.cp.bean.oa.wedrive.WxCpSpaceAclDelRequest;
import me.chanjar.weixin.cp.bean.oa.wedrive.WxCpSpaceCreateData;
import me.chanjar.weixin.cp.bean.oa.wedrive.WxCpSpaceCreateRequest;
import me.chanjar.weixin.cp.bean.oa.wedrive.WxCpSpaceInfo;
import me.chanjar.weixin.cp.bean.oa.wedrive.WxCpSpaceRenameRequest;
import me.chanjar.weixin.cp.bean.oa.wedrive.WxCpSpaceSettingRequest;
import me.chanjar.weixin.cp.bean.oa.wedrive.WxCpSpaceShare;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxCpOaWeDriveServiceImpl
implements WxCpOaWeDriveService {
    private static final Logger log = LoggerFactory.getLogger(WxCpOaWeDriveServiceImpl.class);
    private final WxCpService cpService;

    @Override
    public WxCpSpaceCreateData spaceCreate(@NonNull WxCpSpaceCreateRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/wedrive/space_create");
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return WxCpSpaceCreateData.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp spaceRename(@NonNull WxCpSpaceRenameRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/wedrive/space_rename");
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp spaceDismiss(@NonNull String userId, @NonNull String spaceId) throws WxErrorException {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (spaceId == null) {
            throw new NullPointerException("spaceId is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/wedrive/space_dismiss");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("userid", userId);
        jsonObject.addProperty("spaceid", spaceId);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpSpaceInfo spaceInfo(@NonNull String userId, @NonNull String spaceId) throws WxErrorException {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (spaceId == null) {
            throw new NullPointerException("spaceId is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/wedrive/space_info");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("userid", userId);
        jsonObject.addProperty("spaceid", spaceId);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpSpaceInfo.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp spaceAclAdd(@NonNull WxCpSpaceAclAddRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/wedrive/space_acl_add");
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp spaceAclDel(@NonNull WxCpSpaceAclDelRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/wedrive/space_acl_del");
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp spaceSetting(@NonNull WxCpSpaceSettingRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/wedrive/space_setting");
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpSpaceShare spaceShare(@NonNull String userId, @NonNull String spaceId) throws WxErrorException {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (spaceId == null) {
            throw new NullPointerException("spaceId is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/wedrive/space_share");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("userid", userId);
        jsonObject.addProperty("spaceid", spaceId);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpSpaceShare.fromJson(responseContent);
    }

    @Override
    public WxCpFileList fileList(@NonNull WxCpFileListRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/wedrive/file_list");
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return WxCpFileList.fromJson(responseContent);
    }

    @Override
    public WxCpFileUpload fileUpload(@NonNull WxCpFileUploadRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/wedrive/file_upload");
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return WxCpFileUpload.fromJson(responseContent);
    }

    @Override
    public WxCpFileDownload fileDownload(@NonNull String userId, @NonNull String fileId) throws WxErrorException {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (fileId == null) {
            throw new NullPointerException("fileId is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/wedrive/file_download");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("userid", userId);
        jsonObject.addProperty("fileid", fileId);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpFileDownload.fromJson(responseContent);
    }

    @Override
    public WxCpFileRename fileRename(@NonNull String userId, @NonNull String fileId, @NonNull String newName) throws WxErrorException {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (fileId == null) {
            throw new NullPointerException("fileId is marked non-null but is null");
        }
        if (newName == null) {
            throw new NullPointerException("newName is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/wedrive/file_rename");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("userid", userId);
        jsonObject.addProperty("fileid", fileId);
        jsonObject.addProperty("new_name", newName);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpFileRename.fromJson(responseContent);
    }

    @Override
    public WxCpFileCreate fileCreate(@NonNull String userId, @NonNull String spaceId, @NonNull String fatherId, @NonNull Integer fileType, @NonNull String fileName) throws WxErrorException {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (spaceId == null) {
            throw new NullPointerException("spaceId is marked non-null but is null");
        }
        if (fatherId == null) {
            throw new NullPointerException("fatherId is marked non-null but is null");
        }
        if (fileType == null) {
            throw new NullPointerException("fileType is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/wedrive/file_create");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("userid", userId);
        jsonObject.addProperty("spaceid", spaceId);
        jsonObject.addProperty("fatherid", fatherId);
        jsonObject.addProperty("file_type", (Number)fileType);
        jsonObject.addProperty("file_name", fileName);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpFileCreate.fromJson(responseContent);
    }

    @Override
    public WxCpFileMove fileMove(@NonNull WxCpFileMoveRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/wedrive/file_move");
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return WxCpFileMove.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp fileDelete(@NonNull String userId, @NonNull List<String> fileId) throws WxErrorException {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (fileId == null) {
            throw new NullPointerException("fileId is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/wedrive/file_delete");
        WxCpFileDeleteRequest request = new WxCpFileDeleteRequest(userId, fileId);
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp fileAclAdd(@NonNull WxCpFileAclAddRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/wedrive/file_acl_add");
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp fileAclDel(@NonNull WxCpFileAclDelRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/wedrive/file_acl_del");
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpFileInfo fileInfo(@NonNull String userId, @NonNull String fileId) throws WxErrorException {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (fileId == null) {
            throw new NullPointerException("fileId is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/wedrive/file_info");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("userid", userId);
        jsonObject.addProperty("fileid", fileId);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpFileInfo.fromJson(responseContent);
    }

    public WxCpOaWeDriveServiceImpl(WxCpService cpService) {
        this.cpService = cpService;
    }
}

