/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.bean.message;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.util.XmlUtils;
import me.chanjar.weixin.common.util.xml.IntegerArrayConverter;
import me.chanjar.weixin.common.util.xml.LongArrayConverter;
import me.chanjar.weixin.common.util.xml.XStreamCDataConverter;
import me.chanjar.weixin.cp.bean.message.WxCpXmlApprovalInfo;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import me.chanjar.weixin.cp.util.crypto.WxCpCryptUtil;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;
import me.chanjar.weixin.cp.util.xml.XStreamTransformer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="xml")
public class WxCpXmlMessage
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(WxCpXmlMessage.class);
    private static final long serialVersionUID = -1042994982179476410L;
    private Map<String, Object> allFieldsMap;
    @XStreamAlias(value="AgentID")
    private String agentId;
    @XStreamAlias(value="ToUserName")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String toUserName;
    @XStreamAlias(value="FromUserName")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String fromUserName;
    @XStreamAlias(value="CreateTime")
    private Long createTime;
    @XStreamAlias(value="MsgType")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String msgType;
    @XStreamAlias(value="Content")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String content;
    @XStreamAlias(value="MsgId")
    private Long msgId;
    @XStreamAlias(value="PicUrl")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String picUrl;
    @XStreamAlias(value="MediaId")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String mediaId;
    @XStreamAlias(value="Format")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String format;
    @XStreamAlias(value="ThumbMediaId")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String thumbMediaId;
    @XStreamAlias(value="Location_X")
    private Double locationX;
    @XStreamAlias(value="Location_Y")
    private Double locationY;
    @XStreamAlias(value="Scale")
    private Double scale;
    @XStreamAlias(value="Label")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String label;
    @XStreamAlias(value="Title")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String title;
    @XStreamAlias(value="Description")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String description;
    @XStreamAlias(value="Url")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String url;
    @XStreamAlias(value="Event")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String event;
    @XStreamAlias(value="UpdateDetail")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String updateDetail;
    @XStreamAlias(value="JoinScene")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String joinScene;
    @XStreamAlias(value="QuitScene")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String quitScene;
    @XStreamAlias(value="MemChangeCnt")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String memChangeCnt;
    @XStreamAlias(value="Source")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String source;
    @XStreamAlias(value="StrategyId")
    private String strategyId;
    @XStreamAlias(value="EventKey")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String eventKey;
    @XStreamAlias(value="Ticket")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String ticket;
    @XStreamAlias(value="Latitude")
    private Double latitude;
    @XStreamAlias(value="Longitude")
    private Double longitude;
    @XStreamAlias(value="Precision")
    private Double precision;
    @XStreamAlias(value="Recognition")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String recognition;
    @XStreamAlias(value="TaskId")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String taskId;
    @XStreamAlias(value="ChangeType")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String changeType;
    @XStreamAlias(value="UserID")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String userId;
    @XStreamAlias(value="ExternalUserID")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String externalUserId;
    @XStreamAlias(value="State")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String state;
    @XStreamAlias(value="WelcomeCode")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String welcomeCode;
    @XStreamAlias(value="NewUserID")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String newUserId;
    @XStreamAlias(value="Name")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String name;
    @XStreamAlias(value="Department")
    @XStreamConverter(value=LongArrayConverter.class)
    private Long[] departments;
    @XStreamAlias(value="MainDepartment")
    private Long mainDepartment;
    @XStreamAlias(value="Mobile")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String mobile;
    @XStreamAlias(value="Position")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String position;
    @XStreamAlias(value="ChatId")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String chatId;
    @XStreamAlias(value="Gender")
    private Integer gender;
    @XStreamAlias(value="Email")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String email;
    @XStreamAlias(value="BizMail")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String bizMail;
    @XStreamAlias(value="Avatar")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String avatar;
    @XStreamAlias(value="EnglishName")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String englishName;
    @XStreamAlias(value="IsLeader")
    private Integer isLeader;
    @XStreamAlias(value="IsLeaderInDept")
    @XStreamConverter(value=IntegerArrayConverter.class)
    private Integer[] isLeaderInDept;
    @XStreamAlias(value="Telephone")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String telephone;
    @XStreamAlias(value="Address")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String address;
    @XStreamAlias(value="ScheduleId")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String scheduleId;
    @XStreamAlias(value="CalId")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String calId;
    @XStreamAlias(value="ExtAttr")
    private ExtAttr extAttrs = new ExtAttr();
    @XStreamAlias(value="Id")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String id;
    @XStreamAlias(value="ParentId")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String parentId;
    @XStreamAlias(value="Order")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String order;
    @XStreamAlias(value="TagId")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String tagId;
    @XStreamAlias(value="AddUserItems")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String addUserItems;
    @XStreamAlias(value="DelUserItems")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String delUserItems;
    @XStreamAlias(value="AddPartyItems")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String addPartyItems;
    @XStreamAlias(value="DelPartyItems")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String delPartyItems;
    @XStreamAlias(value="FailReason")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String failReason;
    @XStreamAlias(value="TagType")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String tagType;
    @XStreamAlias(value="Status")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String status;
    @XStreamAlias(value="TotalCount")
    private Integer totalCount;
    @XStreamAlias(value="FilterCount")
    private Integer filterCount;
    @XStreamAlias(value="SentCount")
    private Integer sentCount;
    @XStreamAlias(value="ErrorCount")
    private Integer errorCount;
    @XStreamAlias(value="ScanCodeInfo")
    private ScanCodeInfo scanCodeInfo = new ScanCodeInfo();
    @XStreamAlias(value="SendPicsInfo")
    private SendPicsInfo sendPicsInfo = new SendPicsInfo();
    @XStreamAlias(value="SendLocationInfo")
    private SendLocationInfo sendLocationInfo = new SendLocationInfo();
    @XStreamAlias(value="ApprovalInfo")
    private WxCpXmlApprovalInfo approvalInfo = new WxCpXmlApprovalInfo();

    protected static WxCpXmlMessage fromXml(String xml) {
        xml = xml.replace("</PicList><PicList>", "");
        WxCpXmlMessage xmlMessage = XStreamTransformer.fromXml(WxCpXmlMessage.class, xml);
        xmlMessage.setAllFieldsMap(XmlUtils.xml2Map((String)xml));
        return xmlMessage;
    }

    public static WxCpXmlMessage fromXml(String xml, String agentId) {
        xml = xml.replace("</PicList><PicList>", "");
        WxCpXmlMessage xmlMessage = WxCpXmlMessage.fromXml(xml);
        xmlMessage.setAgentId(agentId);
        return xmlMessage;
    }

    protected static WxCpXmlMessage fromXml(InputStream is) {
        return XStreamTransformer.fromXml(WxCpXmlMessage.class, is);
    }

    public static WxCpXmlMessage fromEncryptedXml(String encryptedXml, WxCpConfigStorage wxCpConfigStorage, String timestamp, String nonce, String msgSignature) {
        WxCpCryptUtil cryptUtil = new WxCpCryptUtil(wxCpConfigStorage);
        WxCpXmlMessage wxCpXmlMessage = WxCpXmlMessage.fromXml(encryptedXml);
        String plainText = cryptUtil.decrypt(msgSignature, timestamp, nonce, encryptedXml);
        log.debug("\u89e3\u5bc6\u540e\u7684\u539f\u59cbxml\u6d88\u606f\u5185\u5bb9\uff1a{}", (Object)plainText);
        if (StringUtils.isNotEmpty((CharSequence)wxCpXmlMessage.getAgentId())) {
            return WxCpXmlMessage.fromXml(plainText, wxCpXmlMessage.getAgentId());
        }
        return WxCpXmlMessage.fromXml(plainText);
    }

    public static WxCpXmlMessage fromEncryptedXml(InputStream is, WxCpConfigStorage wxCpConfigStorage, String timestamp, String nonce, String msgSignature) {
        try {
            return WxCpXmlMessage.fromEncryptedXml(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8), wxCpConfigStorage, timestamp, nonce, msgSignature);
        }
        catch (IOException e) {
            throw new WxRuntimeException((Throwable)e);
        }
    }

    public String toString() {
        return WxCpGsonBuilder.create().toJson((Object)this);
    }

    public Map<String, Object> getAllFieldsMap() {
        return this.allFieldsMap;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getToUserName() {
        return this.toUserName;
    }

    public String getFromUserName() {
        return this.fromUserName;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public String getContent() {
        return this.content;
    }

    public Long getMsgId() {
        return this.msgId;
    }

    public String getPicUrl() {
        return this.picUrl;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public String getFormat() {
        return this.format;
    }

    public String getThumbMediaId() {
        return this.thumbMediaId;
    }

    public Double getLocationX() {
        return this.locationX;
    }

    public Double getLocationY() {
        return this.locationY;
    }

    public Double getScale() {
        return this.scale;
    }

    public String getLabel() {
        return this.label;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrl() {
        return this.url;
    }

    public String getEvent() {
        return this.event;
    }

    public String getUpdateDetail() {
        return this.updateDetail;
    }

    public String getJoinScene() {
        return this.joinScene;
    }

    public String getQuitScene() {
        return this.quitScene;
    }

    public String getMemChangeCnt() {
        return this.memChangeCnt;
    }

    public String getSource() {
        return this.source;
    }

    public String getStrategyId() {
        return this.strategyId;
    }

    public String getEventKey() {
        return this.eventKey;
    }

    public String getTicket() {
        return this.ticket;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public Double getPrecision() {
        return this.precision;
    }

    public String getRecognition() {
        return this.recognition;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getChangeType() {
        return this.changeType;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getExternalUserId() {
        return this.externalUserId;
    }

    public String getState() {
        return this.state;
    }

    public String getWelcomeCode() {
        return this.welcomeCode;
    }

    public String getNewUserId() {
        return this.newUserId;
    }

    public String getName() {
        return this.name;
    }

    public Long[] getDepartments() {
        return this.departments;
    }

    public Long getMainDepartment() {
        return this.mainDepartment;
    }

    public String getMobile() {
        return this.mobile;
    }

    public String getPosition() {
        return this.position;
    }

    public String getChatId() {
        return this.chatId;
    }

    public Integer getGender() {
        return this.gender;
    }

    public String getEmail() {
        return this.email;
    }

    public String getBizMail() {
        return this.bizMail;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public Integer getIsLeader() {
        return this.isLeader;
    }

    public Integer[] getIsLeaderInDept() {
        return this.isLeaderInDept;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public String getAddress() {
        return this.address;
    }

    public String getScheduleId() {
        return this.scheduleId;
    }

    public String getCalId() {
        return this.calId;
    }

    public ExtAttr getExtAttrs() {
        return this.extAttrs;
    }

    public String getId() {
        return this.id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getOrder() {
        return this.order;
    }

    public String getTagId() {
        return this.tagId;
    }

    public String getAddUserItems() {
        return this.addUserItems;
    }

    public String getDelUserItems() {
        return this.delUserItems;
    }

    public String getAddPartyItems() {
        return this.addPartyItems;
    }

    public String getDelPartyItems() {
        return this.delPartyItems;
    }

    public String getFailReason() {
        return this.failReason;
    }

    public String getTagType() {
        return this.tagType;
    }

    public String getStatus() {
        return this.status;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public Integer getFilterCount() {
        return this.filterCount;
    }

    public Integer getSentCount() {
        return this.sentCount;
    }

    public Integer getErrorCount() {
        return this.errorCount;
    }

    public ScanCodeInfo getScanCodeInfo() {
        return this.scanCodeInfo;
    }

    public SendPicsInfo getSendPicsInfo() {
        return this.sendPicsInfo;
    }

    public SendLocationInfo getSendLocationInfo() {
        return this.sendLocationInfo;
    }

    public WxCpXmlApprovalInfo getApprovalInfo() {
        return this.approvalInfo;
    }

    public void setAllFieldsMap(Map<String, Object> allFieldsMap) {
        this.allFieldsMap = allFieldsMap;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public void setToUserName(String toUserName) {
        this.toUserName = toUserName;
    }

    public void setFromUserName(String fromUserName) {
        this.fromUserName = fromUserName;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setMsgId(Long msgId) {
        this.msgId = msgId;
    }

    public void setPicUrl(String picUrl) {
        this.picUrl = picUrl;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setThumbMediaId(String thumbMediaId) {
        this.thumbMediaId = thumbMediaId;
    }

    public void setLocationX(Double locationX) {
        this.locationX = locationX;
    }

    public void setLocationY(Double locationY) {
        this.locationY = locationY;
    }

    public void setScale(Double scale) {
        this.scale = scale;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setUpdateDetail(String updateDetail) {
        this.updateDetail = updateDetail;
    }

    public void setJoinScene(String joinScene) {
        this.joinScene = joinScene;
    }

    public void setQuitScene(String quitScene) {
        this.quitScene = quitScene;
    }

    public void setMemChangeCnt(String memChangeCnt) {
        this.memChangeCnt = memChangeCnt;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setStrategyId(String strategyId) {
        this.strategyId = strategyId;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public void setPrecision(Double precision) {
        this.precision = precision;
    }

    public void setRecognition(String recognition) {
        this.recognition = recognition;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setExternalUserId(String externalUserId) {
        this.externalUserId = externalUserId;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setWelcomeCode(String welcomeCode) {
        this.welcomeCode = welcomeCode;
    }

    public void setNewUserId(String newUserId) {
        this.newUserId = newUserId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDepartments(Long[] departments) {
        this.departments = departments;
    }

    public void setMainDepartment(Long mainDepartment) {
        this.mainDepartment = mainDepartment;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    public void setGender(Integer gender) {
        this.gender = gender;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setBizMail(String bizMail) {
        this.bizMail = bizMail;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public void setEnglishName(String englishName) {
        this.englishName = englishName;
    }

    public void setIsLeader(Integer isLeader) {
        this.isLeader = isLeader;
    }

    public void setIsLeaderInDept(Integer[] isLeaderInDept) {
        this.isLeaderInDept = isLeaderInDept;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }

    public void setCalId(String calId) {
        this.calId = calId;
    }

    public void setExtAttrs(ExtAttr extAttrs) {
        this.extAttrs = extAttrs;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }

    public void setAddUserItems(String addUserItems) {
        this.addUserItems = addUserItems;
    }

    public void setDelUserItems(String delUserItems) {
        this.delUserItems = delUserItems;
    }

    public void setAddPartyItems(String addPartyItems) {
        this.addPartyItems = addPartyItems;
    }

    public void setDelPartyItems(String delPartyItems) {
        this.delPartyItems = delPartyItems;
    }

    public void setFailReason(String failReason) {
        this.failReason = failReason;
    }

    public void setTagType(String tagType) {
        this.tagType = tagType;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public void setFilterCount(Integer filterCount) {
        this.filterCount = filterCount;
    }

    public void setSentCount(Integer sentCount) {
        this.sentCount = sentCount;
    }

    public void setErrorCount(Integer errorCount) {
        this.errorCount = errorCount;
    }

    public void setScanCodeInfo(ScanCodeInfo scanCodeInfo) {
        this.scanCodeInfo = scanCodeInfo;
    }

    public void setSendPicsInfo(SendPicsInfo sendPicsInfo) {
        this.sendPicsInfo = sendPicsInfo;
    }

    public void setSendLocationInfo(SendLocationInfo sendLocationInfo) {
        this.sendLocationInfo = sendLocationInfo;
    }

    public void setApprovalInfo(WxCpXmlApprovalInfo approvalInfo) {
        this.approvalInfo = approvalInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxCpXmlMessage)) {
            return false;
        }
        WxCpXmlMessage other = (WxCpXmlMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$createTime = this.getCreateTime();
        Long other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Long this$msgId = this.getMsgId();
        Long other$msgId = other.getMsgId();
        if (this$msgId == null ? other$msgId != null : !((Object)this$msgId).equals(other$msgId)) {
            return false;
        }
        Double this$locationX = this.getLocationX();
        Double other$locationX = other.getLocationX();
        if (this$locationX == null ? other$locationX != null : !((Object)this$locationX).equals(other$locationX)) {
            return false;
        }
        Double this$locationY = this.getLocationY();
        Double other$locationY = other.getLocationY();
        if (this$locationY == null ? other$locationY != null : !((Object)this$locationY).equals(other$locationY)) {
            return false;
        }
        Double this$scale = this.getScale();
        Double other$scale = other.getScale();
        if (this$scale == null ? other$scale != null : !((Object)this$scale).equals(other$scale)) {
            return false;
        }
        Double this$latitude = this.getLatitude();
        Double other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        Double this$longitude = this.getLongitude();
        Double other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        Double this$precision = this.getPrecision();
        Double other$precision = other.getPrecision();
        if (this$precision == null ? other$precision != null : !((Object)this$precision).equals(other$precision)) {
            return false;
        }
        Long this$mainDepartment = this.getMainDepartment();
        Long other$mainDepartment = other.getMainDepartment();
        if (this$mainDepartment == null ? other$mainDepartment != null : !((Object)this$mainDepartment).equals(other$mainDepartment)) {
            return false;
        }
        Integer this$gender = this.getGender();
        Integer other$gender = other.getGender();
        if (this$gender == null ? other$gender != null : !((Object)this$gender).equals(other$gender)) {
            return false;
        }
        Integer this$isLeader = this.getIsLeader();
        Integer other$isLeader = other.getIsLeader();
        if (this$isLeader == null ? other$isLeader != null : !((Object)this$isLeader).equals(other$isLeader)) {
            return false;
        }
        Integer this$totalCount = this.getTotalCount();
        Integer other$totalCount = other.getTotalCount();
        if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
            return false;
        }
        Integer this$filterCount = this.getFilterCount();
        Integer other$filterCount = other.getFilterCount();
        if (this$filterCount == null ? other$filterCount != null : !((Object)this$filterCount).equals(other$filterCount)) {
            return false;
        }
        Integer this$sentCount = this.getSentCount();
        Integer other$sentCount = other.getSentCount();
        if (this$sentCount == null ? other$sentCount != null : !((Object)this$sentCount).equals(other$sentCount)) {
            return false;
        }
        Integer this$errorCount = this.getErrorCount();
        Integer other$errorCount = other.getErrorCount();
        if (this$errorCount == null ? other$errorCount != null : !((Object)this$errorCount).equals(other$errorCount)) {
            return false;
        }
        Map<String, Object> this$allFieldsMap = this.getAllFieldsMap();
        Map<String, Object> other$allFieldsMap = other.getAllFieldsMap();
        if (this$allFieldsMap == null ? other$allFieldsMap != null : !((Object)this$allFieldsMap).equals(other$allFieldsMap)) {
            return false;
        }
        String this$agentId = this.getAgentId();
        String other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !this$agentId.equals(other$agentId)) {
            return false;
        }
        String this$toUserName = this.getToUserName();
        String other$toUserName = other.getToUserName();
        if (this$toUserName == null ? other$toUserName != null : !this$toUserName.equals(other$toUserName)) {
            return false;
        }
        String this$fromUserName = this.getFromUserName();
        String other$fromUserName = other.getFromUserName();
        if (this$fromUserName == null ? other$fromUserName != null : !this$fromUserName.equals(other$fromUserName)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$picUrl = this.getPicUrl();
        String other$picUrl = other.getPicUrl();
        if (this$picUrl == null ? other$picUrl != null : !this$picUrl.equals(other$picUrl)) {
            return false;
        }
        String this$mediaId = this.getMediaId();
        String other$mediaId = other.getMediaId();
        if (this$mediaId == null ? other$mediaId != null : !this$mediaId.equals(other$mediaId)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$thumbMediaId = this.getThumbMediaId();
        String other$thumbMediaId = other.getThumbMediaId();
        if (this$thumbMediaId == null ? other$thumbMediaId != null : !this$thumbMediaId.equals(other$thumbMediaId)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$event = this.getEvent();
        String other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        String this$updateDetail = this.getUpdateDetail();
        String other$updateDetail = other.getUpdateDetail();
        if (this$updateDetail == null ? other$updateDetail != null : !this$updateDetail.equals(other$updateDetail)) {
            return false;
        }
        String this$joinScene = this.getJoinScene();
        String other$joinScene = other.getJoinScene();
        if (this$joinScene == null ? other$joinScene != null : !this$joinScene.equals(other$joinScene)) {
            return false;
        }
        String this$quitScene = this.getQuitScene();
        String other$quitScene = other.getQuitScene();
        if (this$quitScene == null ? other$quitScene != null : !this$quitScene.equals(other$quitScene)) {
            return false;
        }
        String this$memChangeCnt = this.getMemChangeCnt();
        String other$memChangeCnt = other.getMemChangeCnt();
        if (this$memChangeCnt == null ? other$memChangeCnt != null : !this$memChangeCnt.equals(other$memChangeCnt)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$strategyId = this.getStrategyId();
        String other$strategyId = other.getStrategyId();
        if (this$strategyId == null ? other$strategyId != null : !this$strategyId.equals(other$strategyId)) {
            return false;
        }
        String this$eventKey = this.getEventKey();
        String other$eventKey = other.getEventKey();
        if (this$eventKey == null ? other$eventKey != null : !this$eventKey.equals(other$eventKey)) {
            return false;
        }
        String this$ticket = this.getTicket();
        String other$ticket = other.getTicket();
        if (this$ticket == null ? other$ticket != null : !this$ticket.equals(other$ticket)) {
            return false;
        }
        String this$recognition = this.getRecognition();
        String other$recognition = other.getRecognition();
        if (this$recognition == null ? other$recognition != null : !this$recognition.equals(other$recognition)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$changeType = this.getChangeType();
        String other$changeType = other.getChangeType();
        if (this$changeType == null ? other$changeType != null : !this$changeType.equals(other$changeType)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$externalUserId = this.getExternalUserId();
        String other$externalUserId = other.getExternalUserId();
        if (this$externalUserId == null ? other$externalUserId != null : !this$externalUserId.equals(other$externalUserId)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$welcomeCode = this.getWelcomeCode();
        String other$welcomeCode = other.getWelcomeCode();
        if (this$welcomeCode == null ? other$welcomeCode != null : !this$welcomeCode.equals(other$welcomeCode)) {
            return false;
        }
        String this$newUserId = this.getNewUserId();
        String other$newUserId = other.getNewUserId();
        if (this$newUserId == null ? other$newUserId != null : !this$newUserId.equals(other$newUserId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getDepartments(), other.getDepartments())) {
            return false;
        }
        String this$mobile = this.getMobile();
        String other$mobile = other.getMobile();
        if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
            return false;
        }
        String this$position = this.getPosition();
        String other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$bizMail = this.getBizMail();
        String other$bizMail = other.getBizMail();
        if (this$bizMail == null ? other$bizMail != null : !this$bizMail.equals(other$bizMail)) {
            return false;
        }
        String this$avatar = this.getAvatar();
        String other$avatar = other.getAvatar();
        if (this$avatar == null ? other$avatar != null : !this$avatar.equals(other$avatar)) {
            return false;
        }
        String this$englishName = this.getEnglishName();
        String other$englishName = other.getEnglishName();
        if (this$englishName == null ? other$englishName != null : !this$englishName.equals(other$englishName)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getIsLeaderInDept(), other.getIsLeaderInDept())) {
            return false;
        }
        String this$telephone = this.getTelephone();
        String other$telephone = other.getTelephone();
        if (this$telephone == null ? other$telephone != null : !this$telephone.equals(other$telephone)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$scheduleId = this.getScheduleId();
        String other$scheduleId = other.getScheduleId();
        if (this$scheduleId == null ? other$scheduleId != null : !this$scheduleId.equals(other$scheduleId)) {
            return false;
        }
        String this$calId = this.getCalId();
        String other$calId = other.getCalId();
        if (this$calId == null ? other$calId != null : !this$calId.equals(other$calId)) {
            return false;
        }
        ExtAttr this$extAttrs = this.getExtAttrs();
        ExtAttr other$extAttrs = other.getExtAttrs();
        if (this$extAttrs == null ? other$extAttrs != null : !((Object)this$extAttrs).equals(other$extAttrs)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$parentId = this.getParentId();
        String other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
            return false;
        }
        String this$order = this.getOrder();
        String other$order = other.getOrder();
        if (this$order == null ? other$order != null : !this$order.equals(other$order)) {
            return false;
        }
        String this$tagId = this.getTagId();
        String other$tagId = other.getTagId();
        if (this$tagId == null ? other$tagId != null : !this$tagId.equals(other$tagId)) {
            return false;
        }
        String this$addUserItems = this.getAddUserItems();
        String other$addUserItems = other.getAddUserItems();
        if (this$addUserItems == null ? other$addUserItems != null : !this$addUserItems.equals(other$addUserItems)) {
            return false;
        }
        String this$delUserItems = this.getDelUserItems();
        String other$delUserItems = other.getDelUserItems();
        if (this$delUserItems == null ? other$delUserItems != null : !this$delUserItems.equals(other$delUserItems)) {
            return false;
        }
        String this$addPartyItems = this.getAddPartyItems();
        String other$addPartyItems = other.getAddPartyItems();
        if (this$addPartyItems == null ? other$addPartyItems != null : !this$addPartyItems.equals(other$addPartyItems)) {
            return false;
        }
        String this$delPartyItems = this.getDelPartyItems();
        String other$delPartyItems = other.getDelPartyItems();
        if (this$delPartyItems == null ? other$delPartyItems != null : !this$delPartyItems.equals(other$delPartyItems)) {
            return false;
        }
        String this$failReason = this.getFailReason();
        String other$failReason = other.getFailReason();
        if (this$failReason == null ? other$failReason != null : !this$failReason.equals(other$failReason)) {
            return false;
        }
        String this$tagType = this.getTagType();
        String other$tagType = other.getTagType();
        if (this$tagType == null ? other$tagType != null : !this$tagType.equals(other$tagType)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        ScanCodeInfo this$scanCodeInfo = this.getScanCodeInfo();
        ScanCodeInfo other$scanCodeInfo = other.getScanCodeInfo();
        if (this$scanCodeInfo == null ? other$scanCodeInfo != null : !((Object)this$scanCodeInfo).equals(other$scanCodeInfo)) {
            return false;
        }
        SendPicsInfo this$sendPicsInfo = this.getSendPicsInfo();
        SendPicsInfo other$sendPicsInfo = other.getSendPicsInfo();
        if (this$sendPicsInfo == null ? other$sendPicsInfo != null : !((Object)this$sendPicsInfo).equals(other$sendPicsInfo)) {
            return false;
        }
        SendLocationInfo this$sendLocationInfo = this.getSendLocationInfo();
        SendLocationInfo other$sendLocationInfo = other.getSendLocationInfo();
        if (this$sendLocationInfo == null ? other$sendLocationInfo != null : !((Object)this$sendLocationInfo).equals(other$sendLocationInfo)) {
            return false;
        }
        WxCpXmlApprovalInfo this$approvalInfo = this.getApprovalInfo();
        WxCpXmlApprovalInfo other$approvalInfo = other.getApprovalInfo();
        return !(this$approvalInfo == null ? other$approvalInfo != null : !((Object)this$approvalInfo).equals(other$approvalInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxCpXmlMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Long $msgId = this.getMsgId();
        result = result * 59 + ($msgId == null ? 43 : ((Object)$msgId).hashCode());
        Double $locationX = this.getLocationX();
        result = result * 59 + ($locationX == null ? 43 : ((Object)$locationX).hashCode());
        Double $locationY = this.getLocationY();
        result = result * 59 + ($locationY == null ? 43 : ((Object)$locationY).hashCode());
        Double $scale = this.getScale();
        result = result * 59 + ($scale == null ? 43 : ((Object)$scale).hashCode());
        Double $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        Double $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        Double $precision = this.getPrecision();
        result = result * 59 + ($precision == null ? 43 : ((Object)$precision).hashCode());
        Long $mainDepartment = this.getMainDepartment();
        result = result * 59 + ($mainDepartment == null ? 43 : ((Object)$mainDepartment).hashCode());
        Integer $gender = this.getGender();
        result = result * 59 + ($gender == null ? 43 : ((Object)$gender).hashCode());
        Integer $isLeader = this.getIsLeader();
        result = result * 59 + ($isLeader == null ? 43 : ((Object)$isLeader).hashCode());
        Integer $totalCount = this.getTotalCount();
        result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
        Integer $filterCount = this.getFilterCount();
        result = result * 59 + ($filterCount == null ? 43 : ((Object)$filterCount).hashCode());
        Integer $sentCount = this.getSentCount();
        result = result * 59 + ($sentCount == null ? 43 : ((Object)$sentCount).hashCode());
        Integer $errorCount = this.getErrorCount();
        result = result * 59 + ($errorCount == null ? 43 : ((Object)$errorCount).hashCode());
        Map<String, Object> $allFieldsMap = this.getAllFieldsMap();
        result = result * 59 + ($allFieldsMap == null ? 43 : ((Object)$allFieldsMap).hashCode());
        String $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : $agentId.hashCode());
        String $toUserName = this.getToUserName();
        result = result * 59 + ($toUserName == null ? 43 : $toUserName.hashCode());
        String $fromUserName = this.getFromUserName();
        result = result * 59 + ($fromUserName == null ? 43 : $fromUserName.hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $picUrl = this.getPicUrl();
        result = result * 59 + ($picUrl == null ? 43 : $picUrl.hashCode());
        String $mediaId = this.getMediaId();
        result = result * 59 + ($mediaId == null ? 43 : $mediaId.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $thumbMediaId = this.getThumbMediaId();
        result = result * 59 + ($thumbMediaId == null ? 43 : $thumbMediaId.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        String $updateDetail = this.getUpdateDetail();
        result = result * 59 + ($updateDetail == null ? 43 : $updateDetail.hashCode());
        String $joinScene = this.getJoinScene();
        result = result * 59 + ($joinScene == null ? 43 : $joinScene.hashCode());
        String $quitScene = this.getQuitScene();
        result = result * 59 + ($quitScene == null ? 43 : $quitScene.hashCode());
        String $memChangeCnt = this.getMemChangeCnt();
        result = result * 59 + ($memChangeCnt == null ? 43 : $memChangeCnt.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $strategyId = this.getStrategyId();
        result = result * 59 + ($strategyId == null ? 43 : $strategyId.hashCode());
        String $eventKey = this.getEventKey();
        result = result * 59 + ($eventKey == null ? 43 : $eventKey.hashCode());
        String $ticket = this.getTicket();
        result = result * 59 + ($ticket == null ? 43 : $ticket.hashCode());
        String $recognition = this.getRecognition();
        result = result * 59 + ($recognition == null ? 43 : $recognition.hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $changeType = this.getChangeType();
        result = result * 59 + ($changeType == null ? 43 : $changeType.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $externalUserId = this.getExternalUserId();
        result = result * 59 + ($externalUserId == null ? 43 : $externalUserId.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $welcomeCode = this.getWelcomeCode();
        result = result * 59 + ($welcomeCode == null ? 43 : $welcomeCode.hashCode());
        String $newUserId = this.getNewUserId();
        result = result * 59 + ($newUserId == null ? 43 : $newUserId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getDepartments());
        String $mobile = this.getMobile();
        result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
        String $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $bizMail = this.getBizMail();
        result = result * 59 + ($bizMail == null ? 43 : $bizMail.hashCode());
        String $avatar = this.getAvatar();
        result = result * 59 + ($avatar == null ? 43 : $avatar.hashCode());
        String $englishName = this.getEnglishName();
        result = result * 59 + ($englishName == null ? 43 : $englishName.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getIsLeaderInDept());
        String $telephone = this.getTelephone();
        result = result * 59 + ($telephone == null ? 43 : $telephone.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $scheduleId = this.getScheduleId();
        result = result * 59 + ($scheduleId == null ? 43 : $scheduleId.hashCode());
        String $calId = this.getCalId();
        result = result * 59 + ($calId == null ? 43 : $calId.hashCode());
        ExtAttr $extAttrs = this.getExtAttrs();
        result = result * 59 + ($extAttrs == null ? 43 : ((Object)$extAttrs).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        String $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : $order.hashCode());
        String $tagId = this.getTagId();
        result = result * 59 + ($tagId == null ? 43 : $tagId.hashCode());
        String $addUserItems = this.getAddUserItems();
        result = result * 59 + ($addUserItems == null ? 43 : $addUserItems.hashCode());
        String $delUserItems = this.getDelUserItems();
        result = result * 59 + ($delUserItems == null ? 43 : $delUserItems.hashCode());
        String $addPartyItems = this.getAddPartyItems();
        result = result * 59 + ($addPartyItems == null ? 43 : $addPartyItems.hashCode());
        String $delPartyItems = this.getDelPartyItems();
        result = result * 59 + ($delPartyItems == null ? 43 : $delPartyItems.hashCode());
        String $failReason = this.getFailReason();
        result = result * 59 + ($failReason == null ? 43 : $failReason.hashCode());
        String $tagType = this.getTagType();
        result = result * 59 + ($tagType == null ? 43 : $tagType.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        ScanCodeInfo $scanCodeInfo = this.getScanCodeInfo();
        result = result * 59 + ($scanCodeInfo == null ? 43 : ((Object)$scanCodeInfo).hashCode());
        SendPicsInfo $sendPicsInfo = this.getSendPicsInfo();
        result = result * 59 + ($sendPicsInfo == null ? 43 : ((Object)$sendPicsInfo).hashCode());
        SendLocationInfo $sendLocationInfo = this.getSendLocationInfo();
        result = result * 59 + ($sendLocationInfo == null ? 43 : ((Object)$sendLocationInfo).hashCode());
        WxCpXmlApprovalInfo $approvalInfo = this.getApprovalInfo();
        result = result * 59 + ($approvalInfo == null ? 43 : ((Object)$approvalInfo).hashCode());
        return result;
    }

    @XStreamAlias(value="SendLocationInfo")
    public static class SendLocationInfo
    implements Serializable {
        private static final long serialVersionUID = 6319921071637597406L;
        @XStreamAlias(value="Location_X")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String locationX;
        @XStreamAlias(value="Location_Y")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String locationY;
        @XStreamAlias(value="Scale")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String scale;
        @XStreamAlias(value="Label")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String label;
        @XStreamAlias(value="Poiname")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String poiName;

        public String getLocationX() {
            return this.locationX;
        }

        public String getLocationY() {
            return this.locationY;
        }

        public String getScale() {
            return this.scale;
        }

        public String getLabel() {
            return this.label;
        }

        public String getPoiName() {
            return this.poiName;
        }

        public void setLocationX(String locationX) {
            this.locationX = locationX;
        }

        public void setLocationY(String locationY) {
            this.locationY = locationY;
        }

        public void setScale(String scale) {
            this.scale = scale;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setPoiName(String poiName) {
            this.poiName = poiName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SendLocationInfo)) {
                return false;
            }
            SendLocationInfo other = (SendLocationInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$locationX = this.getLocationX();
            String other$locationX = other.getLocationX();
            if (this$locationX == null ? other$locationX != null : !this$locationX.equals(other$locationX)) {
                return false;
            }
            String this$locationY = this.getLocationY();
            String other$locationY = other.getLocationY();
            if (this$locationY == null ? other$locationY != null : !this$locationY.equals(other$locationY)) {
                return false;
            }
            String this$scale = this.getScale();
            String other$scale = other.getScale();
            if (this$scale == null ? other$scale != null : !this$scale.equals(other$scale)) {
                return false;
            }
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            String this$poiName = this.getPoiName();
            String other$poiName = other.getPoiName();
            return !(this$poiName == null ? other$poiName != null : !this$poiName.equals(other$poiName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SendLocationInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $locationX = this.getLocationX();
            result = result * 59 + ($locationX == null ? 43 : $locationX.hashCode());
            String $locationY = this.getLocationY();
            result = result * 59 + ($locationY == null ? 43 : $locationY.hashCode());
            String $scale = this.getScale();
            result = result * 59 + ($scale == null ? 43 : $scale.hashCode());
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            String $poiName = this.getPoiName();
            result = result * 59 + ($poiName == null ? 43 : $poiName.hashCode());
            return result;
        }

        public String toString() {
            return "WxCpXmlMessage.SendLocationInfo(locationX=" + this.getLocationX() + ", locationY=" + this.getLocationY() + ", scale=" + this.getScale() + ", label=" + this.getLabel() + ", poiName=" + this.getPoiName() + ")";
        }
    }

    @XStreamAlias(value="SendPicsInfo")
    public static class SendPicsInfo
    implements Serializable {
        private static final long serialVersionUID = -6549728838848064881L;
        @XStreamAlias(value="PicList")
        protected final List<Item> picList = new ArrayList<Item>();
        @XStreamAlias(value="Count")
        private Long count;

        public List<Item> getPicList() {
            return this.picList;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SendPicsInfo)) {
                return false;
            }
            SendPicsInfo other = (SendPicsInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$count = this.getCount();
            Long other$count = other.getCount();
            if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
                return false;
            }
            List<Item> this$picList = this.getPicList();
            List<Item> other$picList = other.getPicList();
            return !(this$picList == null ? other$picList != null : !((Object)this$picList).equals(other$picList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SendPicsInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $count = this.getCount();
            result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
            List<Item> $picList = this.getPicList();
            result = result * 59 + ($picList == null ? 43 : ((Object)$picList).hashCode());
            return result;
        }

        public String toString() {
            return "WxCpXmlMessage.SendPicsInfo(picList=" + this.getPicList() + ", count=" + this.getCount() + ")";
        }

        @XStreamAlias(value="item")
        public static class Item
        implements Serializable {
            private static final long serialVersionUID = -6549728838848064881L;
            @XStreamAlias(value="PicMd5Sum")
            @XStreamConverter(value=XStreamCDataConverter.class)
            private String picMd5Sum;

            public String getPicMd5Sum() {
                return this.picMd5Sum;
            }

            public void setPicMd5Sum(String picMd5Sum) {
                this.picMd5Sum = picMd5Sum;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Item)) {
                    return false;
                }
                Item other = (Item)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$picMd5Sum = this.getPicMd5Sum();
                String other$picMd5Sum = other.getPicMd5Sum();
                return !(this$picMd5Sum == null ? other$picMd5Sum != null : !this$picMd5Sum.equals(other$picMd5Sum));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Item;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $picMd5Sum = this.getPicMd5Sum();
                result = result * 59 + ($picMd5Sum == null ? 43 : $picMd5Sum.hashCode());
                return result;
            }

            public String toString() {
                return "WxCpXmlMessage.SendPicsInfo.Item(picMd5Sum=" + this.getPicMd5Sum() + ")";
            }
        }
    }

    public static class ExtAttr
    implements Serializable {
        private static final long serialVersionUID = -3418685294606228837L;
        @XStreamImplicit(itemFieldName="Item")
        protected final List<Item> items = new ArrayList<Item>();

        public List<Item> getItems() {
            return this.items;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExtAttr)) {
                return false;
            }
            ExtAttr other = (ExtAttr)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Item> this$items = this.getItems();
            List<Item> other$items = other.getItems();
            return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExtAttr;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Item> $items = this.getItems();
            result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
            return result;
        }

        public String toString() {
            return "WxCpXmlMessage.ExtAttr(items=" + this.getItems() + ")";
        }

        @XStreamAlias(value="Item")
        public static class Item
        implements Serializable {
            private static final long serialVersionUID = -3418685294606228837L;
            @XStreamAlias(value="Name")
            @XStreamConverter(value=XStreamCDataConverter.class)
            private String name;
            @XStreamAlias(value="Value")
            @XStreamConverter(value=XStreamCDataConverter.class)
            private String value;

            public String getName() {
                return this.name;
            }

            public String getValue() {
                return this.value;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Item)) {
                    return false;
                }
                Item other = (Item)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Item;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }

            public String toString() {
                return "WxCpXmlMessage.ExtAttr.Item(name=" + this.getName() + ", value=" + this.getValue() + ")";
            }
        }
    }

    @XStreamAlias(value="ScanCodeInfo")
    public static class ScanCodeInfo
    implements Serializable {
        private static final long serialVersionUID = 7420078330239763395L;
        @XStreamAlias(value="ScanType")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String scanType;
        @XStreamAlias(value="ScanResult")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String scanResult;

        public String getScanType() {
            return this.scanType;
        }

        public String getScanResult() {
            return this.scanResult;
        }

        public void setScanType(String scanType) {
            this.scanType = scanType;
        }

        public void setScanResult(String scanResult) {
            this.scanResult = scanResult;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScanCodeInfo)) {
                return false;
            }
            ScanCodeInfo other = (ScanCodeInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$scanType = this.getScanType();
            String other$scanType = other.getScanType();
            if (this$scanType == null ? other$scanType != null : !this$scanType.equals(other$scanType)) {
                return false;
            }
            String this$scanResult = this.getScanResult();
            String other$scanResult = other.getScanResult();
            return !(this$scanResult == null ? other$scanResult != null : !this$scanResult.equals(other$scanResult));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ScanCodeInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $scanType = this.getScanType();
            result = result * 59 + ($scanType == null ? 43 : $scanType.hashCode());
            String $scanResult = this.getScanResult();
            result = result * 59 + ($scanResult == null ? 43 : $scanResult.hashCode());
            return result;
        }

        public String toString() {
            return "WxCpXmlMessage.ScanCodeInfo(scanType=" + this.getScanType() + ", scanResult=" + this.getScanResult() + ")";
        }
    }
}

