/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import lombok.NonNull;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.cp.api.WxCpSchoolUserService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpBaseResp;
import me.chanjar.weixin.cp.bean.school.user.WxCpAllowScope;
import me.chanjar.weixin.cp.bean.school.user.WxCpBatchCreateStudentRequest;
import me.chanjar.weixin.cp.bean.school.user.WxCpBatchDeleteStudentRequest;
import me.chanjar.weixin.cp.bean.school.user.WxCpBatchResultList;
import me.chanjar.weixin.cp.bean.school.user.WxCpBatchUpdateStudentRequest;
import me.chanjar.weixin.cp.bean.school.user.WxCpCreateDepartment;
import me.chanjar.weixin.cp.bean.school.user.WxCpCreateDepartmentRequest;
import me.chanjar.weixin.cp.bean.school.user.WxCpCreateParentRequest;
import me.chanjar.weixin.cp.bean.school.user.WxCpDepartmentList;
import me.chanjar.weixin.cp.bean.school.user.WxCpExternalContact;
import me.chanjar.weixin.cp.bean.school.user.WxCpSetUpgradeInfo;
import me.chanjar.weixin.cp.bean.school.user.WxCpSubscribeQrCode;
import me.chanjar.weixin.cp.bean.school.user.WxCpUpdateDepartmentRequest;
import me.chanjar.weixin.cp.bean.school.user.WxCpUpdateParentRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxCpSchoolUserServiceImpl
implements WxCpSchoolUserService {
    private static final Logger log = LoggerFactory.getLogger(WxCpSchoolUserServiceImpl.class);
    private final WxCpService cpService;

    @Override
    public WxCpBaseResp createStudent(@NonNull String studentUserId, @NonNull String name, @NonNull List<Integer> departments) throws WxErrorException {
        if (studentUserId == null) {
            throw new NullPointerException("studentUserId is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (departments == null) {
            throw new NullPointerException("departments is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/user/create_student");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("student_userid", studentUserId);
        jsonObject.addProperty("name", name);
        JsonArray jsonArray = new JsonArray();
        for (Integer depart : departments) {
            jsonArray.add((JsonElement)new JsonPrimitive((Number)depart));
        }
        jsonObject.add("department", (JsonElement)jsonArray);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBatchResultList batchCreateStudent(@NonNull WxCpBatchCreateStudentRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/user/batch_create_student");
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return WxCpBatchResultList.fromJson(responseContent);
    }

    @Override
    public WxCpBatchResultList batchDeleteStudent(@NonNull WxCpBatchDeleteStudentRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/user/batch_delete_student");
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return WxCpBatchResultList.fromJson(responseContent);
    }

    @Override
    public WxCpBatchResultList batchUpdateStudent(@NonNull WxCpBatchUpdateStudentRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/user/batch_update_student");
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return WxCpBatchResultList.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp deleteStudent(@NonNull String studentUserId) throws WxErrorException {
        if (studentUserId == null) {
            throw new NullPointerException("studentUserId is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/user/delete_student?userid=") + studentUserId;
        String responseContent = this.cpService.get(apiUrl, null);
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp updateStudent(@NonNull String studentUserId, String newStudentUserId, String name, List<Integer> departments) throws WxErrorException {
        if (studentUserId == null) {
            throw new NullPointerException("studentUserId is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/user/update_student");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("student_userid", studentUserId);
        if (StringUtils.isNotEmpty((CharSequence)newStudentUserId)) {
            jsonObject.addProperty("new_student_userid", newStudentUserId);
        }
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            jsonObject.addProperty("name", name);
        }
        if (departments != null && departments.size() > 0) {
            JsonArray jsonArray = new JsonArray();
            for (Integer depart : departments) {
                jsonArray.add((JsonElement)new JsonPrimitive((Number)depart));
            }
            jsonObject.add("department", (JsonElement)jsonArray);
        }
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp createParent(@NonNull WxCpCreateParentRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/user/create_parent");
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp updateParent(@NonNull WxCpUpdateParentRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/user/update_parent");
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp deleteParent(@NonNull String userId) throws WxErrorException {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/user/delete_parent?userid=") + userId;
        String responseContent = this.cpService.get(apiUrl, null);
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp setArchSyncMode(@NonNull Integer archSyncMode) throws WxErrorException {
        if (archSyncMode == null) {
            throw new NullPointerException("archSyncMode is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/set_arch_sync_mode");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("arch_sync_mode", (Number)archSyncMode);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpCreateDepartment createDepartment(@NonNull WxCpCreateDepartmentRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/department/create");
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return WxCpCreateDepartment.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp updateDepartment(@NonNull WxCpUpdateDepartmentRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/department/update");
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp deleteDepartment(Integer id) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/department/delete?id=") + id;
        String responseContent = this.cpService.get(apiUrl, null);
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp setSubscribeMode(@NonNull Integer subscribeMode) throws WxErrorException {
        if (subscribeMode == null) {
            throw new NullPointerException("subscribeMode is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/set_subscribe_mode");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("subscribe_mode", (Number)subscribeMode);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public Integer getSubscribeMode() throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_subscribe_mode");
        String responseContent = this.cpService.get(apiUrl, null);
        return GsonParser.parse((String)responseContent).get("subscribe_mode").getAsInt();
    }

    @Override
    public WxCpExternalContact getExternalContact(@NonNull String externalUserId) throws WxErrorException {
        if (externalUserId == null) {
            throw new NullPointerException("externalUserId is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get?external_userid=") + externalUserId;
        String responseContent = this.cpService.get(apiUrl, null);
        return WxCpExternalContact.fromJson(responseContent);
    }

    @Override
    public WxCpAllowScope getAllowScope(@NonNull Integer agentId) throws WxErrorException {
        if (agentId == null) {
            throw new NullPointerException("agentId is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/agent/get_allow_scope?agentid=") + agentId;
        String responseContent = this.cpService.get(apiUrl, null);
        return WxCpAllowScope.fromJson(responseContent);
    }

    @Override
    public String convertToOpenId(@NonNull String externalUserId) throws WxErrorException {
        if (externalUserId == null) {
            throw new NullPointerException("externalUserId is marked non-null but is null");
        }
        return this.cpService.getExternalContactService().convertToOpenid(externalUserId);
    }

    @Override
    public WxCpDepartmentList listDepartment(Integer id) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/department/list?id=") + id;
        String responseContent = this.cpService.get(apiUrl, null);
        return WxCpDepartmentList.fromJson(responseContent);
    }

    @Override
    public WxCpSubscribeQrCode getSubscribeQrCode() throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_subscribe_qr_code");
        String responseContent = this.cpService.get(apiUrl, null);
        return WxCpSubscribeQrCode.fromJson(responseContent);
    }

    @Override
    public WxCpSetUpgradeInfo setUpgradeInfo(Long upgradeTime, Integer upgradeSwitch) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/school/set_upgrade_info");
        JsonObject jsonObject = new JsonObject();
        if (upgradeTime != null) {
            jsonObject.addProperty("upgrade_time", (Number)upgradeTime);
        }
        if (upgradeSwitch != null) {
            jsonObject.addProperty("upgrade_switch", (Number)upgradeSwitch);
        }
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpSetUpgradeInfo.fromJson(responseContent);
    }

    public WxCpSchoolUserServiceImpl(WxCpService cpService) {
        this.cpService = cpService;
    }
}

