/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.util.crypto;

import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.crypto.WxCryptUtil;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import org.apache.commons.lang3.StringUtils;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;

public class WxCpCryptUtil
extends WxCryptUtil {
    public WxCpCryptUtil(WxCpConfigStorage wxCpConfigStorage) {
        String encodingAesKey = wxCpConfigStorage.getAesKey();
        String token = wxCpConfigStorage.getToken();
        String corpId = wxCpConfigStorage.getCorpId();
        this.token = token;
        this.appidOrCorpid = corpId;
        this.aesKey = Base64.getDecoder().decode(StringUtils.remove((String)encodingAesKey, (String)" "));
    }

    public static String decryptPriKey(String encryptRandomKey, String msgAuditPriKey, Integer pkcs1) throws Exception {
        if (pkcs1 == null) {
            throw new WxErrorException("\u8bf7\u914d\u7f6e\u4f1a\u8bdd\u5b58\u6863\u89e3\u5bc6\u65b9\u5f0f");
        }
        if (pkcs1 == 1) {
            return WxCpCryptUtil.decryptPriKeyByPKCS1(encryptRandomKey, msgAuditPriKey);
        }
        return WxCpCryptUtil.decryptPriKeyByPKCS8(encryptRandomKey, msgAuditPriKey);
    }

    public static String decryptPriKeyByPKCS8(String encryptRandomKey, String msgAuditPriKey) throws Exception {
        String privateKey = msgAuditPriKey.replaceAll("(\r\n|\r|\n|\n\r)", "").replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll(" ", "");
        byte[] keyBytes = Base64.getDecoder().decode(privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, priKey);
        byte[] utf8 = cipher.doFinal(Base64.getDecoder().decode(encryptRandomKey));
        return new String(utf8, StandardCharsets.UTF_8);
    }

    public static String decryptPriKeyByPKCS1(String encryptRandomKey, String msgAuditPriKey) throws Exception {
        String privateKey = msgAuditPriKey.replaceAll("(\r\n|\r|\n|\n\r)", "").replace("-----BEGIN RSA PRIVATE KEY-----", "").replace("-----END RSA PRIVATE KEY-----", "").replaceAll(" ", "");
        byte[] keyBytes = Base64.getDecoder().decode(privateKey);
        DerValue[] seq = new DerInputStream(keyBytes).getSequence(0);
        RSAPrivateCrtKeySpec keySpec = new RSAPrivateCrtKeySpec(seq[1].getBigInteger(), seq[2].getBigInteger(), seq[3].getBigInteger(), seq[4].getBigInteger(), seq[5].getBigInteger(), seq[6].getBigInteger(), seq[7].getBigInteger(), seq[8].getBigInteger());
        PrivateKey priKey = KeyFactory.getInstance("RSA").generatePrivate(keySpec);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, priKey);
        byte[] utf8 = cipher.doFinal(Base64.getDecoder().decode(encryptRandomKey));
        return new String(utf8, StandardCharsets.UTF_8);
    }
}

