/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import me.chanjar.weixin.common.api.WxErrorExceptionHandler;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.message.WxCpXmlMessage;
import me.chanjar.weixin.cp.bean.message.WxCpXmlOutMessage;
import me.chanjar.weixin.cp.message.WxCpMessageHandler;
import me.chanjar.weixin.cp.message.WxCpMessageInterceptor;
import me.chanjar.weixin.cp.message.WxCpMessageMatcher;
import me.chanjar.weixin.cp.message.WxCpMessageRouter;
import org.apache.commons.lang3.StringUtils;

public class WxCpMessageRouterRule {
    private final WxCpMessageRouter routerBuilder;
    private boolean async = true;
    private String fromUser;
    private String msgType;
    private String event;
    private String eventKey;
    private String eventKeyRegex;
    private String content;
    private String rContent;
    private WxCpMessageMatcher matcher;
    private boolean reEnter = false;
    private Integer agentId;
    private List<WxCpMessageHandler> handlers = new ArrayList<WxCpMessageHandler>();
    private List<WxCpMessageInterceptor> interceptors = new ArrayList<WxCpMessageInterceptor>();

    protected WxCpMessageRouterRule(WxCpMessageRouter routerBuilder) {
        this.routerBuilder = routerBuilder;
    }

    public WxCpMessageRouterRule async(boolean async) {
        this.async = async;
        return this;
    }

    public WxCpMessageRouterRule agentId(Integer agentId) {
        this.agentId = agentId;
        return this;
    }

    public WxCpMessageRouterRule msgType(String msgType) {
        this.msgType = msgType;
        return this;
    }

    public WxCpMessageRouterRule event(String event) {
        this.event = event;
        return this;
    }

    public WxCpMessageRouterRule eventKey(String eventKey) {
        this.eventKey = eventKey;
        return this;
    }

    public WxCpMessageRouterRule eventKeyRegex(String regex) {
        this.eventKeyRegex = regex;
        return this;
    }

    public WxCpMessageRouterRule content(String content) {
        this.content = content;
        return this;
    }

    public WxCpMessageRouterRule rContent(String regex) {
        this.rContent = regex;
        return this;
    }

    public WxCpMessageRouterRule fromUser(String fromUser) {
        this.fromUser = fromUser;
        return this;
    }

    public WxCpMessageRouterRule matcher(WxCpMessageMatcher matcher) {
        this.matcher = matcher;
        return this;
    }

    public WxCpMessageRouterRule interceptor(WxCpMessageInterceptor interceptor) {
        return this.interceptor(interceptor, null);
    }

    public WxCpMessageRouterRule interceptor(WxCpMessageInterceptor interceptor, WxCpMessageInterceptor ... otherInterceptors) {
        this.interceptors.add(interceptor);
        if (otherInterceptors != null && otherInterceptors.length > 0) {
            Collections.addAll(this.interceptors, otherInterceptors);
        }
        return this;
    }

    public WxCpMessageRouterRule handler(WxCpMessageHandler handler) {
        return this.handler(handler, null);
    }

    public WxCpMessageRouterRule handler(WxCpMessageHandler handler, WxCpMessageHandler ... otherHandlers) {
        this.handlers.add(handler);
        if (otherHandlers != null && otherHandlers.length > 0) {
            Collections.addAll(this.handlers, otherHandlers);
        }
        return this;
    }

    public WxCpMessageRouter end() {
        this.routerBuilder.getRules().add(this);
        return this.routerBuilder;
    }

    public WxCpMessageRouter next() {
        this.reEnter = true;
        return this.end();
    }

    protected boolean test(WxCpXmlMessage wxMessage) {
        return !(this.fromUser != null && !this.fromUser.equals(wxMessage.getFromUserName()) || this.agentId != null && !this.agentId.equals(Integer.valueOf(wxMessage.getAgentId())) || this.msgType != null && !this.msgType.equalsIgnoreCase(wxMessage.getMsgType()) || this.event != null && !this.event.equalsIgnoreCase(wxMessage.getEvent()) || this.eventKey != null && !this.eventKey.equalsIgnoreCase(wxMessage.getEventKey()) || this.eventKeyRegex != null && !Pattern.matches(this.eventKeyRegex, StringUtils.trimToEmpty((String)wxMessage.getEventKey())) || this.content != null && !this.content.equals(StringUtils.trimToNull((String)wxMessage.getContent())) || this.rContent != null && !Pattern.matches(this.rContent, StringUtils.trimToEmpty((String)wxMessage.getContent())) || this.matcher != null && !this.matcher.match(wxMessage));
    }

    protected WxCpXmlOutMessage service(WxCpXmlMessage wxMessage, Map<String, Object> context, WxCpService wxCpService, WxSessionManager sessionManager, WxErrorExceptionHandler exceptionHandler) {
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        try {
            for (WxCpMessageInterceptor interceptor : this.interceptors) {
                if (interceptor.intercept(wxMessage, context, wxCpService, sessionManager)) continue;
                return null;
            }
            WxCpXmlOutMessage res = null;
            for (WxCpMessageHandler handler : this.handlers) {
                res = handler.handle(wxMessage, context, wxCpService, sessionManager);
            }
            return res;
        }
        catch (WxErrorException e) {
            exceptionHandler.handle(e);
            return null;
        }
    }

    public WxCpMessageRouter getRouterBuilder() {
        return this.routerBuilder;
    }

    public boolean isAsync() {
        return this.async;
    }

    public String getFromUser() {
        return this.fromUser;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public String getEvent() {
        return this.event;
    }

    public String getEventKey() {
        return this.eventKey;
    }

    public String getEventKeyRegex() {
        return this.eventKeyRegex;
    }

    public String getContent() {
        return this.content;
    }

    public String getRContent() {
        return this.rContent;
    }

    public WxCpMessageMatcher getMatcher() {
        return this.matcher;
    }

    public boolean isReEnter() {
        return this.reEnter;
    }

    public Integer getAgentId() {
        return this.agentId;
    }

    public List<WxCpMessageHandler> getHandlers() {
        return this.handlers;
    }

    public List<WxCpMessageInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void setFromUser(String fromUser) {
        this.fromUser = fromUser;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public void setEventKeyRegex(String eventKeyRegex) {
        this.eventKeyRegex = eventKeyRegex;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setRContent(String rContent) {
        this.rContent = rContent;
    }

    public void setMatcher(WxCpMessageMatcher matcher) {
        this.matcher = matcher;
    }

    public void setReEnter(boolean reEnter) {
        this.reEnter = reEnter;
    }

    public void setAgentId(Integer agentId) {
        this.agentId = agentId;
    }

    public void setHandlers(List<WxCpMessageHandler> handlers) {
        this.handlers = handlers;
    }

    public void setInterceptors(List<WxCpMessageInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxCpMessageRouterRule)) {
            return false;
        }
        WxCpMessageRouterRule other = (WxCpMessageRouterRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAsync() != other.isAsync()) {
            return false;
        }
        if (this.isReEnter() != other.isReEnter()) {
            return false;
        }
        Integer this$agentId = this.getAgentId();
        Integer other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !((Object)this$agentId).equals(other$agentId)) {
            return false;
        }
        WxCpMessageRouter this$routerBuilder = this.getRouterBuilder();
        WxCpMessageRouter other$routerBuilder = other.getRouterBuilder();
        if (this$routerBuilder == null ? other$routerBuilder != null : !this$routerBuilder.equals(other$routerBuilder)) {
            return false;
        }
        String this$fromUser = this.getFromUser();
        String other$fromUser = other.getFromUser();
        if (this$fromUser == null ? other$fromUser != null : !this$fromUser.equals(other$fromUser)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$event = this.getEvent();
        String other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        String this$eventKey = this.getEventKey();
        String other$eventKey = other.getEventKey();
        if (this$eventKey == null ? other$eventKey != null : !this$eventKey.equals(other$eventKey)) {
            return false;
        }
        String this$eventKeyRegex = this.getEventKeyRegex();
        String other$eventKeyRegex = other.getEventKeyRegex();
        if (this$eventKeyRegex == null ? other$eventKeyRegex != null : !this$eventKeyRegex.equals(other$eventKeyRegex)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$rContent = this.getRContent();
        String other$rContent = other.getRContent();
        if (this$rContent == null ? other$rContent != null : !this$rContent.equals(other$rContent)) {
            return false;
        }
        WxCpMessageMatcher this$matcher = this.getMatcher();
        WxCpMessageMatcher other$matcher = other.getMatcher();
        if (this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher)) {
            return false;
        }
        List<WxCpMessageHandler> this$handlers = this.getHandlers();
        List<WxCpMessageHandler> other$handlers = other.getHandlers();
        if (this$handlers == null ? other$handlers != null : !((Object)this$handlers).equals(other$handlers)) {
            return false;
        }
        List<WxCpMessageInterceptor> this$interceptors = this.getInterceptors();
        List<WxCpMessageInterceptor> other$interceptors = other.getInterceptors();
        return !(this$interceptors == null ? other$interceptors != null : !((Object)this$interceptors).equals(other$interceptors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxCpMessageRouterRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAsync() ? 79 : 97);
        result = result * 59 + (this.isReEnter() ? 79 : 97);
        Integer $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : ((Object)$agentId).hashCode());
        WxCpMessageRouter $routerBuilder = this.getRouterBuilder();
        result = result * 59 + ($routerBuilder == null ? 43 : $routerBuilder.hashCode());
        String $fromUser = this.getFromUser();
        result = result * 59 + ($fromUser == null ? 43 : $fromUser.hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        String $eventKey = this.getEventKey();
        result = result * 59 + ($eventKey == null ? 43 : $eventKey.hashCode());
        String $eventKeyRegex = this.getEventKeyRegex();
        result = result * 59 + ($eventKeyRegex == null ? 43 : $eventKeyRegex.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $rContent = this.getRContent();
        result = result * 59 + ($rContent == null ? 43 : $rContent.hashCode());
        WxCpMessageMatcher $matcher = this.getMatcher();
        result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
        List<WxCpMessageHandler> $handlers = this.getHandlers();
        result = result * 59 + ($handlers == null ? 43 : ((Object)$handlers).hashCode());
        List<WxCpMessageInterceptor> $interceptors = this.getInterceptors();
        result = result * 59 + ($interceptors == null ? 43 : ((Object)$interceptors).hashCode());
        return result;
    }

    public String toString() {
        return "WxCpMessageRouterRule(routerBuilder=" + this.getRouterBuilder() + ", async=" + this.isAsync() + ", fromUser=" + this.getFromUser() + ", msgType=" + this.getMsgType() + ", event=" + this.getEvent() + ", eventKey=" + this.getEventKey() + ", eventKeyRegex=" + this.getEventKeyRegex() + ", content=" + this.getContent() + ", rContent=" + this.getRContent() + ", matcher=" + this.getMatcher() + ", reEnter=" + this.isReEnter() + ", agentId=" + this.getAgentId() + ", handlers=" + this.getHandlers() + ", interceptors=" + this.getInterceptors() + ")";
    }
}

