/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.bean.WxCardApiSignature;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.bean.WxMenu;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.session.StandardSessionManager;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.common.util.RandomUtils;
import me.chanjar.weixin.common.util.crypto.SHA1;
import me.chanjar.weixin.common.util.crypto.WxCryptUtil;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.ApacheHttpClientBuilder;
import me.chanjar.weixin.common.util.http.DefaultApacheHttpHttpClientBuilder;
import me.chanjar.weixin.common.util.http.MediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.MediaUploadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.common.util.http.URIUtil;
import me.chanjar.weixin.common.util.http.Utf8ResponseHandler;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.common.util.xml.XStreamInitializer;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;
import me.chanjar.weixin.mp.api.WxMpKefuService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpKefuServiceImpl;
import me.chanjar.weixin.mp.bean.WxMpCustomMessage;
import me.chanjar.weixin.mp.bean.WxMpGroup;
import me.chanjar.weixin.mp.bean.WxMpIndustry;
import me.chanjar.weixin.mp.bean.WxMpMassGroupMessage;
import me.chanjar.weixin.mp.bean.WxMpMassNews;
import me.chanjar.weixin.mp.bean.WxMpMassOpenIdsMessage;
import me.chanjar.weixin.mp.bean.WxMpMassPreviewMessage;
import me.chanjar.weixin.mp.bean.WxMpMassVideo;
import me.chanjar.weixin.mp.bean.WxMpMaterial;
import me.chanjar.weixin.mp.bean.WxMpMaterialArticleUpdate;
import me.chanjar.weixin.mp.bean.WxMpMaterialNews;
import me.chanjar.weixin.mp.bean.WxMpSemanticQuery;
import me.chanjar.weixin.mp.bean.WxMpTemplateMessage;
import me.chanjar.weixin.mp.bean.result.WxMediaImgUploadResult;
import me.chanjar.weixin.mp.bean.result.WxMpCardResult;
import me.chanjar.weixin.mp.bean.result.WxMpMassSendResult;
import me.chanjar.weixin.mp.bean.result.WxMpMassUploadResult;
import me.chanjar.weixin.mp.bean.result.WxMpMaterialCountResult;
import me.chanjar.weixin.mp.bean.result.WxMpMaterialFileBatchGetResult;
import me.chanjar.weixin.mp.bean.result.WxMpMaterialNewsBatchGetResult;
import me.chanjar.weixin.mp.bean.result.WxMpMaterialUploadResult;
import me.chanjar.weixin.mp.bean.result.WxMpMaterialVideoInfoResult;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.bean.result.WxMpPayCallback;
import me.chanjar.weixin.mp.bean.result.WxMpPayRefundResult;
import me.chanjar.weixin.mp.bean.result.WxMpPayResult;
import me.chanjar.weixin.mp.bean.result.WxMpPrepayIdResult;
import me.chanjar.weixin.mp.bean.result.WxMpQrCodeTicket;
import me.chanjar.weixin.mp.bean.result.WxMpSemanticQueryResult;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import me.chanjar.weixin.mp.bean.result.WxMpUserCumulate;
import me.chanjar.weixin.mp.bean.result.WxMpUserList;
import me.chanjar.weixin.mp.bean.result.WxMpUserSummary;
import me.chanjar.weixin.mp.bean.result.WxRedpackResult;
import me.chanjar.weixin.mp.util.http.MaterialDeleteRequestExecutor;
import me.chanjar.weixin.mp.util.http.MaterialNewsInfoRequestExecutor;
import me.chanjar.weixin.mp.util.http.MaterialUploadRequestExecutor;
import me.chanjar.weixin.mp.util.http.MaterialVideoInfoRequestExecutor;
import me.chanjar.weixin.mp.util.http.MaterialVoiceAndImageDownloadRequestExecutor;
import me.chanjar.weixin.mp.util.http.MediaImgUploadRequestExecutor;
import me.chanjar.weixin.mp.util.http.QrCodeRequestExecutor;
import me.chanjar.weixin.mp.util.json.WxMpGsonBuilder;
import org.apache.commons.io.Charsets;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMpServiceImpl
implements WxMpService {
    protected final Logger log = LoggerFactory.getLogger(WxMpServiceImpl.class);
    protected final Object globalAccessTokenRefreshLock = new Object();
    protected final Object globalJsapiTicketRefreshLock = new Object();
    protected final Object globalCardApiTicketRefreshLock = new Object();
    protected WxMpConfigStorage wxMpConfigStorage;
    protected WxMpKefuService kefuService = new WxMpKefuServiceImpl(this);
    protected CloseableHttpClient httpClient;
    protected HttpHost httpProxy;
    private int retrySleepMillis = 1000;
    private int maxRetryTimes = 5;
    protected WxSessionManager sessionManager = new StandardSessionManager();
    final String[] REQUIRED_ORDER_PARAMETERS = new String[]{"appid", "mch_id", "body", "out_trade_no", "total_fee", "spbill_create_ip", "notify_url", "trade_type"};

    @Override
    public boolean checkSignature(String timestamp, String nonce, String signature) {
        try {
            return SHA1.gen((String[])new String[]{this.wxMpConfigStorage.getToken(), timestamp, nonce}).equals(signature);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getAccessToken() throws WxErrorException {
        return this.getAccessToken(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        if (forceRefresh) {
            this.wxMpConfigStorage.expireAccessToken();
        }
        if (this.wxMpConfigStorage.isAccessTokenExpired()) {
            Object object = this.globalAccessTokenRefreshLock;
            synchronized (object) {
                if (this.wxMpConfigStorage.isAccessTokenExpired()) {
                    String url = new StringBuffer().append("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential").append("&appid=").append(this.wxMpConfigStorage.getAppId()).append("&secret=").append(this.wxMpConfigStorage.getSecret()).toString();
                    try {
                        HttpGet httpGet = new HttpGet(url);
                        if (this.httpProxy != null) {
                            RequestConfig config = RequestConfig.custom().setProxy(this.httpProxy).build();
                            httpGet.setConfig(config);
                        }
                        try (CloseableHttpResponse response = this.getHttpclient().execute((HttpUriRequest)httpGet);){
                            String resultContent = new BasicResponseHandler().handleResponse((HttpResponse)response);
                            WxError error = WxError.fromJson((String)resultContent);
                            if (error.getErrorCode() != 0) {
                                throw new WxErrorException(error);
                            }
                            WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
                            this.wxMpConfigStorage.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
                        }
                        finally {
                            httpGet.releaseConnection();
                        }
                    }
                    catch (ClientProtocolException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.wxMpConfigStorage.getAccessToken();
    }

    @Override
    public String getJsapiTicket() throws WxErrorException {
        return this.getJsapiTicket(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJsapiTicket(boolean forceRefresh) throws WxErrorException {
        if (forceRefresh) {
            this.wxMpConfigStorage.expireJsapiTicket();
        }
        if (this.wxMpConfigStorage.isJsapiTicketExpired()) {
            Object object = this.globalJsapiTicketRefreshLock;
            synchronized (object) {
                if (this.wxMpConfigStorage.isJsapiTicketExpired()) {
                    String url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=jsapi";
                    String responseContent = (String)this.execute((RequestExecutor)new SimpleGetRequestExecutor(), url, null);
                    JsonElement tmpJsonElement = Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(responseContent)));
                    JsonObject tmpJsonObject = tmpJsonElement.getAsJsonObject();
                    String jsapiTicket = tmpJsonObject.get("ticket").getAsString();
                    int expiresInSeconds = tmpJsonObject.get("expires_in").getAsInt();
                    this.wxMpConfigStorage.updateJsapiTicket(jsapiTicket, expiresInSeconds);
                }
            }
        }
        return this.wxMpConfigStorage.getJsapiTicket();
    }

    @Override
    public WxJsapiSignature createJsapiSignature(String url) throws WxErrorException {
        long timestamp = System.currentTimeMillis() / 1000L;
        String noncestr = RandomUtils.getRandomStr();
        String jsapiTicket = this.getJsapiTicket(false);
        try {
            String signature = SHA1.genWithAmple((String[])new String[]{"jsapi_ticket=" + jsapiTicket, "noncestr=" + noncestr, "timestamp=" + timestamp, "url=" + url});
            WxJsapiSignature jsapiSignature = new WxJsapiSignature();
            jsapiSignature.setAppid(this.wxMpConfigStorage.getAppId());
            jsapiSignature.setTimestamp(timestamp);
            jsapiSignature.setNoncestr(noncestr);
            jsapiSignature.setUrl(url);
            jsapiSignature.setSignature(signature);
            return jsapiSignature;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void customMessageSend(WxMpCustomMessage message) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/message/custom/send";
        this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)message.toJson());
    }

    @Override
    public void menuCreate(WxMenu menu) throws WxErrorException {
        if (menu.getMatchRule() != null) {
            String url = "https://api.weixin.qq.com/cgi-bin/menu/addconditional";
            this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)menu.toJson());
        } else {
            String url = "https://api.weixin.qq.com/cgi-bin/menu/create";
            this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)menu.toJson());
        }
    }

    @Override
    public void menuDelete() throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/delete";
        this.execute((RequestExecutor)new SimpleGetRequestExecutor(), url, null);
    }

    @Override
    public void menuDelete(String menuid) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/delconditional";
        this.execute((RequestExecutor)new SimpleGetRequestExecutor(), url, (Object)("menuid=" + menuid));
    }

    @Override
    public WxMenu menuGet() throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/get";
        try {
            String resultContent = (String)this.execute((RequestExecutor)new SimpleGetRequestExecutor(), url, null);
            return WxMenu.fromJson((String)resultContent);
        }
        catch (WxErrorException e) {
            if (e.getError().getErrorCode() == 46003) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public WxMenu menuTryMatch(String userid) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/trymatch";
        try {
            String resultContent = (String)this.execute((RequestExecutor)new SimpleGetRequestExecutor(), url, (Object)("user_id=" + userid));
            return WxMenu.fromJson((String)resultContent);
        }
        catch (WxErrorException e) {
            if (e.getError().getErrorCode() == 46003 || e.getError().getErrorCode() == 46002) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public WxMediaUploadResult mediaUpload(String mediaType, String fileType, InputStream inputStream) throws WxErrorException, IOException {
        return this.mediaUpload(mediaType, FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)fileType));
    }

    @Override
    public WxMediaUploadResult mediaUpload(String mediaType, File file) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/media/upload?type=" + mediaType;
        return (WxMediaUploadResult)this.execute((RequestExecutor)new MediaUploadRequestExecutor(), url, (Object)file);
    }

    @Override
    public File mediaDownload(String media_id) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/media/get";
        return (File)this.execute((RequestExecutor)new MediaDownloadRequestExecutor(this.wxMpConfigStorage.getTmpDirFile()), url, (Object)("media_id=" + media_id));
    }

    @Override
    public WxMpMaterialUploadResult materialFileUpload(String mediaType, WxMpMaterial material) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/material/add_material?type=" + mediaType;
        return this.execute(new MaterialUploadRequestExecutor(), url, material);
    }

    @Override
    public WxMpMaterialUploadResult materialNewsUpload(WxMpMaterialNews news) throws WxErrorException {
        if (news == null || news.isEmpty()) {
            throw new IllegalArgumentException("news is empty!");
        }
        String url = "https://api.weixin.qq.com/cgi-bin/material/add_news";
        String responseContent = this.post(url, news.toJson());
        return WxMpMaterialUploadResult.fromJson(responseContent);
    }

    @Override
    public InputStream materialImageOrVoiceDownload(String media_id) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/material/get_material";
        return this.execute(new MaterialVoiceAndImageDownloadRequestExecutor(this.wxMpConfigStorage.getTmpDirFile()), url, media_id);
    }

    @Override
    public WxMpMaterialVideoInfoResult materialVideoInfo(String media_id) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/material/get_material";
        return this.execute(new MaterialVideoInfoRequestExecutor(), url, media_id);
    }

    @Override
    public WxMpMaterialNews materialNewsInfo(String media_id) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/material/get_material";
        return this.execute(new MaterialNewsInfoRequestExecutor(), url, media_id);
    }

    @Override
    public boolean materialNewsUpdate(WxMpMaterialArticleUpdate wxMpMaterialArticleUpdate) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/material/update_news";
        String responseText = this.post(url, wxMpMaterialArticleUpdate.toJson());
        WxError wxError = WxError.fromJson((String)responseText);
        if (wxError.getErrorCode() == 0) {
            return true;
        }
        throw new WxErrorException(wxError);
    }

    @Override
    public boolean materialDelete(String media_id) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/material/del_material";
        return this.execute(new MaterialDeleteRequestExecutor(), url, media_id);
    }

    @Override
    public WxMpMaterialCountResult materialCount() throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/material/get_materialcount";
        String responseText = this.get(url, null);
        WxError wxError = WxError.fromJson((String)responseText);
        if (wxError.getErrorCode() == 0) {
            return (WxMpMaterialCountResult)WxMpGsonBuilder.create().fromJson(responseText, WxMpMaterialCountResult.class);
        }
        throw new WxErrorException(wxError);
    }

    @Override
    public WxMpMaterialNewsBatchGetResult materialNewsBatchGet(int offset, int count) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/material/batchget_material";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", "news");
        params.put("offset", offset);
        params.put("count", count);
        String responseText = this.post(url, WxGsonBuilder.create().toJson(params));
        WxError wxError = WxError.fromJson((String)responseText);
        if (wxError.getErrorCode() == 0) {
            return (WxMpMaterialNewsBatchGetResult)WxMpGsonBuilder.create().fromJson(responseText, WxMpMaterialNewsBatchGetResult.class);
        }
        throw new WxErrorException(wxError);
    }

    @Override
    public WxMpMaterialFileBatchGetResult materialFileBatchGet(String type, int offset, int count) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/material/batchget_material";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", type);
        params.put("offset", offset);
        params.put("count", count);
        String responseText = this.post(url, WxGsonBuilder.create().toJson(params));
        WxError wxError = WxError.fromJson((String)responseText);
        if (wxError.getErrorCode() == 0) {
            return (WxMpMaterialFileBatchGetResult)WxMpGsonBuilder.create().fromJson(responseText, WxMpMaterialFileBatchGetResult.class);
        }
        throw new WxErrorException(wxError);
    }

    @Override
    public WxMpMassUploadResult massNewsUpload(WxMpMassNews news) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/media/uploadnews";
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)news.toJson());
        return WxMpMassUploadResult.fromJson(responseContent);
    }

    @Override
    public WxMpMassUploadResult massVideoUpload(WxMpMassVideo video) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/media/uploadvideo";
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)video.toJson());
        return WxMpMassUploadResult.fromJson(responseContent);
    }

    @Override
    public WxMpMassSendResult massGroupMessageSend(WxMpMassGroupMessage message) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/message/mass/sendall";
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)message.toJson());
        return WxMpMassSendResult.fromJson(responseContent);
    }

    @Override
    public WxMpMassSendResult massOpenIdsMessageSend(WxMpMassOpenIdsMessage message) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/message/mass/send";
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)message.toJson());
        return WxMpMassSendResult.fromJson(responseContent);
    }

    @Override
    public WxMpGroup groupCreate(String name) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/groups/create";
        JsonObject json = new JsonObject();
        JsonObject groupJson = new JsonObject();
        json.add("group", (JsonElement)groupJson);
        groupJson.addProperty("name", name);
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)json.toString());
        return WxMpGroup.fromJson(responseContent);
    }

    @Override
    public List<WxMpGroup> groupGet() throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/groups/get";
        String responseContent = (String)this.execute((RequestExecutor)new SimpleGetRequestExecutor(), url, null);
        JsonElement tmpJsonElement = Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(responseContent)));
        return (List)WxMpGsonBuilder.INSTANCE.create().fromJson(tmpJsonElement.getAsJsonObject().get("groups"), new TypeToken<List<WxMpGroup>>(){}.getType());
    }

    @Override
    public long userGetGroup(String openid) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/groups/getid";
        JsonObject o = new JsonObject();
        o.addProperty("openid", openid);
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)o.toString());
        JsonElement tmpJsonElement = Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(responseContent)));
        return GsonHelper.getAsLong((JsonElement)tmpJsonElement.getAsJsonObject().get("groupid"));
    }

    @Override
    public void groupUpdate(WxMpGroup group) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/groups/update";
        this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)group.toJson());
    }

    @Override
    public void userUpdateGroup(String openid, long to_groupid) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/groups/members/update";
        JsonObject json = new JsonObject();
        json.addProperty("openid", openid);
        json.addProperty("to_groupid", (Number)to_groupid);
        this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)json.toString());
    }

    @Override
    public void userUpdateRemark(String openid, String remark) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/user/info/updateremark";
        JsonObject json = new JsonObject();
        json.addProperty("openid", openid);
        json.addProperty("remark", remark);
        this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)json.toString());
    }

    @Override
    public WxMpUser userInfo(String openid, String lang) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/user/info";
        lang = lang == null ? "zh_CN" : lang;
        String responseContent = (String)this.execute((RequestExecutor)new SimpleGetRequestExecutor(), url, (Object)("openid=" + openid + "&lang=" + lang));
        return WxMpUser.fromJson(responseContent);
    }

    @Override
    public WxMpUserList userList(String next_openid) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/user/get";
        String responseContent = (String)this.execute((RequestExecutor)new SimpleGetRequestExecutor(), url, (Object)(next_openid == null ? null : "next_openid=" + next_openid));
        return WxMpUserList.fromJson(responseContent);
    }

    @Override
    public WxMpQrCodeTicket qrCodeCreateTmpTicket(int scene_id, Integer expire_seconds) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/qrcode/create";
        JsonObject json = new JsonObject();
        json.addProperty("action_name", "QR_SCENE");
        if (expire_seconds != null) {
            json.addProperty("expire_seconds", (Number)expire_seconds);
        }
        JsonObject actionInfo = new JsonObject();
        JsonObject scene = new JsonObject();
        scene.addProperty("scene_id", (Number)scene_id);
        actionInfo.add("scene", (JsonElement)scene);
        json.add("action_info", (JsonElement)actionInfo);
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)json.toString());
        return WxMpQrCodeTicket.fromJson(responseContent);
    }

    @Override
    public WxMpQrCodeTicket qrCodeCreateLastTicket(int scene_id) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/qrcode/create";
        JsonObject json = new JsonObject();
        json.addProperty("action_name", "QR_LIMIT_SCENE");
        JsonObject actionInfo = new JsonObject();
        JsonObject scene = new JsonObject();
        scene.addProperty("scene_id", (Number)scene_id);
        actionInfo.add("scene", (JsonElement)scene);
        json.add("action_info", (JsonElement)actionInfo);
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)json.toString());
        return WxMpQrCodeTicket.fromJson(responseContent);
    }

    @Override
    public WxMpQrCodeTicket qrCodeCreateLastTicket(String scene_str) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/qrcode/create";
        JsonObject json = new JsonObject();
        json.addProperty("action_name", "QR_LIMIT_STR_SCENE");
        JsonObject actionInfo = new JsonObject();
        JsonObject scene = new JsonObject();
        scene.addProperty("scene_str", scene_str);
        actionInfo.add("scene", (JsonElement)scene);
        json.add("action_info", (JsonElement)actionInfo);
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)json.toString());
        return WxMpQrCodeTicket.fromJson(responseContent);
    }

    @Override
    public File qrCodePicture(WxMpQrCodeTicket ticket) throws WxErrorException {
        String url = "https://mp.weixin.qq.com/cgi-bin/showqrcode";
        return this.execute(new QrCodeRequestExecutor(), url, ticket);
    }

    @Override
    public String qrCodePictureUrl(String ticket, boolean needShortUrl) throws WxErrorException {
        String url = "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=%s";
        try {
            String resultUrl = String.format(url, URLEncoder.encode(ticket, Charsets.UTF_8.name()));
            if (needShortUrl) {
                return this.shortUrl(resultUrl);
            }
            return resultUrl;
        }
        catch (UnsupportedEncodingException e) {
            WxError error = WxError.newBuilder().setErrorCode(-1).setErrorMsg(e.getMessage()).build();
            throw new WxErrorException(error);
        }
    }

    @Override
    public String qrCodePictureUrl(String ticket) throws WxErrorException {
        return this.qrCodePictureUrl(ticket, false);
    }

    @Override
    public String shortUrl(String long_url) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/shorturl";
        JsonObject o = new JsonObject();
        o.addProperty("action", "long2short");
        o.addProperty("long_url", long_url);
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)o.toString());
        JsonElement tmpJsonElement = Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(responseContent)));
        return tmpJsonElement.getAsJsonObject().get("short_url").getAsString();
    }

    @Override
    public String templateSend(WxMpTemplateMessage templateMessage) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/message/template/send";
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)templateMessage.toJson());
        JsonElement tmpJsonElement = Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(responseContent)));
        JsonObject jsonObject = tmpJsonElement.getAsJsonObject();
        if (jsonObject.get("errcode").getAsInt() == 0) {
            return jsonObject.get("msgid").getAsString();
        }
        throw new WxErrorException(WxError.fromJson((String)responseContent));
    }

    @Override
    public WxMpSemanticQueryResult semanticQuery(WxMpSemanticQuery semanticQuery) throws WxErrorException {
        String url = "https://api.weixin.qq.com/semantic/semproxy/search";
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)semanticQuery.toJson());
        return WxMpSemanticQueryResult.fromJson(responseContent);
    }

    @Override
    public String oauth2buildAuthorizationUrl(String scope, String state) {
        return this.oauth2buildAuthorizationUrl(this.wxMpConfigStorage.getOauth2redirectUri(), scope, state);
    }

    @Override
    public String oauth2buildAuthorizationUrl(String redirectURI, String scope, String state) {
        StringBuffer url = new StringBuffer();
        url.append("https://open.weixin.qq.com/connect/oauth2/authorize?");
        url.append("appid=").append(this.wxMpConfigStorage.getAppId());
        url.append("&redirect_uri=").append(URIUtil.encodeURIComponent((String)redirectURI));
        url.append("&response_type=code");
        url.append("&scope=").append(scope);
        if (state != null) {
            url.append("&state=").append(state);
        }
        url.append("#wechat_redirect");
        return url.toString();
    }

    @Override
    public WxMpOAuth2AccessToken oauth2getAccessToken(String code) throws WxErrorException {
        StringBuffer url = new StringBuffer();
        url.append("https://api.weixin.qq.com/sns/oauth2/access_token?");
        url.append("appid=").append(this.wxMpConfigStorage.getAppId());
        url.append("&secret=").append(this.wxMpConfigStorage.getSecret());
        url.append("&code=").append(code);
        url.append("&grant_type=authorization_code");
        try {
            SimpleGetRequestExecutor executor = new SimpleGetRequestExecutor();
            String responseText = (String)executor.execute(this.getHttpclient(), this.httpProxy, url.toString(), null);
            return WxMpOAuth2AccessToken.fromJson(responseText);
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public WxMpOAuth2AccessToken oauth2refreshAccessToken(String refreshToken) throws WxErrorException {
        StringBuffer url = new StringBuffer();
        url.append("https://api.weixin.qq.com/sns/oauth2/refresh_token?");
        url.append("appid=").append(this.wxMpConfigStorage.getAppId());
        url.append("&grant_type=refresh_token");
        url.append("&refresh_token=").append(refreshToken);
        try {
            SimpleGetRequestExecutor executor = new SimpleGetRequestExecutor();
            String responseText = (String)executor.execute(this.getHttpclient(), this.httpProxy, url.toString(), null);
            return WxMpOAuth2AccessToken.fromJson(responseText);
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public WxMpUser oauth2getUserInfo(WxMpOAuth2AccessToken oAuth2AccessToken, String lang) throws WxErrorException {
        StringBuffer url = new StringBuffer();
        url.append("https://api.weixin.qq.com/sns/userinfo?");
        url.append("access_token=").append(oAuth2AccessToken.getAccessToken());
        url.append("&openid=").append(oAuth2AccessToken.getOpenId());
        if (lang == null) {
            url.append("&lang=zh_CN");
        } else {
            url.append("&lang=").append(lang);
        }
        try {
            SimpleGetRequestExecutor executor = new SimpleGetRequestExecutor();
            String responseText = (String)executor.execute(this.getHttpclient(), this.httpProxy, url.toString(), null);
            return WxMpUser.fromJson(responseText);
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean oauth2validateAccessToken(WxMpOAuth2AccessToken oAuth2AccessToken) {
        StringBuffer url = new StringBuffer();
        url.append("https://api.weixin.qq.com/sns/auth?");
        url.append("access_token=").append(oAuth2AccessToken.getAccessToken());
        url.append("&openid=").append(oAuth2AccessToken.getOpenId());
        try {
            SimpleGetRequestExecutor executor = new SimpleGetRequestExecutor();
            executor.execute(this.getHttpclient(), this.httpProxy, url.toString(), null);
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (WxErrorException e) {
            return false;
        }
        return true;
    }

    @Override
    public String[] getCallbackIP() throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/getcallbackip";
        String responseContent = this.get(url, null);
        JsonElement tmpJsonElement = Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(responseContent)));
        JsonArray ipList = tmpJsonElement.getAsJsonObject().get("ip_list").getAsJsonArray();
        String[] ipArray = new String[ipList.size()];
        for (int i = 0; i < ipList.size(); ++i) {
            ipArray[i] = ipList.get(i).getAsString();
        }
        return ipArray;
    }

    @Override
    public List<WxMpUserSummary> getUserSummary(Date beginDate, Date endDate) throws WxErrorException {
        String url = "https://api.weixin.qq.com/datacube/getusersummary";
        JsonObject param = new JsonObject();
        param.addProperty("begin_date", SIMPLE_DATE_FORMAT.format(beginDate));
        param.addProperty("end_date", SIMPLE_DATE_FORMAT.format(endDate));
        String responseContent = this.post(url, param.toString());
        JsonElement tmpJsonElement = Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(responseContent)));
        return (List)WxMpGsonBuilder.INSTANCE.create().fromJson(tmpJsonElement.getAsJsonObject().get("list"), new TypeToken<List<WxMpUserSummary>>(){}.getType());
    }

    @Override
    public List<WxMpUserCumulate> getUserCumulate(Date beginDate, Date endDate) throws WxErrorException {
        String url = "https://api.weixin.qq.com/datacube/getusercumulate";
        JsonObject param = new JsonObject();
        param.addProperty("begin_date", SIMPLE_DATE_FORMAT.format(beginDate));
        param.addProperty("end_date", SIMPLE_DATE_FORMAT.format(endDate));
        String responseContent = this.post(url, param.toString());
        JsonElement tmpJsonElement = Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(responseContent)));
        return (List)WxMpGsonBuilder.INSTANCE.create().fromJson(tmpJsonElement.getAsJsonObject().get("list"), new TypeToken<List<WxMpUserCumulate>>(){}.getType());
    }

    @Override
    public String get(String url, String queryParam) throws WxErrorException {
        return (String)this.execute((RequestExecutor)new SimpleGetRequestExecutor(), url, (Object)queryParam);
    }

    @Override
    public String post(String url, String postData) throws WxErrorException {
        return (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)postData);
    }

    @Override
    public <T, E> T execute(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        int retryTimes = 0;
        while (true) {
            try {
                return this.executeInternal(executor, uri, data);
            }
            catch (WxErrorException e) {
                WxError error = e.getError();
                if (error.getErrorCode() == -1) {
                    int sleepMillis = this.retrySleepMillis * (1 << retryTimes);
                    try {
                        this.log.debug("\u5fae\u4fe1\u7cfb\u7edf\u7e41\u5fd9\uff0c{}ms \u540e\u91cd\u8bd5(\u7b2c{}\u6b21)", (Object)sleepMillis, (Object)(retryTimes + 1));
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException e1) {
                        throw new RuntimeException(e1);
                    }
                } else {
                    throw e;
                }
                if (++retryTimes < this.maxRetryTimes) continue;
                throw new RuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
            }
            break;
        }
    }

    protected synchronized <T, E> T executeInternal(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        if (uri.indexOf("access_token=") != -1) {
            throw new IllegalArgumentException("uri\u53c2\u6570\u4e2d\u4e0d\u5141\u8bb8\u6709access_token: " + uri);
        }
        String accessToken = this.getAccessToken(false);
        String uriWithAccessToken = uri;
        uriWithAccessToken = uriWithAccessToken + (uri.indexOf(63) == -1 ? "?access_token=" + accessToken : "&access_token=" + accessToken);
        try {
            return (T)executor.execute(this.getHttpclient(), this.httpProxy, uriWithAccessToken, data);
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (error.getErrorCode() == 42001 || error.getErrorCode() == 40001) {
                this.wxMpConfigStorage.expireAccessToken();
                return this.execute(executor, uri, data);
            }
            if (error.getErrorCode() != 0) {
                throw new WxErrorException(error);
            }
            return null;
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected CloseableHttpClient getHttpclient() {
        return this.httpClient;
    }

    @Override
    public void setWxMpConfigStorage(WxMpConfigStorage wxConfigProvider) {
        this.wxMpConfigStorage = wxConfigProvider;
        ApacheHttpClientBuilder apacheHttpClientBuilder = this.wxMpConfigStorage.getApacheHttpClientBuilder();
        if (null == apacheHttpClientBuilder) {
            apacheHttpClientBuilder = DefaultApacheHttpHttpClientBuilder.get();
        }
        apacheHttpClientBuilder.httpProxyHost(this.wxMpConfigStorage.getHttp_proxy_host()).httpProxyPort(this.wxMpConfigStorage.getHttp_proxy_port()).httpProxyUsername(this.wxMpConfigStorage.getHttp_proxy_username()).httpProxyPassword(this.wxMpConfigStorage.getHttp_proxy_password());
        if (wxConfigProvider.getSSLContext() != null) {
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(wxConfigProvider.getSSLContext(), new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            apacheHttpClientBuilder.sslConnectionSocketFactory(sslsf);
        }
        this.httpClient = apacheHttpClientBuilder.build();
    }

    public WxMpConfigStorage getWxMpConfigStorage() {
        return this.wxMpConfigStorage;
    }

    @Override
    public void setRetrySleepMillis(int retrySleepMillis) {
        this.retrySleepMillis = retrySleepMillis;
    }

    @Override
    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    @Override
    public WxMpPrepayIdResult getPrepayId(String openId, String outTradeNo, double amt, String body, String tradeType, String ip, String callbackUrl) {
        HashMap<String, String> packageParams = new HashMap<String, String>();
        packageParams.put("appid", this.wxMpConfigStorage.getAppId());
        packageParams.put("mch_id", this.wxMpConfigStorage.getPartnerId());
        packageParams.put("body", body);
        packageParams.put("out_trade_no", outTradeNo);
        packageParams.put("total_fee", (int)(amt * 100.0) + "");
        packageParams.put("spbill_create_ip", ip);
        packageParams.put("notify_url", callbackUrl);
        packageParams.put("trade_type", tradeType);
        packageParams.put("openid", openId);
        return this.getPrepayId(packageParams);
    }

    /*
     * Exception decompiling
     */
    @Override
    public WxMpPrepayIdResult getPrepayId(Map<String, String> parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkParameters(Map<String, String> parameters) {
        for (String para : this.REQUIRED_ORDER_PARAMETERS) {
            if (parameters.containsKey(para)) continue;
            throw new IllegalArgumentException("Reqiured argument '" + para + "' is missing.");
        }
        if ("JSAPI".equals(parameters.get("trade_type")) && !parameters.containsKey("openid")) {
            throw new IllegalArgumentException("Reqiured argument 'openid' is missing when trade_type is 'JSAPI'.");
        }
        if ("NATIVE".equals(parameters.get("trade_type")) && !parameters.containsKey("product_id")) {
            throw new IllegalArgumentException("Reqiured argument 'product_id' is missing when trade_type is 'NATIVE'.");
        }
    }

    @Override
    public Map<String, String> getJsapiPayInfo(String openId, String outTradeNo, double amt, String body, String ip, String callbackUrl) throws WxErrorException {
        HashMap<String, String> packageParams = new HashMap<String, String>();
        packageParams.put("appid", this.wxMpConfigStorage.getAppId());
        packageParams.put("mch_id", this.wxMpConfigStorage.getPartnerId());
        packageParams.put("body", body);
        packageParams.put("out_trade_no", outTradeNo);
        packageParams.put("total_fee", (int)(amt * 100.0) + "");
        packageParams.put("spbill_create_ip", ip);
        packageParams.put("notify_url", callbackUrl);
        packageParams.put("trade_type", "JSAPI");
        packageParams.put("openid", openId);
        return this.getPayInfo(packageParams);
    }

    @Override
    public Map<String, String> getNativePayInfo(String productId, String outTradeNo, double amt, String body, String ip, String callbackUrl) throws WxErrorException {
        HashMap<String, String> packageParams = new HashMap<String, String>();
        packageParams.put("appid", this.wxMpConfigStorage.getAppId());
        packageParams.put("mch_id", this.wxMpConfigStorage.getPartnerId());
        packageParams.put("body", body);
        packageParams.put("out_trade_no", outTradeNo);
        packageParams.put("total_fee", (int)(amt * 100.0) + "");
        packageParams.put("spbill_create_ip", ip);
        packageParams.put("notify_url", callbackUrl);
        packageParams.put("trade_type", "NATIVE");
        packageParams.put("product_id", productId);
        return this.getPayInfo(packageParams);
    }

    @Override
    public Map<String, String> getPayInfo(Map<String, String> parameters) throws WxErrorException {
        WxMpPrepayIdResult wxMpPrepayIdResult = this.getPrepayId(parameters);
        if (!"SUCCESS".equalsIgnoreCase(wxMpPrepayIdResult.getReturn_code()) || !"SUCCESS".equalsIgnoreCase(wxMpPrepayIdResult.getResult_code())) {
            WxError error = new WxError();
            error.setErrorCode(-1);
            error.setErrorMsg("return_code:" + wxMpPrepayIdResult.getReturn_code() + ";return_msg:" + wxMpPrepayIdResult.getReturn_msg() + ";result_code:" + wxMpPrepayIdResult.getResult_code() + ";err_code" + wxMpPrepayIdResult.getErr_code() + ";err_code_des" + wxMpPrepayIdResult.getErr_code_des());
            throw new WxErrorException(error);
        }
        String prepayId = wxMpPrepayIdResult.getPrepay_id();
        if (prepayId == null || prepayId.equals("")) {
            throw new RuntimeException(String.format("Failed to get prepay id due to error code '%s'(%s).", wxMpPrepayIdResult.getErr_code(), wxMpPrepayIdResult.getErr_code_des()));
        }
        HashMap<String, String> payInfo = new HashMap<String, String>();
        payInfo.put("appId", this.wxMpConfigStorage.getAppId());
        payInfo.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
        payInfo.put("nonceStr", System.currentTimeMillis() + "");
        payInfo.put("package", "prepay_id=" + prepayId);
        payInfo.put("signType", "MD5");
        if ("NATIVE".equals(parameters.get("trade_type"))) {
            payInfo.put("codeUrl", wxMpPrepayIdResult.getCode_url());
        }
        String finalSign = WxCryptUtil.createSign(payInfo, (String)this.wxMpConfigStorage.getPartnerKey());
        payInfo.put("paySign", finalSign);
        return payInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WxMpPayResult getJSSDKPayResult(String transactionId, String outTradeNo) {
        String nonce_str = System.currentTimeMillis() + "";
        TreeMap<String, String> packageParams = new TreeMap<String, String>();
        packageParams.put("appid", this.wxMpConfigStorage.getAppId());
        packageParams.put("mch_id", this.wxMpConfigStorage.getPartnerId());
        if (transactionId != null && !"".equals(transactionId.trim())) {
            packageParams.put("transaction_id", transactionId);
        } else {
            if (outTradeNo == null) throw new IllegalArgumentException("Either 'transactionId' or 'outTradeNo' must be given.");
            if ("".equals(outTradeNo.trim())) throw new IllegalArgumentException("Either 'transactionId' or 'outTradeNo' must be given.");
            packageParams.put("out_trade_no", outTradeNo);
        }
        packageParams.put("nonce_str", nonce_str);
        packageParams.put("sign", WxCryptUtil.createSign(packageParams, (String)this.wxMpConfigStorage.getPartnerKey()));
        StringBuilder request = new StringBuilder("<xml>");
        for (Map.Entry para : packageParams.entrySet()) {
            request.append(String.format("<%s>%s</%s>", para.getKey(), para.getValue(), para.getKey()));
        }
        request.append("</xml>");
        HttpPost httpPost = new HttpPost("https://api.mch.weixin.qq.com/pay/orderquery");
        if (this.httpProxy != null) {
            RequestConfig config = RequestConfig.custom().setProxy(this.httpProxy).build();
            httpPost.setConfig(config);
        }
        StringEntity entity = new StringEntity(request.toString(), Consts.UTF_8);
        httpPost.setEntity((HttpEntity)entity);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            WxMpPayResult wxMpPayResult;
            String responseContent = (String)Utf8ResponseHandler.INSTANCE.handleResponse((HttpResponse)response);
            XStream xstream = XStreamInitializer.getInstance();
            xstream.alias("xml", WxMpPayResult.class);
            WxMpPayResult wxMpPayResult2 = wxMpPayResult = (WxMpPayResult)xstream.fromXML(responseContent);
            return wxMpPayResult2;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to query order due to IO exception.", e);
        }
    }

    @Override
    public WxMpPayCallback getJSSDKCallbackData(String xmlData) {
        try {
            XStream xstream = XStreamInitializer.getInstance();
            xstream.alias("xml", WxMpPayCallback.class);
            WxMpPayCallback wxMpCallback = (WxMpPayCallback)xstream.fromXML(xmlData);
            return wxMpCallback;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new WxMpPayCallback();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public WxMpPayRefundResult refundPay(Map<String, String> parameters) throws WxErrorException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean checkJSSDKCallbackDataSignature(Map<String, String> kvm, String signature) {
        return signature.equals(WxCryptUtil.createSign(kvm, (String)this.wxMpConfigStorage.getPartnerKey()));
    }

    /*
     * Exception decompiling
     */
    @Override
    public WxRedpackResult sendRedpack(Map<String, String> parameters) throws WxErrorException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getCardApiTicket() throws WxErrorException {
        return this.getCardApiTicket(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCardApiTicket(boolean forceRefresh) throws WxErrorException {
        if (forceRefresh) {
            this.wxMpConfigStorage.expireCardApiTicket();
        }
        if (this.wxMpConfigStorage.isCardApiTicketExpired()) {
            Object object = this.globalCardApiTicketRefreshLock;
            synchronized (object) {
                if (this.wxMpConfigStorage.isCardApiTicketExpired()) {
                    String url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=wx_card";
                    String responseContent = (String)this.execute((RequestExecutor)new SimpleGetRequestExecutor(), url, null);
                    JsonElement tmpJsonElement = Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(responseContent)));
                    JsonObject tmpJsonObject = tmpJsonElement.getAsJsonObject();
                    String cardApiTicket = tmpJsonObject.get("ticket").getAsString();
                    int expiresInSeconds = tmpJsonObject.get("expires_in").getAsInt();
                    this.wxMpConfigStorage.updateCardApiTicket(cardApiTicket, expiresInSeconds);
                }
            }
        }
        return this.wxMpConfigStorage.getCardApiTicket();
    }

    @Override
    public WxCardApiSignature createCardApiSignature(String ... optionalSignParam) throws WxErrorException {
        long timestamp = System.currentTimeMillis() / 1000L;
        String nonceStr = RandomUtils.getRandomStr();
        String cardApiTicket = this.getCardApiTicket(false);
        String[] signParam = Arrays.copyOf(optionalSignParam, optionalSignParam.length + 3);
        signParam[optionalSignParam.length] = String.valueOf(timestamp);
        signParam[optionalSignParam.length + 1] = nonceStr;
        signParam[optionalSignParam.length + 2] = cardApiTicket;
        try {
            String signature = SHA1.gen((String[])signParam);
            WxCardApiSignature cardApiSignature = new WxCardApiSignature();
            cardApiSignature.setTimestamp(Long.valueOf(timestamp));
            cardApiSignature.setNonceStr(nonceStr);
            cardApiSignature.setSignature(signature);
            return cardApiSignature;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String decryptCardCode(String encryptCode) throws WxErrorException {
        String url = "https://api.weixin.qq.com/card/code/decrypt";
        JsonObject param = new JsonObject();
        param.addProperty("encrypt_code", encryptCode);
        String responseContent = this.post(url, param.toString());
        JsonElement tmpJsonElement = Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(responseContent)));
        JsonObject tmpJsonObject = tmpJsonElement.getAsJsonObject();
        JsonPrimitive jsonPrimitive = tmpJsonObject.getAsJsonPrimitive("code");
        return jsonPrimitive.getAsString();
    }

    @Override
    public WxMpCardResult queryCardCode(String cardId, String code, boolean checkConsume) throws WxErrorException {
        String url = "https://api.weixin.qq.com/card/code/get";
        JsonObject param = new JsonObject();
        param.addProperty("card_id", cardId);
        param.addProperty("code", code);
        param.addProperty("check_consume", Boolean.valueOf(checkConsume));
        String responseContent = this.post(url, param.toString());
        JsonElement tmpJsonElement = Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(responseContent)));
        return (WxMpCardResult)WxMpGsonBuilder.INSTANCE.create().fromJson(tmpJsonElement, new TypeToken<WxMpCardResult>(){}.getType());
    }

    @Override
    public String consumeCardCode(String code) throws WxErrorException {
        return this.consumeCardCode(code, null);
    }

    @Override
    public String consumeCardCode(String code, String cardId) throws WxErrorException {
        String url = "https://api.weixin.qq.com/card/code/consume";
        JsonObject param = new JsonObject();
        param.addProperty("code", code);
        if (cardId != null && !"".equals(cardId)) {
            param.addProperty("card_id", cardId);
        }
        String responseContent = this.post(url, param.toString());
        return responseContent;
    }

    @Override
    public void markCardCode(String code, String cardId, String openId, boolean isMark) throws WxErrorException {
        String url = "https://api.weixin.qq.com/card/code/mark";
        JsonObject param = new JsonObject();
        param.addProperty("code", code);
        param.addProperty("card_id", cardId);
        param.addProperty("openid", openId);
        param.addProperty("is_mark", Boolean.valueOf(isMark));
        String responseContent = this.post(url, param.toString());
        JsonElement tmpJsonElement = Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(responseContent)));
        WxMpCardResult cardResult = (WxMpCardResult)WxMpGsonBuilder.INSTANCE.create().fromJson(tmpJsonElement, new TypeToken<WxMpCardResult>(){}.getType());
        if (!cardResult.getErrorCode().equals("0")) {
            this.log.warn("\u670b\u53cb\u7684\u5238mark\u5931\u8d25\uff1a{}", (Object)cardResult.getErrorMsg());
        }
    }

    @Override
    public String getCardDetail(String cardId) throws WxErrorException {
        String url = "https://api.weixin.qq.com/card/get";
        JsonObject param = new JsonObject();
        param.addProperty("card_id", cardId);
        String responseContent = this.post(url, param.toString());
        JsonObject json = new JsonParser().parse(responseContent).getAsJsonObject();
        String errcode = json.get("errcode").getAsString();
        if (!"0".equals(errcode)) {
            String errmsg = json.get("errmsg").getAsString();
            WxError error = new WxError();
            error.setErrorCode(Integer.valueOf(errcode).intValue());
            error.setErrorMsg(errmsg);
            throw new WxErrorException(error);
        }
        return responseContent;
    }

    @Override
    public WxMpMassSendResult massMessagePreview(WxMpMassPreviewMessage wxMpMassPreviewMessage) throws Exception {
        String url = "https://api.weixin.qq.com/cgi-bin/message/mass/preview";
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)wxMpMassPreviewMessage.toJson());
        return WxMpMassSendResult.fromJson(responseContent);
    }

    @Override
    public WxMediaImgUploadResult mediaImgUpload(File file) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/media/uploadimg";
        return this.execute(new MediaImgUploadRequestExecutor(), url, file);
    }

    @Override
    public String setIndustry(WxMpIndustry wxMpIndustry) throws WxErrorException {
        if (null == wxMpIndustry.getPrimaryIndustry() || null == wxMpIndustry.getPrimaryIndustry().getId() || null == wxMpIndustry.getSecondIndustry() || null == wxMpIndustry.getSecondIndustry().getId()) {
            throw new IllegalArgumentException("industry id is empty");
        }
        String url = "https://api.weixin.qq.com/cgi-bin/template/api_set_industry";
        return (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)wxMpIndustry.toJson());
    }

    @Override
    public WxMpIndustry getIndustry() throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/template/get_industry";
        String responseContent = (String)this.execute((RequestExecutor)new SimpleGetRequestExecutor(), url, null);
        return WxMpIndustry.fromJson(responseContent);
    }

    @Override
    public WxMpKefuService getKefuService() {
        return this.kefuService;
    }
}

