/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.util.Date;
import java.util.List;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpDataCubeService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.bean.datacube.WxDataCubeArticleResult;
import me.chanjar.weixin.mp.bean.datacube.WxDataCubeArticleTotal;
import me.chanjar.weixin.mp.bean.datacube.WxDataCubeUserCumulate;
import me.chanjar.weixin.mp.bean.datacube.WxDataCubeUserSummary;
import me.chanjar.weixin.mp.util.json.WxMpGsonBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMpDataCubeServiceImpl
implements WxMpDataCubeService {
    protected final Logger log = LoggerFactory.getLogger(WxMpServiceImpl.class);
    private static final String API_URL_PREFIX = "https://api.weixin.qq.com/datacube";
    private WxMpService wxMpService;

    public WxMpDataCubeServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }

    @Override
    public List<WxDataCubeUserSummary> getUserSummary(Date beginDate, Date endDate) throws WxErrorException {
        String url = "https://api.weixin.qq.com/datacube/getusersummary";
        JsonObject param = new JsonObject();
        param.addProperty("begin_date", WxMpService.SIMPLE_DATE_FORMAT.format(beginDate));
        param.addProperty("end_date", WxMpService.SIMPLE_DATE_FORMAT.format(endDate));
        String responseContent = this.wxMpService.post(url, param.toString());
        this.log.debug("\nurl:{}\nparams:{}\nresponse:{}", new Object[]{url, param, responseContent});
        return (List)WxMpGsonBuilder.INSTANCE.create().fromJson(new JsonParser().parse(responseContent).getAsJsonObject().get("list"), new TypeToken<List<WxDataCubeUserSummary>>(){}.getType());
    }

    @Override
    public List<WxDataCubeUserCumulate> getUserCumulate(Date beginDate, Date endDate) throws WxErrorException {
        String url = "https://api.weixin.qq.com/datacube/getusercumulate";
        JsonObject param = new JsonObject();
        param.addProperty("begin_date", WxMpService.SIMPLE_DATE_FORMAT.format(beginDate));
        param.addProperty("end_date", WxMpService.SIMPLE_DATE_FORMAT.format(endDate));
        String responseContent = this.wxMpService.post(url, param.toString());
        this.log.debug("\nurl:{}\nparams:{}\nresponse:{}", new Object[]{url, param, responseContent});
        return (List)WxMpGsonBuilder.INSTANCE.create().fromJson(new JsonParser().parse(responseContent).getAsJsonObject().get("list"), new TypeToken<List<WxDataCubeUserCumulate>>(){}.getType());
    }

    @Override
    public List<WxDataCubeArticleResult> getArticleSummary(Date beginDate, Date endDate) throws WxErrorException {
        String url = "https://api.weixin.qq.com/datacube/getarticlesummary";
        JsonObject param = new JsonObject();
        param.addProperty("begin_date", WxMpService.SIMPLE_DATE_FORMAT.format(beginDate));
        param.addProperty("end_date", WxMpService.SIMPLE_DATE_FORMAT.format(endDate));
        String responseContent = this.wxMpService.post(url, param.toString());
        this.log.debug("\nurl:{}\nparams:{}\nresponse:{}", new Object[]{url, param, responseContent});
        return (List)WxMpGsonBuilder.INSTANCE.create().fromJson(new JsonParser().parse(responseContent).getAsJsonObject().get("list"), new TypeToken<List<WxDataCubeArticleResult>>(){}.getType());
    }

    @Override
    public List<WxDataCubeArticleTotal> getArticleTotal(Date beginDate, Date endDate) throws WxErrorException {
        String url = "https://api.weixin.qq.com/datacube/getarticletotal";
        JsonObject param = new JsonObject();
        param.addProperty("begin_date", WxMpService.SIMPLE_DATE_FORMAT.format(beginDate));
        param.addProperty("end_date", WxMpService.SIMPLE_DATE_FORMAT.format(endDate));
        String responseContent = this.wxMpService.post(url, param.toString());
        this.log.debug("\nurl:{}\nparams:{}\nresponse:{}", new Object[]{url, param, responseContent});
        return (List)WxMpGsonBuilder.INSTANCE.create().fromJson(new JsonParser().parse(responseContent).getAsJsonObject().get("list"), new TypeToken<List<WxDataCubeArticleTotal>>(){}.getType());
    }

    @Override
    public List<WxDataCubeArticleResult> getUserRead(Date beginDate, Date endDate) throws WxErrorException {
        String url = "https://api.weixin.qq.com/datacube/getuserread";
        JsonObject param = new JsonObject();
        param.addProperty("begin_date", WxMpService.SIMPLE_DATE_FORMAT.format(beginDate));
        param.addProperty("end_date", WxMpService.SIMPLE_DATE_FORMAT.format(endDate));
        String responseContent = this.wxMpService.post(url, param.toString());
        this.log.debug("\nurl:{}\nparams:{}\nresponse:{}", new Object[]{url, param, responseContent});
        return (List)WxMpGsonBuilder.INSTANCE.create().fromJson(new JsonParser().parse(responseContent).getAsJsonObject().get("list"), new TypeToken<List<WxDataCubeArticleResult>>(){}.getType());
    }

    @Override
    public List<WxDataCubeArticleResult> getUserReadHour(Date beginDate, Date endDate) throws WxErrorException {
        String url = "https://api.weixin.qq.com/datacube/getuserreadhour";
        JsonObject param = new JsonObject();
        param.addProperty("begin_date", WxMpService.SIMPLE_DATE_FORMAT.format(beginDate));
        param.addProperty("end_date", WxMpService.SIMPLE_DATE_FORMAT.format(endDate));
        String responseContent = this.wxMpService.post(url, param.toString());
        this.log.debug("\nurl:{}\nparams:{}\nresponse:{}", new Object[]{url, param, responseContent});
        return (List)WxMpGsonBuilder.INSTANCE.create().fromJson(new JsonParser().parse(responseContent).getAsJsonObject().get("list"), new TypeToken<List<WxDataCubeArticleResult>>(){}.getType());
    }

    @Override
    public List<WxDataCubeArticleResult> getUserShare(Date beginDate, Date endDate) throws WxErrorException {
        String url = "https://api.weixin.qq.com/datacube/getusershare";
        JsonObject param = new JsonObject();
        param.addProperty("begin_date", WxMpService.SIMPLE_DATE_FORMAT.format(beginDate));
        param.addProperty("end_date", WxMpService.SIMPLE_DATE_FORMAT.format(endDate));
        String responseContent = this.wxMpService.post(url, param.toString());
        this.log.debug("\nurl:{}\nparams:{}\nresponse:{}", new Object[]{url, param, responseContent});
        return (List)WxMpGsonBuilder.INSTANCE.create().fromJson(new JsonParser().parse(responseContent).getAsJsonObject().get("list"), new TypeToken<List<WxDataCubeArticleResult>>(){}.getType());
    }

    @Override
    public List<WxDataCubeArticleResult> getUserShareHour(Date beginDate, Date endDate) throws WxErrorException {
        String url = "https://api.weixin.qq.com/datacube/getusersharehour";
        JsonObject param = new JsonObject();
        param.addProperty("begin_date", WxMpService.SIMPLE_DATE_FORMAT.format(beginDate));
        param.addProperty("end_date", WxMpService.SIMPLE_DATE_FORMAT.format(endDate));
        String responseContent = this.wxMpService.post(url, param.toString());
        this.log.debug("\nurl:{}\nparams:{}\nresponse:{}", new Object[]{url, param, responseContent});
        return (List)WxMpGsonBuilder.INSTANCE.create().fromJson(new JsonParser().parse(responseContent).getAsJsonObject().get("list"), new TypeToken<List<WxDataCubeArticleResult>>(){}.getType());
    }
}

