/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.UUID;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.InputStreamResponseHandler;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.Utf8ResponseHandler;
import me.chanjar.weixin.mp.bean.result.WxMpQrCodeTicket;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;

public class QrCodeRequestExecutor
implements RequestExecutor<File, WxMpQrCodeTicket> {
    /*
     * Loose catch block
     */
    public File execute(CloseableHttpClient httpclient, HttpHost httpProxy, String uri, WxMpQrCodeTicket ticket) throws WxErrorException, IOException {
        if (ticket != null) {
            if (uri.indexOf(63) == -1) {
                uri = uri + '?';
            }
            uri = uri + (uri.endsWith("?") ? "ticket=" + URLEncoder.encode(ticket.getTicket(), "UTF-8") : "&ticket=" + URLEncoder.encode(ticket.getTicket(), "UTF-8"));
        }
        HttpGet httpGet = new HttpGet(uri);
        if (httpProxy != null) {
            RequestConfig config = RequestConfig.custom().setProxy(httpProxy).build();
            httpGet.setConfig(config);
        }
        try {
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);){
                Header[] contentTypeHeader = response.getHeaders("Content-Type");
                if (contentTypeHeader != null && contentTypeHeader.length > 0 && ContentType.TEXT_PLAIN.getMimeType().equals(contentTypeHeader[0].getValue())) {
                    String responseContent = (String)Utf8ResponseHandler.INSTANCE.handleResponse((HttpResponse)response);
                    throw new WxErrorException(WxError.fromJson((String)responseContent));
                }
                InputStream inputStream = (InputStream)InputStreamResponseHandler.INSTANCE.handleResponse((HttpResponse)response);
                File file = FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)"jpg");
                return file;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            httpGet.releaseConnection();
        }
    }
}

