/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.mp.bean.material.WxMpMaterialNews;

public class WxMpMaterialNewsArticleGsonAdapter
implements JsonSerializer<WxMpMaterialNews.WxMpMaterialNewsArticle>,
JsonDeserializer<WxMpMaterialNews.WxMpMaterialNewsArticle> {
    public JsonElement serialize(WxMpMaterialNews.WxMpMaterialNewsArticle article, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject articleJson = new JsonObject();
        articleJson.addProperty("thumb_media_id", article.getThumbMediaId());
        articleJson.addProperty("thumb_url", article.getThumbUrl());
        articleJson.addProperty("title", article.getTitle());
        articleJson.addProperty("content", article.getContent());
        if (null != article.getAuthor()) {
            articleJson.addProperty("author", article.getAuthor());
        }
        if (null != article.getContentSourceUrl()) {
            articleJson.addProperty("content_source_url", article.getContentSourceUrl());
        }
        if (null != article.getDigest()) {
            articleJson.addProperty("digest", article.getDigest());
        }
        articleJson.addProperty("show_cover_pic", article.isShowCoverPic() ? "1" : "0");
        if (null != article.getUrl()) {
            articleJson.addProperty("url", article.getUrl());
        }
        return articleJson;
    }

    public WxMpMaterialNews.WxMpMaterialNewsArticle deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonElement url;
        JsonElement showCoverPic;
        JsonElement thumbUrl;
        JsonElement thumbMediaId;
        JsonElement digest;
        JsonElement author;
        JsonElement contentSourceUrl;
        JsonElement content;
        JsonObject articleInfo = jsonElement.getAsJsonObject();
        WxMpMaterialNews.WxMpMaterialNewsArticle article = new WxMpMaterialNews.WxMpMaterialNewsArticle();
        JsonElement title = articleInfo.get("title");
        if (title != null && !title.isJsonNull()) {
            article.setTitle(GsonHelper.getAsString((JsonElement)title));
        }
        if ((content = articleInfo.get("content")) != null && !content.isJsonNull()) {
            article.setContent(GsonHelper.getAsString((JsonElement)content));
        }
        if ((contentSourceUrl = articleInfo.get("content_source_url")) != null && !contentSourceUrl.isJsonNull()) {
            article.setContentSourceUrl(GsonHelper.getAsString((JsonElement)contentSourceUrl));
        }
        if ((author = articleInfo.get("author")) != null && !author.isJsonNull()) {
            article.setAuthor(GsonHelper.getAsString((JsonElement)author));
        }
        if ((digest = articleInfo.get("digest")) != null && !digest.isJsonNull()) {
            article.setDigest(GsonHelper.getAsString((JsonElement)digest));
        }
        if ((thumbMediaId = articleInfo.get("thumb_media_id")) != null && !thumbMediaId.isJsonNull()) {
            article.setThumbMediaId(GsonHelper.getAsString((JsonElement)thumbMediaId));
        }
        if ((thumbUrl = articleInfo.get("thumb_url")) != null && !thumbUrl.isJsonNull()) {
            article.setThumbUrl(GsonHelper.getAsString((JsonElement)thumbUrl));
        }
        if ((showCoverPic = articleInfo.get("show_cover_pic")) != null && !showCoverPic.isJsonNull()) {
            article.setShowCoverPic(GsonHelper.getAsBoolean((JsonElement)showCoverPic));
        }
        if ((url = articleInfo.get("url")) != null && !url.isJsonNull()) {
            article.setUrl(GsonHelper.getAsString((JsonElement)url));
        }
        return article;
    }
}

