/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import me.chanjar.weixin.common.bean.menu.WxMenu;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpMenuService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.menu.WxMpGetSelfMenuInfoResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMpMenuServiceImpl
implements WxMpMenuService {
    private static final String API_URL_PREFIX = "https://api.weixin.qq.com/cgi-bin/menu";
    private static Logger log = LoggerFactory.getLogger(WxMpMenuServiceImpl.class);
    private WxMpService wxMpService;

    public WxMpMenuServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }

    @Override
    public void menuCreate(WxMenu menu) throws WxErrorException {
        String menuJson = menu.toJson();
        String url = "https://api.weixin.qq.com/cgi-bin/menu/create";
        if (menu.getMatchRule() != null) {
            url = "https://api.weixin.qq.com/cgi-bin/menu/addconditional";
        }
        log.debug("\u5f00\u59cb\u521b\u5efa\u83dc\u5355\uff1a{}", (Object)menuJson);
        String result = this.wxMpService.post(url, menuJson);
        log.debug("\u521b\u5efa\u83dc\u5355\uff1a{},\u7ed3\u679c\uff1a{}", (Object)menuJson, (Object)result);
    }

    @Override
    public void menuDelete() throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/delete";
        String result = this.wxMpService.get(url, null);
        log.debug("\u5220\u9664\u83dc\u5355\u7ed3\u679c\uff1a{}", (Object)result);
    }

    @Override
    public void menuDelete(String menuid) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/delconditional";
        String result = this.wxMpService.get(url, "menuid=" + menuid);
        log.debug("\u6839\u636eMeunId({})\u5220\u9664\u83dc\u5355\u7ed3\u679c\uff1a{}", (Object)menuid, (Object)result);
    }

    @Override
    public WxMenu menuGet() throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/get";
        try {
            String resultContent = this.wxMpService.get(url, null);
            return WxMenu.fromJson((String)resultContent);
        }
        catch (WxErrorException e) {
            if (e.getError().getErrorCode() == 46003) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public WxMenu menuTryMatch(String userid) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/trymatch";
        try {
            String resultContent = this.wxMpService.get(url, "user_id=" + userid);
            return WxMenu.fromJson((String)resultContent);
        }
        catch (WxErrorException e) {
            if (e.getError().getErrorCode() == 46003 || e.getError().getErrorCode() == 46002) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public WxMpGetSelfMenuInfoResult getSelfMenuInfo() throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/get_current_selfmenu_info";
        String resultContent = this.wxMpService.get(url, null);
        return WxMpGetSelfMenuInfoResult.fromJson(resultContent);
    }
}

