/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.github.binarywang.utils.qrcode.QrcodeUtils;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.BeanUtils;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;
import me.chanjar.weixin.mp.api.WxMpPayService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.pay.request.WxEntPayQueryRequest;
import me.chanjar.weixin.mp.bean.pay.request.WxEntPayRequest;
import me.chanjar.weixin.mp.bean.pay.request.WxPayBaseRequest;
import me.chanjar.weixin.mp.bean.pay.request.WxPayOrderCloseRequest;
import me.chanjar.weixin.mp.bean.pay.request.WxPayOrderQueryRequest;
import me.chanjar.weixin.mp.bean.pay.request.WxPayRedpackQueryRequest;
import me.chanjar.weixin.mp.bean.pay.request.WxPayRefundQueryRequest;
import me.chanjar.weixin.mp.bean.pay.request.WxPayRefundRequest;
import me.chanjar.weixin.mp.bean.pay.request.WxPaySendRedpackRequest;
import me.chanjar.weixin.mp.bean.pay.request.WxPayUnifiedOrderRequest;
import me.chanjar.weixin.mp.bean.pay.result.WxEntPayQueryResult;
import me.chanjar.weixin.mp.bean.pay.result.WxEntPayResult;
import me.chanjar.weixin.mp.bean.pay.result.WxPayBaseResult;
import me.chanjar.weixin.mp.bean.pay.result.WxPayOrderCloseResult;
import me.chanjar.weixin.mp.bean.pay.result.WxPayOrderNotifyResult;
import me.chanjar.weixin.mp.bean.pay.result.WxPayOrderQueryResult;
import me.chanjar.weixin.mp.bean.pay.result.WxPayRedpackQueryResult;
import me.chanjar.weixin.mp.bean.pay.result.WxPayRefundQueryResult;
import me.chanjar.weixin.mp.bean.pay.result.WxPayRefundResult;
import me.chanjar.weixin.mp.bean.pay.result.WxPaySendRedpackResult;
import me.chanjar.weixin.mp.bean.pay.result.WxPayUnifiedOrderResult;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMpPayServiceImpl
implements WxMpPayService {
    private static final String PAY_BASE_URL = "https://api.mch.weixin.qq.com";
    private static final String[] TRADE_TYPES = new String[]{"JSAPI", "NATIVE", "APP"};
    private static final String[] REFUND_ACCOUNT = new String[]{"REFUND_SOURCE_RECHARGE_FUNDS", "REFUND_SOURCE_UNSETTLED_FUNDS"};
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private WxMpService wxMpService;

    public WxMpPayServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }

    private WxMpConfigStorage getConfig() {
        return this.wxMpService.getWxMpConfigStorage();
    }

    @Override
    public WxPayRefundResult refund(WxPayRefundRequest request) throws WxErrorException {
        this.initRequest(request);
        if (StringUtils.isBlank((CharSequence)request.getOpUserId())) {
            request.setOpUserId(this.getConfig().getPartnerId());
        }
        this.checkParameters(request);
        request.setSign(this.createSign(request));
        String url = "https://api.mch.weixin.qq.com/secapi/pay/refund";
        String responseContent = this.executeWithKey(url, request.toXML());
        WxPayRefundResult result = WxPayRefundResult.fromXML(responseContent, WxPayRefundResult.class);
        this.checkResult(result);
        return result;
    }

    @Override
    public WxPayRefundQueryResult refundQuery(String transactionId, String outTradeNo, String outRefundNo, String refundId) throws WxErrorException {
        if (StringUtils.isBlank((CharSequence)transactionId) && StringUtils.isBlank((CharSequence)outTradeNo) && StringUtils.isBlank((CharSequence)outRefundNo) && StringUtils.isBlank((CharSequence)refundId) || StringUtils.isNotBlank((CharSequence)transactionId) && StringUtils.isNotBlank((CharSequence)outTradeNo) && StringUtils.isNotBlank((CharSequence)outRefundNo) && StringUtils.isNotBlank((CharSequence)refundId)) {
            throw new IllegalArgumentException("transaction_id \uff0c out_trade_no\uff0cout_refund_no\uff0c refund_id \u5fc5\u987b\u56db\u9009\u4e00");
        }
        WxPayRefundQueryRequest request = new WxPayRefundQueryRequest();
        this.initRequest(request);
        request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        request.setTransactionId(StringUtils.trimToNull((String)transactionId));
        request.setOutRefundNo(StringUtils.trimToNull((String)outRefundNo));
        request.setRefundId(StringUtils.trimToNull((String)refundId));
        request.setSign(this.createSign(request));
        String url = "https://api.mch.weixin.qq.com/pay/refundquery";
        String responseContent = this.executeRequest(url, request.toXML());
        WxPayRefundQueryResult result = WxPayRefundQueryResult.fromXML(responseContent, WxPayRefundQueryResult.class);
        result.composeRefundRecords();
        this.checkResult(result);
        return result;
    }

    private void checkResult(WxPayBaseResult result) throws WxErrorException {
        Map<String, String> map = result.toMap();
        if (!this.checkSign(map)) {
            this.log.debug("\u6821\u9a8c\u7ed3\u679c\u7b7e\u540d\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}", map);
            throw new WxErrorException(WxError.newBuilder().setErrorCode(-1).setErrorMsg("\u53c2\u6570\u683c\u5f0f\u6821\u9a8c\u9519\u8bef\uff01").build());
        }
        if (!"SUCCESS".equalsIgnoreCase(result.getReturnCode()) || !"SUCCESS".equalsIgnoreCase(result.getResultCode())) {
            WxError error = WxError.newBuilder().setErrorCode(-1).setErrorMsg("\u8fd4\u56de\u4ee3\u7801: " + result.getReturnCode() + ", \u8fd4\u56de\u4fe1\u606f: " + result.getReturnMsg() + ", \u7ed3\u679c\u4ee3\u7801: " + result.getResultCode() + ", \u9519\u8bef\u4ee3\u7801: " + result.getErrCode() + ", \u9519\u8bef\u8be6\u60c5: " + result.getErrCodeDes()).build();
            this.log.error("\u7ed3\u679c\u4e1a\u52a1\u4ee3\u7801\u5f02\u5e38\uff0c\u53c2\u6570\uff1a{},\u8be6\u7ec6\uff1a{}", map, (Object)error);
            throw new WxErrorException(error);
        }
    }

    private void checkParameters(WxPayRefundRequest request) throws WxErrorException {
        BeanUtils.checkRequiredFields((Object)request);
        if (StringUtils.isNotBlank((CharSequence)request.getRefundAccount()) && !ArrayUtils.contains((Object[])REFUND_ACCOUNT, (Object)request.getRefundAccount())) {
            throw new IllegalArgumentException("refund_account\u76ee\u524d\u5fc5\u987b\u4e3a" + Arrays.toString(REFUND_ACCOUNT) + "\u5176\u4e2d\u4e4b\u4e00,\u5b9e\u9645\u503c\uff1a" + request.getRefundAccount());
        }
        if (StringUtils.isBlank((CharSequence)request.getOutTradeNo()) && StringUtils.isBlank((CharSequence)request.getTransactionId())) {
            throw new IllegalArgumentException("transaction_id \u548c out_trade_no \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff0c\u5fc5\u987b\u63d0\u4f9b\u4e00\u4e2a");
        }
    }

    @Override
    public WxPayOrderNotifyResult getOrderNotifyResult(String xmlData) throws WxErrorException {
        try {
            this.log.trace("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u53c2\u6570\u8be6\u7ec6\uff1a{}", (Object)xmlData);
            WxPayOrderNotifyResult result = WxPayOrderNotifyResult.fromXML(xmlData);
            this.log.debug("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u7ed3\u679c\u5bf9\u8c61\uff1a{}", (Object)result);
            this.checkResult(result);
            return result;
        }
        catch (WxErrorException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new WxErrorException(WxError.newBuilder().setErrorMsg("\u53d1\u751f\u5f02\u5e38" + e.getMessage()).build());
        }
    }

    @Override
    public WxPaySendRedpackResult sendRedpack(WxPaySendRedpackRequest request) throws WxErrorException {
        this.initRequest(request);
        request.setSign(this.createSign(request));
        String url = "https://api.mch.weixin.qq.com/mmpaymkttransfers/sendredpack";
        if (request.getAmtType() != null) {
            url = "https://api.mch.weixin.qq.com/mmpaymkttransfers/sendgroupredpack";
        }
        String responseContent = this.executeWithKey(url, request.toXML());
        WxPaySendRedpackResult result = WxPaySendRedpackResult.fromXML(responseContent, WxPaySendRedpackResult.class);
        this.checkResult(result);
        return result;
    }

    @Override
    public WxPayRedpackQueryResult queryRedpack(String mchBillNo) throws WxErrorException {
        WxPayRedpackQueryRequest request = new WxPayRedpackQueryRequest();
        request.setMchBillNo(mchBillNo);
        request.setBillType("MCHT");
        this.initRequest(request);
        request.setSign(this.createSign(request));
        String url = "https://api.mch.weixin.qq.com/mmpaymkttransfers/gethbinfo";
        String responseContent = this.executeWithKey(url, request.toXML());
        WxPayRedpackQueryResult result = WxPayRedpackQueryResult.fromXML(responseContent, WxPayRedpackQueryResult.class);
        this.checkResult(result);
        return result;
    }

    @Override
    public WxPayOrderQueryResult queryOrder(String transactionId, String outTradeNo) throws WxErrorException {
        if (StringUtils.isBlank((CharSequence)transactionId) && StringUtils.isBlank((CharSequence)outTradeNo) || StringUtils.isNotBlank((CharSequence)transactionId) && StringUtils.isNotBlank((CharSequence)outTradeNo)) {
            throw new IllegalArgumentException("transaction_id \u548c out_trade_no \u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u6216\u540c\u65f6\u4e3a\u7a7a\uff0c\u5fc5\u987b\u4e8c\u9009\u4e00");
        }
        WxPayOrderQueryRequest request = new WxPayOrderQueryRequest();
        request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        request.setTransactionId(StringUtils.trimToNull((String)transactionId));
        this.initRequest(request);
        request.setSign(this.createSign(request));
        String url = "https://api.mch.weixin.qq.com/pay/orderquery";
        String responseContent = this.executeRequest(url, request.toXML());
        WxPayOrderQueryResult result = WxPayOrderQueryResult.fromXML(responseContent, WxPayOrderQueryResult.class);
        result.composeCoupons();
        this.checkResult(result);
        return result;
    }

    @Override
    public WxPayOrderCloseResult closeOrder(String outTradeNo) throws WxErrorException {
        if (StringUtils.isBlank((CharSequence)outTradeNo)) {
            throw new IllegalArgumentException("out_trade_no \u4e0d\u80fd\u4e3a\u7a7a");
        }
        WxPayOrderCloseRequest request = new WxPayOrderCloseRequest();
        request.setOutTradeNo(StringUtils.trimToNull((String)outTradeNo));
        this.initRequest(request);
        request.setSign(this.createSign(request));
        String url = "https://api.mch.weixin.qq.com/pay/closeorder";
        String responseContent = this.executeRequest(url, request.toXML());
        WxPayOrderCloseResult result = WxPayOrderCloseResult.fromXML(responseContent, WxPayOrderCloseResult.class);
        this.checkResult(result);
        return result;
    }

    @Override
    public WxPayUnifiedOrderResult unifiedOrder(WxPayUnifiedOrderRequest request) throws WxErrorException {
        this.initRequest(request);
        if (StringUtils.isBlank((CharSequence)request.getNotifyURL())) {
            request.setNotifyURL(this.getConfig().getNotifyURL());
        }
        if (StringUtils.isBlank((CharSequence)request.getTradeType())) {
            request.setTradeType(this.getConfig().getTradeType());
        }
        this.checkParameters(request);
        request.setSign(this.createSign(request));
        String url = "https://api.mch.weixin.qq.com/pay/unifiedorder";
        String xmlParam = request.toXML();
        this.log.debug("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u63a5\u53e3\uff0cURL:{},\u53c2\u6570\uff1a{}", (Object)url, (Object)xmlParam);
        String responseContent = this.executeRequest(url, xmlParam);
        this.log.debug("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u63a5\u53e3\uff0cURL:{},\u7ed3\u679c\uff1a{}", (Object)url, (Object)responseContent);
        WxPayUnifiedOrderResult result = WxPayUnifiedOrderResult.fromXML(responseContent, WxPayUnifiedOrderResult.class);
        this.checkResult(result);
        return result;
    }

    private void initRequest(WxPayBaseRequest request) {
        if (StringUtils.isBlank((CharSequence)request.getAppid())) {
            request.setAppid(this.getConfig().getAppId());
        }
        if (StringUtils.isBlank((CharSequence)request.getMchId())) {
            request.setMchId(this.getConfig().getPartnerId());
        }
        if (StringUtils.isBlank((CharSequence)request.getNonceStr())) {
            request.setNonceStr(String.valueOf(System.currentTimeMillis()));
        }
    }

    private void checkParameters(WxPayUnifiedOrderRequest request) throws WxErrorException {
        BeanUtils.checkRequiredFields((Object)request);
        if (!ArrayUtils.contains((Object[])TRADE_TYPES, (Object)request.getTradeType())) {
            throw new IllegalArgumentException("trade_type\u76ee\u524d\u5fc5\u987b\u4e3a" + Arrays.toString(TRADE_TYPES) + "\u5176\u4e2d\u4e4b\u4e00,\u5b9e\u9645\u503c\uff1a" + request.getTradeType());
        }
        if ("JSAPI".equals(request.getTradeType()) && request.getOpenid() == null) {
            throw new IllegalArgumentException("\u5f53 trade_type\u662f'JSAPI'\u65f6\u672a\u6307\u5b9aopenid");
        }
        if ("NATIVE".equals(request.getTradeType()) && request.getProductId() == null) {
            throw new IllegalArgumentException("\u5f53 trade_type\u662f'NATIVE'\u65f6\u672a\u6307\u5b9aproduct_id");
        }
    }

    @Override
    public Map<String, String> getPayInfo(WxPayUnifiedOrderRequest request) throws WxErrorException {
        WxPayUnifiedOrderResult unifiedOrderResult = this.unifiedOrder(request);
        String prepayId = unifiedOrderResult.getPrepayId();
        if (StringUtils.isBlank((CharSequence)prepayId)) {
            throw new RuntimeException(String.format("Failed to get prepay id due to error code '%s'(%s).", unifiedOrderResult.getErrCode(), unifiedOrderResult.getErrCodeDes()));
        }
        HashMap<String, String> payInfo = new HashMap<String, String>();
        payInfo.put("appId", this.getConfig().getAppId());
        payInfo.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
        payInfo.put("nonceStr", String.valueOf(System.currentTimeMillis()));
        payInfo.put("package", "prepay_id=" + prepayId);
        payInfo.put("signType", "MD5");
        if ("NATIVE".equals(request.getTradeType())) {
            payInfo.put("codeUrl", unifiedOrderResult.getCodeURL());
        }
        payInfo.put("paySign", this.createSign(payInfo));
        return payInfo;
    }

    @Override
    public WxEntPayResult entPay(WxEntPayRequest request) throws WxErrorException {
        this.initRequest(request);
        BeanUtils.checkRequiredFields((Object)request);
        request.setSign(this.createSign(request));
        String url = "https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers";
        String responseContent = this.executeWithKey(url, request.toXML());
        WxEntPayResult result = WxEntPayResult.fromXML(responseContent, WxEntPayResult.class);
        this.checkResult(result);
        return result;
    }

    @Override
    public WxEntPayQueryResult queryEntPay(String partnerTradeNo) throws WxErrorException {
        WxEntPayQueryRequest request = new WxEntPayQueryRequest();
        this.initRequest(request);
        request.setSign(this.createSign(request));
        String url = "https://api.mch.weixin.qq.com/mmpaymkttransfers/gettransferinfo";
        String responseContent = this.executeWithKey(url, request.toXML());
        WxEntPayQueryResult result = WxEntPayQueryResult.fromXML(responseContent, WxEntPayQueryResult.class);
        this.checkResult(result);
        return result;
    }

    @Override
    public byte[] createScanPayQrcodeMode1(String productId, File logoFile, Integer sideLength) {
        StringBuilder codeUrl = new StringBuilder("weixin://wxpay/bizpayurl?");
        HashMap params = Maps.newHashMap();
        params.put("appid", this.getConfig().getAppId());
        params.put("mch_id", this.getConfig().getPartnerId());
        params.put("product_id", productId);
        params.put("time_stamp", String.valueOf(System.currentTimeMillis()));
        params.put("nonce_str", String.valueOf(System.currentTimeMillis()));
        String sign = this.createSign(params);
        params.put("sign", sign);
        for (String key : params.keySet()) {
            codeUrl.append(key + "=" + (String)params.get(key) + "&");
        }
        String content = codeUrl.toString().substring(0, codeUrl.length() - 1);
        if (sideLength == null || sideLength < 1) {
            return QrcodeUtils.createQrcode((String)content, (File)logoFile);
        }
        return QrcodeUtils.createQrcode((String)content, (int)sideLength, (File)logoFile);
    }

    @Override
    public byte[] createScanPayQrcodeMode2(String codeUrl, File logoFile, Integer sideLength) {
        if (sideLength == null || sideLength < 1) {
            return QrcodeUtils.createQrcode((String)codeUrl, (File)logoFile);
        }
        return QrcodeUtils.createQrcode((String)codeUrl, (int)sideLength, (File)logoFile);
    }

    /*
     * Exception decompiling
     */
    private String executeRequest(String url, String requestStr) throws WxErrorException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private String executeWithKey(String url, String requestStr) throws WxErrorException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String createSign(Object xmlBean) {
        return this.createSign(BeanUtils.xmlBean2Map((Object)xmlBean), this.getConfig().getPartnerKey());
    }

    @Override
    public String createSign(Object xmlBean, String signKey) {
        return this.createSign(BeanUtils.xmlBean2Map((Object)xmlBean), signKey);
    }

    @Override
    public String createSign(Map<String, String> params) {
        return this.createSign(params, this.getConfig().getPartnerKey());
    }

    @Override
    public String createSign(Map<String, String> params, String signKey) {
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(params);
        StringBuilder toSign = new StringBuilder();
        for (String key : sortedMap.keySet()) {
            String value = params.get(key);
            if (!StringUtils.isNotEmpty((CharSequence)value) || "sign".equals(key) || "key".equals(key)) continue;
            toSign.append(key + "=" + value + "&");
        }
        toSign.append("key=" + signKey);
        return DigestUtils.md5Hex((String)toSign.toString()).toUpperCase();
    }

    @Override
    public boolean checkSign(Object xmlBean) {
        return this.checkSign(BeanUtils.xmlBean2Map((Object)xmlBean), this.getConfig().getPartnerKey());
    }

    @Override
    public boolean checkSign(Object xmlBean, String signKey) {
        return this.checkSign(BeanUtils.xmlBean2Map((Object)xmlBean), signKey);
    }

    @Override
    public boolean checkSign(Map<String, String> params) {
        return this.checkSign(params, this.getConfig().getPartnerKey());
    }

    @Override
    public boolean checkSign(Map<String, String> params, String signKey) {
        String sign = this.createSign(params, signKey);
        return sign.equals(params.get("sign"));
    }
}

