/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.mp.api.WxMpQrcodeService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpQrCodeTicket;
import me.chanjar.weixin.mp.util.http.QrCodeRequestExecutor;

public class WxMpQrcodeServiceImpl
implements WxMpQrcodeService {
    private static final String API_URL_PREFIX = "https://api.weixin.qq.com/cgi-bin/qrcode";
    private WxMpService wxMpService;

    public WxMpQrcodeServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }

    @Override
    public WxMpQrCodeTicket qrCodeCreateTmpTicket(int sceneId, Integer expireSeconds) throws WxErrorException {
        if (sceneId == 0) {
            throw new WxErrorException(WxError.newBuilder().setErrorCode(-1).setErrorMsg("\u4e34\u65f6\u4e8c\u7ef4\u7801\u573a\u666f\u53ea\u4e0d\u80fd\u4e3a0\uff01").build());
        }
        String url = "https://api.weixin.qq.com/cgi-bin/qrcode/create";
        JsonObject json = new JsonObject();
        json.addProperty("action_name", "QR_SCENE");
        if (expireSeconds != null) {
            json.addProperty("expire_seconds", (Number)expireSeconds);
        }
        JsonObject actionInfo = new JsonObject();
        JsonObject scene = new JsonObject();
        scene.addProperty("scene_id", (Number)sceneId);
        actionInfo.add("scene", (JsonElement)scene);
        json.add("action_info", (JsonElement)actionInfo);
        String responseContent = (String)this.wxMpService.execute(new SimplePostRequestExecutor(), url, json.toString());
        return WxMpQrCodeTicket.fromJson(responseContent);
    }

    @Override
    public WxMpQrCodeTicket qrCodeCreateLastTicket(int sceneId) throws WxErrorException {
        if (sceneId < 1 || sceneId > 100000) {
            throw new WxErrorException(WxError.newBuilder().setErrorCode(-1).setErrorMsg("\u6c38\u4e45\u4e8c\u7ef4\u7801\u7684\u573a\u666f\u503c\u76ee\u524d\u53ea\u652f\u63011--100000\uff01").build());
        }
        String url = "https://api.weixin.qq.com/cgi-bin/qrcode/create";
        JsonObject json = new JsonObject();
        json.addProperty("action_name", "QR_LIMIT_SCENE");
        JsonObject actionInfo = new JsonObject();
        JsonObject scene = new JsonObject();
        scene.addProperty("scene_id", (Number)sceneId);
        actionInfo.add("scene", (JsonElement)scene);
        json.add("action_info", (JsonElement)actionInfo);
        String responseContent = (String)this.wxMpService.execute(new SimplePostRequestExecutor(), url, json.toString());
        return WxMpQrCodeTicket.fromJson(responseContent);
    }

    @Override
    public WxMpQrCodeTicket qrCodeCreateLastTicket(String sceneStr) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/qrcode/create";
        JsonObject json = new JsonObject();
        json.addProperty("action_name", "QR_LIMIT_STR_SCENE");
        JsonObject actionInfo = new JsonObject();
        JsonObject scene = new JsonObject();
        scene.addProperty("scene_str", sceneStr);
        actionInfo.add("scene", (JsonElement)scene);
        json.add("action_info", (JsonElement)actionInfo);
        String responseContent = (String)this.wxMpService.execute(new SimplePostRequestExecutor(), url, json.toString());
        return WxMpQrCodeTicket.fromJson(responseContent);
    }

    @Override
    public File qrCodePicture(WxMpQrCodeTicket ticket) throws WxErrorException {
        String url = "https://mp.weixin.qq.com/cgi-bin/showqrcode";
        return this.wxMpService.execute(new QrCodeRequestExecutor(), url, ticket);
    }

    @Override
    public String qrCodePictureUrl(String ticket, boolean needShortUrl) throws WxErrorException {
        String url = "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=%s";
        try {
            String resultUrl = String.format(url, URLEncoder.encode(ticket, StandardCharsets.UTF_8.name()));
            if (needShortUrl) {
                return this.wxMpService.shortUrl(resultUrl);
            }
            return resultUrl;
        }
        catch (UnsupportedEncodingException e) {
            WxError error = WxError.newBuilder().setErrorCode(-1).setErrorMsg(e.getMessage()).build();
            throw new WxErrorException(error);
        }
    }

    @Override
    public String qrCodePictureUrl(String ticket) throws WxErrorException {
        return this.qrCodePictureUrl(ticket, false);
    }
}

