/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api;

import java.io.File;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.util.ToStringUtils;
import me.chanjar.weixin.common.util.http.ApacheHttpClientBuilder;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;
import redis.clients.jedis.Jedis;

public class WxMpInRedisConfigStorage
implements WxMpConfigStorage {
    private static final String ACCESS_TOKEN_KEY = "wechat_access_token_";
    private static final String JSAPI_TICKET_KEY = "wechat_jsapi_ticket_";
    private static final String CARDAPI_TICKET_KEY = "wechat_cardapi_ticket_";
    protected volatile String appId;
    protected volatile String secret;
    protected volatile String partnerId;
    protected volatile String partnerKey;
    protected volatile String notifyURL;
    protected volatile String tradeType;
    protected volatile String token;
    protected volatile String accessToken;
    protected volatile String aesKey;
    protected volatile long expiresTime;
    protected volatile String oauth2redirectUri;
    protected volatile String httpProxyHost;
    protected volatile int httpProxyPort;
    protected volatile String httpProxyUsername;
    protected volatile String httpProxyPassword;
    protected volatile String jsapiTicket;
    protected volatile long jsapiTicketExpiresTime;
    protected volatile String cardApiTicket;
    protected volatile long cardApiTicketExpiresTime;
    protected Lock accessTokenLock = new ReentrantLock();
    protected Lock jsapiTicketLock = new ReentrantLock();
    protected Lock cardApiTicketLock = new ReentrantLock();
    protected volatile File tmpDirFile;
    protected volatile SSLContext sslContext;
    protected volatile ApacheHttpClientBuilder apacheHttpClientBuilder;
    protected Jedis jedis;

    @Override
    public String getAccessToken() {
        return this.jedis.get(ACCESS_TOKEN_KEY.concat(this.appId));
    }

    @Override
    public Lock getAccessTokenLock() {
        return this.accessTokenLock;
    }

    @Override
    public boolean isAccessTokenExpired() {
        return this.getAccessToken() == null;
    }

    @Override
    public synchronized void updateAccessToken(WxAccessToken accessToken) {
        this.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
    }

    @Override
    public synchronized void updateAccessToken(String accessToken, int expiresInSeconds) {
        this.accessToken = accessToken;
        this.expiresTime = System.currentTimeMillis() + (long)(expiresInSeconds - 200) * 1000L;
        this.jedis.set(ACCESS_TOKEN_KEY.concat(this.appId), accessToken);
        this.jedis.expire(ACCESS_TOKEN_KEY.concat(this.appId), expiresInSeconds - 200);
    }

    @Override
    public void expireAccessToken() {
        this.expiresTime = 0L;
    }

    @Override
    public String getJsapiTicket() {
        return this.jsapiTicket;
    }

    public void setJsapiTicket(String jsapiTicket) {
        this.jsapiTicket = jsapiTicket;
    }

    @Override
    public Lock getJsapiTicketLock() {
        return this.jsapiTicketLock;
    }

    @Override
    public boolean isJsapiTicketExpired() {
        return this.getJsapiTicket() == null;
    }

    @Override
    public synchronized void updateJsapiTicket(String jsapiTicket, int expiresInSeconds) {
        this.jsapiTicket = jsapiTicket;
        this.jsapiTicketExpiresTime = System.currentTimeMillis() + (long)(expiresInSeconds - 200) * 1000L;
        this.jedis.set(JSAPI_TICKET_KEY.concat(this.appId), this.accessToken);
        this.jedis.expire(JSAPI_TICKET_KEY.concat(this.appId), expiresInSeconds - 200);
    }

    @Override
    public void expireJsapiTicket() {
        this.jsapiTicketExpiresTime = 0L;
    }

    @Override
    public String getCardApiTicket() {
        return this.cardApiTicket;
    }

    @Override
    public Lock getCardApiTicketLock() {
        return this.cardApiTicketLock;
    }

    @Override
    public boolean isCardApiTicketExpired() {
        return System.currentTimeMillis() > this.cardApiTicketExpiresTime;
    }

    @Override
    public synchronized void updateCardApiTicket(String cardApiTicket, int expiresInSeconds) {
        this.cardApiTicket = cardApiTicket;
        this.cardApiTicketExpiresTime = System.currentTimeMillis() + (long)(expiresInSeconds - 200) * 1000L;
        this.jedis.set(CARDAPI_TICKET_KEY.concat(this.appId), this.accessToken);
        this.jedis.expire(CARDAPI_TICKET_KEY.concat(this.appId), expiresInSeconds - 200);
    }

    @Override
    public void expireCardApiTicket() {
        this.cardApiTicketExpiresTime = 0L;
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    @Override
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public long getExpiresTime() {
        return this.expiresTime;
    }

    public void setExpiresTime(long expiresTime) {
        this.expiresTime = expiresTime;
    }

    @Override
    public String getAesKey() {
        return this.aesKey;
    }

    public void setAesKey(String aesKey) {
        this.aesKey = aesKey;
    }

    @Override
    public String getOauth2redirectUri() {
        return this.oauth2redirectUri;
    }

    public void setOauth2redirectUri(String oauth2redirectUri) {
        this.oauth2redirectUri = oauth2redirectUri;
    }

    @Override
    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    @Override
    public int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public void setHttpProxyPort(int httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    @Override
    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    public void setHttpProxyUsername(String httpProxyUsername) {
        this.httpProxyUsername = httpProxyUsername;
    }

    @Override
    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    public String toString() {
        return ToStringUtils.toSimpleString((Object)this);
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public void setPartnerKey(String partnerKey) {
        this.partnerKey = partnerKey;
    }

    public String getNotifyURL() {
        return this.notifyURL;
    }

    public void setNotifyURL(String notifyURL) {
        this.notifyURL = notifyURL;
    }

    public String getTradeType() {
        return this.tradeType;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    @Override
    public File getTmpDirFile() {
        return this.tmpDirFile;
    }

    public void setTmpDirFile(File tmpDirFile) {
        this.tmpDirFile = tmpDirFile;
    }

    @Override
    public ApacheHttpClientBuilder getApacheHttpClientBuilder() {
        return this.apacheHttpClientBuilder;
    }

    public void setApacheHttpClientBuilder(ApacheHttpClientBuilder apacheHttpClientBuilder) {
        this.apacheHttpClientBuilder = apacheHttpClientBuilder;
    }

    @Override
    public boolean autoRefreshToken() {
        return true;
    }

    public void setJedis(Jedis jedis) {
        this.jedis = jedis;
    }
}

