/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.http.okhttp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.okhttp.OkhttpProxyInfo;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.mp.bean.material.WxMpMaterial;
import me.chanjar.weixin.mp.bean.material.WxMpMaterialUploadResult;
import me.chanjar.weixin.mp.util.http.MaterialUploadRequestExecutor;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;

public class OkhttpMaterialUploadRequestExecutor
extends MaterialUploadRequestExecutor<ConnectionPool, OkhttpProxyInfo> {
    public OkhttpMaterialUploadRequestExecutor(RequestHttp requestHttp) {
        super(requestHttp);
    }

    public WxMpMaterialUploadResult execute(String uri, WxMpMaterial material) throws WxErrorException, IOException {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectionPool((ConnectionPool)this.requestHttp.getRequestHttpClient());
        if (this.requestHttp.getRequestHttpProxy() != null) {
            clientBuilder.proxy(((OkhttpProxyInfo)this.requestHttp.getRequestHttpProxy()).getProxy());
        }
        clientBuilder.authenticator(new Authenticator(){

            public Request authenticate(Route route, Response response) throws IOException {
                String credential = Credentials.basic((String)((OkhttpProxyInfo)OkhttpMaterialUploadRequestExecutor.this.requestHttp.getRequestHttpProxy()).getProxyUsername(), (String)((OkhttpProxyInfo)OkhttpMaterialUploadRequestExecutor.this.requestHttp.getRequestHttpProxy()).getProxyPassword());
                return response.request().newBuilder().header("Authorization", credential).build();
            }
        });
        OkHttpClient client = clientBuilder.build();
        if (material == null) {
            throw new WxErrorException(WxError.newBuilder().setErrorMsg("\u975e\u6cd5\u8bf7\u6c42\uff0cmaterial\u53c2\u6570\u4e3a\u7a7a").build());
        }
        File file = material.getFile();
        if (file == null || !file.exists()) {
            throw new FileNotFoundException();
        }
        RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file);
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().addFormDataPart("media", null, fileBody);
        Map<String, String> form = material.getForm();
        if (material.getForm() != null) {
            bodyBuilder.addFormDataPart("description", WxGsonBuilder.create().toJson(form));
        }
        MultipartBody body = bodyBuilder.build();
        Request request = new Request.Builder().url(uri).post((RequestBody)body).build();
        Response response = client.newCall(request).execute();
        String responseContent = response.body().string();
        WxError error = WxError.fromJson((String)responseContent);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return WxMpMaterialUploadResult.fromJson(responseContent);
    }
}

