/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import me.chanjar.weixin.common.bean.menu.WxMenu;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpMenuService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.menu.WxMpGetSelfMenuInfoResult;
import me.chanjar.weixin.mp.bean.menu.WxMpMenu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMpMenuServiceImpl
implements WxMpMenuService {
    private static final String API_URL_PREFIX = "https://api.weixin.qq.com/cgi-bin/menu";
    private static Logger log = LoggerFactory.getLogger(WxMpMenuServiceImpl.class);
    private WxMpService wxMpService;

    public WxMpMenuServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }

    @Override
    public String menuCreate(WxMenu menu) throws WxErrorException {
        String menuJson = menu.toJson();
        String url = "https://api.weixin.qq.com/cgi-bin/menu/create";
        if (menu.getMatchRule() != null) {
            url = "https://api.weixin.qq.com/cgi-bin/menu/addconditional";
        }
        log.debug("\u5f00\u59cb\u521b\u5efa\u83dc\u5355\uff1a{}", (Object)menuJson);
        String result = this.wxMpService.post(url, menuJson);
        log.debug("\u521b\u5efa\u83dc\u5355\uff1a{},\u7ed3\u679c\uff1a{}", (Object)menuJson, (Object)result);
        if (menu.getMatchRule() != null) {
            return new JsonParser().parse(result).getAsJsonObject().get("menuid").getAsString();
        }
        return null;
    }

    @Override
    public String menuCreate(String json) throws WxErrorException {
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = jsonParser.parse(json).getAsJsonObject();
        String url = "https://api.weixin.qq.com/cgi-bin/menu/create";
        if (jsonObject.get("matchrule") != null) {
            url = "https://api.weixin.qq.com/cgi-bin/menu/addconditional";
        }
        String result = this.wxMpService.post(url, json);
        if (jsonObject.get("matchrule") != null) {
            return jsonParser.parse(result).getAsJsonObject().get("menuid").getAsString();
        }
        return null;
    }

    @Override
    public void menuDelete() throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/delete";
        String result = this.wxMpService.get(url, null);
        log.debug("\u5220\u9664\u83dc\u5355\u7ed3\u679c\uff1a{}", (Object)result);
    }

    @Override
    public void menuDelete(String menuId) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/delconditional";
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("menuid", menuId);
        String result = this.wxMpService.post(url, jsonObject.toString());
        log.debug("\u6839\u636eMeunId({})\u5220\u9664\u4e2a\u6027\u5316\u83dc\u5355\u7ed3\u679c\uff1a{}", (Object)menuId, (Object)result);
    }

    @Override
    public WxMpMenu menuGet() throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/get";
        try {
            String resultContent = this.wxMpService.get(url, null);
            return WxMpMenu.fromJson(resultContent);
        }
        catch (WxErrorException e) {
            if (e.getError().getErrorCode() == 46003) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public WxMenu menuTryMatch(String userid) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/trymatch";
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("user_id", userid);
        try {
            String resultContent = this.wxMpService.post(url, jsonObject.toString());
            return WxMenu.fromJson((String)resultContent);
        }
        catch (WxErrorException e) {
            if (e.getError().getErrorCode() == 46003 || e.getError().getErrorCode() == 46002) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public WxMpGetSelfMenuInfoResult getSelfMenuInfo() throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/get_current_selfmenu_info";
        String resultContent = this.wxMpService.get(url, null);
        return WxMpGetSelfMenuInfoResult.fromJson(resultContent);
    }
}

