/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.http.okhttp;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import me.chanjar.weixin.mp.bean.result.WxMpQrCodeTicket;
import me.chanjar.weixin.mp.util.http.QrCodeRequestExecutor;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class OkhttpQrCodeRequestExecutor
extends QrCodeRequestExecutor<ConnectionPool, OkHttpProxyInfo> {
    public OkhttpQrCodeRequestExecutor(RequestHttp requestHttp) {
        super(requestHttp);
    }

    public File execute(String uri, WxMpQrCodeTicket data) throws WxErrorException, IOException {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectionPool((ConnectionPool)this.requestHttp.getRequestHttpClient());
        if (this.requestHttp.getRequestHttpProxy() != null) {
            clientBuilder.proxy(((OkHttpProxyInfo)this.requestHttp.getRequestHttpProxy()).getProxy());
        }
        clientBuilder.authenticator(new Authenticator(){

            public Request authenticate(Route route, Response response) throws IOException {
                String credential = Credentials.basic((String)((OkHttpProxyInfo)OkhttpQrCodeRequestExecutor.this.requestHttp.getRequestHttpProxy()).getProxyUsername(), (String)((OkHttpProxyInfo)OkhttpQrCodeRequestExecutor.this.requestHttp.getRequestHttpProxy()).getProxyPassword());
                return response.request().newBuilder().header("Authorization", credential).build();
            }
        });
        OkHttpClient client = clientBuilder.build();
        Request request = new Request.Builder().url(uri).get().build();
        Response response = client.newCall(request).execute();
        String contentTypeHeader = response.header("Content-Type");
        if ("text/plain".equals(contentTypeHeader)) {
            String responseContent = response.body().string();
            throw new WxErrorException(WxError.fromJson((String)responseContent));
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(response.body().bytes());){
            File file = FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)"jpg");
            return file;
        }
    }
}

