/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.session.StandardSessionManager;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.common.util.RandomUtils;
import me.chanjar.weixin.common.util.crypto.SHA1;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.common.util.http.URIUtil;
import me.chanjar.weixin.mp.api.WxMpCardService;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;
import me.chanjar.weixin.mp.api.WxMpDataCubeService;
import me.chanjar.weixin.mp.api.WxMpDeviceService;
import me.chanjar.weixin.mp.api.WxMpKefuService;
import me.chanjar.weixin.mp.api.WxMpMaterialService;
import me.chanjar.weixin.mp.api.WxMpMenuService;
import me.chanjar.weixin.mp.api.WxMpQrcodeService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.WxMpShakeService;
import me.chanjar.weixin.mp.api.WxMpStoreService;
import me.chanjar.weixin.mp.api.WxMpTemplateMsgService;
import me.chanjar.weixin.mp.api.WxMpUserBlacklistService;
import me.chanjar.weixin.mp.api.WxMpUserService;
import me.chanjar.weixin.mp.api.WxMpUserTagService;
import me.chanjar.weixin.mp.api.impl.WxMpCardServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpDataCubeServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpDeviceServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpKefuServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpMaterialServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpMenuServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpQrcodeServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpShakeServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpStoreServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpTemplateMsgServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpUserBlacklistServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpUserServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpUserTagServiceImpl;
import me.chanjar.weixin.mp.bean.WxMpMassNews;
import me.chanjar.weixin.mp.bean.WxMpMassOpenIdsMessage;
import me.chanjar.weixin.mp.bean.WxMpMassPreviewMessage;
import me.chanjar.weixin.mp.bean.WxMpMassTagMessage;
import me.chanjar.weixin.mp.bean.WxMpMassVideo;
import me.chanjar.weixin.mp.bean.WxMpSemanticQuery;
import me.chanjar.weixin.mp.bean.result.WxMpMassSendResult;
import me.chanjar.weixin.mp.bean.result.WxMpMassUploadResult;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.bean.result.WxMpSemanticQueryResult;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWxMpServiceImpl<H, P>
implements WxMpService,
RequestHttp<H, P> {
    private static final JsonParser JSON_PARSER = new JsonParser();
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected WxSessionManager sessionManager = new StandardSessionManager();
    private WxMpConfigStorage wxMpConfigStorage;
    private WxMpKefuService kefuService = new WxMpKefuServiceImpl(this);
    private WxMpMaterialService materialService = new WxMpMaterialServiceImpl(this);
    private WxMpMenuService menuService = new WxMpMenuServiceImpl(this);
    private WxMpUserService userService = new WxMpUserServiceImpl(this);
    private WxMpUserTagService tagService = new WxMpUserTagServiceImpl(this);
    private WxMpQrcodeService qrCodeService = new WxMpQrcodeServiceImpl(this);
    private WxMpCardService cardService = new WxMpCardServiceImpl(this);
    private WxMpStoreService storeService = new WxMpStoreServiceImpl(this);
    private WxMpDataCubeService dataCubeService = new WxMpDataCubeServiceImpl(this);
    private WxMpUserBlacklistService blackListService = new WxMpUserBlacklistServiceImpl(this);
    private WxMpTemplateMsgService templateMsgService = new WxMpTemplateMsgServiceImpl(this);
    private WxMpDeviceService deviceService = new WxMpDeviceServiceImpl(this);
    private WxMpShakeService shakeService = new WxMpShakeServiceImpl(this);
    private int retrySleepMillis = 1000;
    private int maxRetryTimes = 5;

    @Override
    public boolean checkSignature(String timestamp, String nonce, String signature) {
        try {
            return SHA1.gen((String[])new String[]{this.getWxMpConfigStorage().getToken(), timestamp, nonce}).equals(signature);
        }
        catch (Exception e) {
            this.log.error("Checking signature failed, and the reason is :" + e.getMessage());
            return false;
        }
    }

    @Override
    public String getJsapiTicket() throws WxErrorException {
        return this.getJsapiTicket(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJsapiTicket(boolean forceRefresh) throws WxErrorException {
        Lock lock = this.getWxMpConfigStorage().getJsapiTicketLock();
        try {
            lock.lock();
            if (forceRefresh) {
                this.getWxMpConfigStorage().expireJsapiTicket();
            }
            if (this.getWxMpConfigStorage().isJsapiTicketExpired()) {
                String responseContent = (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), "https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=jsapi", null);
                JsonElement tmpJsonElement = JSON_PARSER.parse(responseContent);
                JsonObject tmpJsonObject = tmpJsonElement.getAsJsonObject();
                String jsapiTicket = tmpJsonObject.get("ticket").getAsString();
                int expiresInSeconds = tmpJsonObject.get("expires_in").getAsInt();
                this.getWxMpConfigStorage().updateJsapiTicket(jsapiTicket, expiresInSeconds);
            }
        }
        finally {
            lock.unlock();
        }
        return this.getWxMpConfigStorage().getJsapiTicket();
    }

    @Override
    public WxJsapiSignature createJsapiSignature(String url) throws WxErrorException {
        long timestamp = System.currentTimeMillis() / 1000L;
        String noncestr = RandomUtils.getRandomStr();
        String jsapiTicket = this.getJsapiTicket(false);
        String signature = SHA1.genWithAmple((String[])new String[]{"jsapi_ticket=" + jsapiTicket, "noncestr=" + noncestr, "timestamp=" + timestamp, "url=" + url});
        WxJsapiSignature jsapiSignature = new WxJsapiSignature();
        jsapiSignature.setAppId(this.getWxMpConfigStorage().getAppId());
        jsapiSignature.setTimestamp(timestamp);
        jsapiSignature.setNonceStr(noncestr);
        jsapiSignature.setUrl(url);
        jsapiSignature.setSignature(signature);
        return jsapiSignature;
    }

    @Override
    public String getAccessToken() throws WxErrorException {
        return this.getAccessToken(false);
    }

    @Override
    public WxMpMassUploadResult massNewsUpload(WxMpMassNews news) throws WxErrorException {
        String responseContent = this.post("https://api.weixin.qq.com/cgi-bin/media/uploadnews", news.toJson());
        return WxMpMassUploadResult.fromJson(responseContent);
    }

    @Override
    public WxMpMassUploadResult massVideoUpload(WxMpMassVideo video) throws WxErrorException {
        String responseContent = this.post("https://api.weixin.qq.com/cgi-bin/media/uploadvideo", video.toJson());
        return WxMpMassUploadResult.fromJson(responseContent);
    }

    @Override
    public WxMpMassSendResult massGroupMessageSend(WxMpMassTagMessage message) throws WxErrorException {
        String responseContent = this.post("https://api.weixin.qq.com/cgi-bin/message/mass/sendall", message.toJson());
        return WxMpMassSendResult.fromJson(responseContent);
    }

    @Override
    public WxMpMassSendResult massOpenIdsMessageSend(WxMpMassOpenIdsMessage message) throws WxErrorException {
        String responseContent = this.post("https://api.weixin.qq.com/cgi-bin/message/mass/send", message.toJson());
        return WxMpMassSendResult.fromJson(responseContent);
    }

    @Override
    public WxMpMassSendResult massMessagePreview(WxMpMassPreviewMessage wxMpMassPreviewMessage) throws Exception {
        String responseContent = this.post("https://api.weixin.qq.com/cgi-bin/message/mass/preview", wxMpMassPreviewMessage.toJson());
        return WxMpMassSendResult.fromJson(responseContent);
    }

    @Override
    public String shortUrl(String long_url) throws WxErrorException {
        JsonObject o = new JsonObject();
        o.addProperty("action", "long2short");
        o.addProperty("long_url", long_url);
        String responseContent = this.post("https://api.weixin.qq.com/cgi-bin/shorturl", o.toString());
        JsonElement tmpJsonElement = JSON_PARSER.parse(responseContent);
        return tmpJsonElement.getAsJsonObject().get("short_url").getAsString();
    }

    @Override
    public WxMpSemanticQueryResult semanticQuery(WxMpSemanticQuery semanticQuery) throws WxErrorException {
        String responseContent = this.post("https://api.weixin.qq.com/semantic/semproxy/search", semanticQuery.toJson());
        return WxMpSemanticQueryResult.fromJson(responseContent);
    }

    @Override
    public String oauth2buildAuthorizationUrl(String redirectURI, String scope, String state) {
        return String.format("https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=%s#wechat_redirect", this.getWxMpConfigStorage().getAppId(), URIUtil.encodeURIComponent((String)redirectURI), scope, StringUtils.trimToEmpty((String)state));
    }

    @Override
    public String buildQrConnectUrl(String redirectURI, String scope, String state) {
        return String.format("https://open.weixin.qq.com/connect/qrconnect?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=%s#wechat_redirect", this.getWxMpConfigStorage().getAppId(), URIUtil.encodeURIComponent((String)redirectURI), scope, StringUtils.trimToEmpty((String)state));
    }

    private WxMpOAuth2AccessToken getOAuth2AccessToken(String url) throws WxErrorException {
        try {
            RequestExecutor executor = SimpleGetRequestExecutor.create((RequestHttp)this);
            String responseText = (String)executor.execute(url, null);
            return WxMpOAuth2AccessToken.fromJson(responseText);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public WxMpOAuth2AccessToken oauth2getAccessToken(String code) throws WxErrorException {
        String url = String.format("https://api.weixin.qq.com/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code", this.getWxMpConfigStorage().getAppId(), this.getWxMpConfigStorage().getSecret(), code);
        return this.getOAuth2AccessToken(url);
    }

    @Override
    public WxMpOAuth2AccessToken oauth2refreshAccessToken(String refreshToken) throws WxErrorException {
        String url = String.format("https://api.weixin.qq.com/sns/oauth2/refresh_token?appid=%s&grant_type=refresh_token&refresh_token=%s", this.getWxMpConfigStorage().getAppId(), refreshToken);
        return this.getOAuth2AccessToken(url);
    }

    @Override
    public WxMpUser oauth2getUserInfo(WxMpOAuth2AccessToken oAuth2AccessToken, String lang) throws WxErrorException {
        if (lang == null) {
            lang = "zh_CN";
        }
        String url = String.format("https://api.weixin.qq.com/sns/userinfo?access_token=%s&openid=%s&lang=%s", oAuth2AccessToken.getAccessToken(), oAuth2AccessToken.getOpenId(), lang);
        try {
            RequestExecutor executor = SimpleGetRequestExecutor.create((RequestHttp)this);
            String responseText = (String)executor.execute(url, null);
            return WxMpUser.fromJson(responseText);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean oauth2validateAccessToken(WxMpOAuth2AccessToken oAuth2AccessToken) {
        String url = String.format("https://api.weixin.qq.com/sns/auth?access_token=%s&openid=%s", oAuth2AccessToken.getAccessToken(), oAuth2AccessToken.getOpenId());
        try {
            SimpleGetRequestExecutor.create((RequestHttp)this).execute(url, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (WxErrorException e) {
            return false;
        }
        return true;
    }

    @Override
    public String[] getCallbackIP() throws WxErrorException {
        String responseContent = this.get("https://api.weixin.qq.com/cgi-bin/getcallbackip", null);
        JsonElement tmpJsonElement = JSON_PARSER.parse(responseContent);
        JsonArray ipList = tmpJsonElement.getAsJsonObject().get("ip_list").getAsJsonArray();
        String[] ipArray = new String[ipList.size()];
        for (int i = 0; i < ipList.size(); ++i) {
            ipArray[i] = ipList.get(i).getAsString();
        }
        return ipArray;
    }

    @Override
    public String get(String url, String queryParam) throws WxErrorException {
        return (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), url, queryParam);
    }

    @Override
    public String post(String url, String postData) throws WxErrorException {
        return (String)this.execute(SimplePostRequestExecutor.create((RequestHttp)this), url, postData);
    }

    @Override
    public <T, E> T execute(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        int retryTimes = 0;
        while (true) {
            try {
                return this.executeInternal(executor, uri, data);
            }
            catch (WxErrorException e) {
                if (retryTimes + 1 > this.maxRetryTimes) {
                    this.log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                    throw new RuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
                }
                WxError error = e.getError();
                if (error.getErrorCode() == -1) {
                    int sleepMillis = this.retrySleepMillis * (1 << retryTimes);
                    try {
                        this.log.warn("\u5fae\u4fe1\u7cfb\u7edf\u7e41\u5fd9\uff0c{} ms \u540e\u91cd\u8bd5(\u7b2c{}\u6b21)", (Object)sleepMillis, (Object)(retryTimes + 1));
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException e1) {
                        throw new RuntimeException(e1);
                    }
                } else {
                    throw e;
                }
                if (retryTimes++ < this.maxRetryTimes) continue;
                this.log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                throw new RuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
            }
            break;
        }
    }

    public synchronized <T, E> T executeInternal(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        if (uri.contains("access_token=")) {
            throw new IllegalArgumentException("uri\u53c2\u6570\u4e2d\u4e0d\u5141\u8bb8\u6709access_token: " + uri);
        }
        String accessToken = this.getAccessToken(false);
        String uriWithAccessToken = uri + (uri.contains("?") ? "&" : "?") + "access_token=" + accessToken;
        try {
            Object result = executor.execute(uriWithAccessToken, data);
            this.log.debug("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{uriWithAccessToken, data, result});
            return (T)result;
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (error.getErrorCode() == 42001 || error.getErrorCode() == 40001 || error.getErrorCode() == 40014) {
                this.getWxMpConfigStorage().expireAccessToken();
                if (this.getWxMpConfigStorage().autoRefreshToken()) {
                    return this.execute(executor, uri, data);
                }
            }
            if (error.getErrorCode() != 0) {
                this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u9519\u8bef\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, data, error});
                throw new WxErrorException(error);
            }
            return null;
        }
        catch (IOException e) {
            this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, data, e.getMessage()});
            throw new RuntimeException(e);
        }
    }

    @Override
    public WxMpConfigStorage getWxMpConfigStorage() {
        return this.wxMpConfigStorage;
    }

    @Override
    public void setWxMpConfigStorage(WxMpConfigStorage wxConfigProvider) {
        this.wxMpConfigStorage = wxConfigProvider;
        this.initHttp();
    }

    @Override
    public void setRetrySleepMillis(int retrySleepMillis) {
        this.retrySleepMillis = retrySleepMillis;
    }

    @Override
    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    @Override
    public WxMpKefuService getKefuService() {
        return this.kefuService;
    }

    @Override
    public WxMpMaterialService getMaterialService() {
        return this.materialService;
    }

    @Override
    public WxMpMenuService getMenuService() {
        return this.menuService;
    }

    @Override
    public WxMpUserService getUserService() {
        return this.userService;
    }

    @Override
    public WxMpUserTagService getUserTagService() {
        return this.tagService;
    }

    @Override
    public WxMpQrcodeService getQrcodeService() {
        return this.qrCodeService;
    }

    @Override
    public WxMpCardService getCardService() {
        return this.cardService;
    }

    @Override
    public WxMpDataCubeService getDataCubeService() {
        return this.dataCubeService;
    }

    @Override
    public WxMpUserBlacklistService getBlackListService() {
        return this.blackListService;
    }

    @Override
    public WxMpStoreService getStoreService() {
        return this.storeService;
    }

    @Override
    public WxMpTemplateMsgService getTemplateMsgService() {
        return this.templateMsgService;
    }

    @Override
    public WxMpDeviceService getDeviceService() {
        return this.deviceService;
    }

    @Override
    public WxMpShakeService getShakeService() {
        return this.shakeService;
    }

    @Override
    public RequestHttp getRequestHttp() {
        return this;
    }
}

