/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.http.okhttp;

import java.io.File;
import java.io.IOException;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import me.chanjar.weixin.mp.bean.material.WxMediaImgUploadResult;
import me.chanjar.weixin.mp.util.http.MediaImgUploadRequestExecutor;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;

public class OkhttpMediaImgUploadRequestExecutor
extends MediaImgUploadRequestExecutor<ConnectionPool, OkHttpProxyInfo> {
    public OkhttpMediaImgUploadRequestExecutor(RequestHttp requestHttp) {
        super(requestHttp);
    }

    public WxMediaImgUploadResult execute(String uri, File data) throws WxErrorException, IOException {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectionPool((ConnectionPool)this.requestHttp.getRequestHttpClient());
        if (this.requestHttp.getRequestHttpProxy() != null) {
            clientBuilder.proxy(((OkHttpProxyInfo)this.requestHttp.getRequestHttpProxy()).getProxy());
        }
        clientBuilder.authenticator(new Authenticator(){

            public Request authenticate(Route route, Response response) throws IOException {
                String credential = Credentials.basic((String)((OkHttpProxyInfo)OkhttpMediaImgUploadRequestExecutor.this.requestHttp.getRequestHttpProxy()).getProxyUsername(), (String)((OkHttpProxyInfo)OkhttpMediaImgUploadRequestExecutor.this.requestHttp.getRequestHttpProxy()).getProxyPassword());
                return response.request().newBuilder().header("Authorization", credential).build();
            }
        });
        OkHttpClient client = clientBuilder.build();
        RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)data);
        MultipartBody body = new MultipartBody.Builder().addFormDataPart("media", null, fileBody).build();
        Request request = new Request.Builder().url(uri).post((RequestBody)body).build();
        Response response = client.newCall(request).execute();
        String responseContent = response.body().string();
        WxError error = WxError.fromJson((String)responseContent);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return WxMediaImgUploadResult.fromJson(responseContent);
    }
}

