/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.http.okhttp;

import java.io.File;
import java.io.IOException;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import me.chanjar.weixin.mp.bean.material.WxMediaImgUploadResult;
import me.chanjar.weixin.mp.util.http.MediaImgUploadRequestExecutor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkhttpMediaImgUploadRequestExecutor
extends MediaImgUploadRequestExecutor<OkHttpClient, OkHttpProxyInfo> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public OkhttpMediaImgUploadRequestExecutor(RequestHttp requestHttp) {
        super(requestHttp);
    }

    public WxMediaImgUploadResult execute(String uri, File file) throws WxErrorException, IOException {
        this.logger.debug("OkhttpMediaImgUploadRequestExecutor is running");
        OkHttpClient client = (OkHttpClient)this.requestHttp.getRequestHttpClient();
        MultipartBody body = new MultipartBody.Builder().setType(MediaType.parse((String)"multipart/form-data")).addFormDataPart("media", file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file)).build();
        Request request = new Request.Builder().url(uri).post((RequestBody)body).build();
        Response response = client.newCall(request).execute();
        String responseContent = response.body().string();
        WxError error = WxError.fromJson((String)responseContent);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return WxMediaImgUploadResult.fromJson(responseContent);
    }
}

