/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.http.jodd;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.ProxyInfo;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.mp.bean.material.WxMpMaterialNews;
import me.chanjar.weixin.mp.util.http.MaterialNewsInfoRequestExecutor;
import me.chanjar.weixin.mp.util.json.WxMpGsonBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoddMaterialNewsInfoRequestExecutor
extends MaterialNewsInfoRequestExecutor<HttpConnectionProvider, ProxyInfo> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public JoddMaterialNewsInfoRequestExecutor(RequestHttp requestHttp) {
        super(requestHttp);
    }

    public WxMpMaterialNews execute(String uri, String materialId) throws WxErrorException, IOException {
        if (this.requestHttp.getRequestHttpProxy() != null) {
            ((HttpConnectionProvider)this.requestHttp.getRequestHttpClient()).useProxy((ProxyInfo)this.requestHttp.getRequestHttpProxy());
        }
        HttpRequest request = (HttpRequest)HttpRequest.post((String)uri).withConnectionProvider((HttpConnectionProvider)this.requestHttp.getRequestHttpClient()).body(WxGsonBuilder.create().toJson((Object)ImmutableMap.of((Object)"media_id", (Object)materialId)));
        HttpResponse response = request.send();
        response.charset("UTF-8");
        String responseContent = response.bodyText();
        this.logger.debug("\u54cd\u5e94\u539f\u59cb\u6570\u636e\uff1a{}", (Object)responseContent);
        WxError error = WxError.fromJson((String)responseContent);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return (WxMpMaterialNews)WxMpGsonBuilder.create().fromJson(responseContent, WxMpMaterialNews.class);
    }
}

