/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.http.okhttp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.mp.bean.material.WxMpMaterial;
import me.chanjar.weixin.mp.bean.material.WxMpMaterialUploadResult;
import me.chanjar.weixin.mp.util.http.MaterialUploadRequestExecutor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkhttpMaterialUploadRequestExecutor
extends MaterialUploadRequestExecutor<OkHttpClient, OkHttpProxyInfo> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public OkhttpMaterialUploadRequestExecutor(RequestHttp requestHttp) {
        super(requestHttp);
    }

    public WxMpMaterialUploadResult execute(String uri, WxMpMaterial material) throws WxErrorException, IOException {
        Request request;
        Response response;
        String responseContent;
        WxError error;
        this.logger.debug("OkhttpMaterialUploadRequestExecutor is running");
        if (material == null) {
            throw new WxErrorException(WxError.builder().errorCode(-1).errorMsg("\u975e\u6cd5\u8bf7\u6c42\uff0cmaterial\u53c2\u6570\u4e3a\u7a7a").build());
        }
        File file = material.getFile();
        if (file == null || !file.exists()) {
            throw new FileNotFoundException();
        }
        OkHttpClient client = (OkHttpClient)this.requestHttp.getRequestHttpClient();
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MediaType.parse((String)"multipart/form-data")).addFormDataPart("media", file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file));
        Map<String, String> form = material.getForm();
        if (form != null) {
            bodyBuilder.addFormDataPart("description", WxGsonBuilder.create().toJson(form));
        }
        if ((error = WxError.fromJson((String)(responseContent = (response = client.newCall(request = new Request.Builder().url(uri).post((RequestBody)bodyBuilder.build()).build()).execute()).body().string()))).getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return WxMpMaterialUploadResult.fromJson(responseContent);
    }
}

