/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.http.okhttp;

import java.io.IOException;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import me.chanjar.weixin.mp.util.http.MaterialDeleteRequestExecutor;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkhttpMaterialDeleteRequestExecutor
extends MaterialDeleteRequestExecutor<OkHttpClient, OkHttpProxyInfo> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public OkhttpMaterialDeleteRequestExecutor(RequestHttp requestHttp) {
        super(requestHttp);
    }

    public Boolean execute(String uri, String materialId) throws WxErrorException, IOException {
        this.logger.debug("OkhttpMaterialDeleteRequestExecutor is running");
        OkHttpClient client = (OkHttpClient)this.requestHttp.getRequestHttpClient();
        FormBody requestBody = new FormBody.Builder().add("media_id", materialId).build();
        Request request = new Request.Builder().url(uri).post((RequestBody)requestBody).build();
        Response response = client.newCall(request).execute();
        String responseContent = response.body().string();
        WxError error = WxError.fromJson((String)responseContent);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return true;
    }
}

