/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.HttpType;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import me.chanjar.weixin.mp.api.impl.BaseWxMpServiceImpl;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class WxMpServiceOkHttpImpl
extends BaseWxMpServiceImpl<OkHttpClient, OkHttpProxyInfo> {
    private OkHttpClient httpClient;
    private OkHttpProxyInfo httpProxy;

    public OkHttpClient getRequestHttpClient() {
        return this.httpClient;
    }

    public OkHttpProxyInfo getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpType getRequestType() {
        return HttpType.OK_HTTP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        this.log.debug("WxMpServiceOkHttpImpl is running");
        Lock lock = this.getWxMpConfigStorage().getAccessTokenLock();
        try {
            lock.lock();
            if (this.getWxMpConfigStorage().isAccessTokenExpired() || forceRefresh) {
                String url = String.format("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s", this.getWxMpConfigStorage().getAppId(), this.getWxMpConfigStorage().getSecret());
                Request request = new Request.Builder().url(url).get().build();
                Response response = this.getRequestHttpClient().newCall(request).execute();
                String resultContent = response.body().string();
                WxError error = WxError.fromJson((String)resultContent, (WxType)WxType.MP);
                if (error.getErrorCode() != 0) {
                    throw new WxErrorException(error);
                }
                WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
                this.getWxMpConfigStorage().updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
            }
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return this.getWxMpConfigStorage().getAccessToken();
    }

    @Override
    public void initHttp() {
        this.log.debug("WxMpServiceOkHttpImpl initHttp");
        if (this.wxMpConfigStorage.getHttpProxyHost() != null && this.wxMpConfigStorage.getHttpProxyPort() > 0) {
            this.httpProxy = OkHttpProxyInfo.httpProxy((String)this.wxMpConfigStorage.getHttpProxyHost(), (int)this.wxMpConfigStorage.getHttpProxyPort(), (String)this.wxMpConfigStorage.getHttpProxyUsername(), (String)this.wxMpConfigStorage.getHttpProxyPassword());
        }
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (this.httpProxy != null) {
            clientBuilder.proxy(this.getRequestHttpProxy().getProxy());
            clientBuilder.authenticator(new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = Credentials.basic((String)WxMpServiceOkHttpImpl.this.httpProxy.getProxyUsername(), (String)WxMpServiceOkHttpImpl.this.httpProxy.getProxyPassword());
                    return response.request().newBuilder().header("Authorization", credential).build();
                }
            });
        }
        this.httpClient = clientBuilder.build();
    }
}

