/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import me.chanjar.weixin.mp.bean.kefu.WxMpKefuMessage;
import org.apache.commons.lang3.StringUtils;

public class WxMpKefuMessageGsonAdapter
implements JsonSerializer<WxMpKefuMessage> {
    public JsonElement serialize(WxMpKefuMessage message, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject messageJson = new JsonObject();
        messageJson.addProperty("touser", message.getToUser());
        messageJson.addProperty("msgtype", message.getMsgType());
        switch (message.getMsgType()) {
            case "text": {
                JsonObject text = new JsonObject();
                text.addProperty("content", message.getContent());
                messageJson.add("text", (JsonElement)text);
                break;
            }
            case "image": {
                JsonObject image = new JsonObject();
                image.addProperty("media_id", message.getMediaId());
                messageJson.add("image", (JsonElement)image);
                break;
            }
            case "voice": {
                JsonObject voice = new JsonObject();
                voice.addProperty("media_id", message.getMediaId());
                messageJson.add("voice", (JsonElement)voice);
                break;
            }
            case "video": {
                JsonObject video = new JsonObject();
                video.addProperty("media_id", message.getMediaId());
                video.addProperty("thumb_media_id", message.getThumbMediaId());
                video.addProperty("title", message.getTitle());
                video.addProperty("description", message.getDescription());
                messageJson.add("video", (JsonElement)video);
                break;
            }
            case "music": {
                JsonObject music = new JsonObject();
                music.addProperty("title", message.getTitle());
                music.addProperty("description", message.getDescription());
                music.addProperty("thumb_media_id", message.getThumbMediaId());
                music.addProperty("musicurl", message.getMusicUrl());
                music.addProperty("hqmusicurl", message.getHqMusicUrl());
                messageJson.add("music", (JsonElement)music);
                break;
            }
            case "news": {
                JsonObject newsJsonObject = new JsonObject();
                JsonArray articleJsonArray = new JsonArray();
                for (WxMpKefuMessage.WxArticle article : message.getArticles()) {
                    JsonObject articleJson = new JsonObject();
                    articleJson.addProperty("title", article.getTitle());
                    articleJson.addProperty("description", article.getDescription());
                    articleJson.addProperty("url", article.getUrl());
                    articleJson.addProperty("picurl", article.getPicUrl());
                    articleJsonArray.add((JsonElement)articleJson);
                }
                newsJsonObject.add("articles", (JsonElement)articleJsonArray);
                messageJson.add("news", (JsonElement)newsJsonObject);
                break;
            }
            case "mpnews": {
                JsonObject json = new JsonObject();
                json.addProperty("media_id", message.getMpNewsMediaId());
                messageJson.add("mpnews", (JsonElement)json);
                break;
            }
            case "wxcard": {
                JsonObject wxcard = new JsonObject();
                wxcard.addProperty("card_id", message.getCardId());
                messageJson.add("wxcard", (JsonElement)wxcard);
                break;
            }
            case "miniprogrampage": {
                JsonObject miniProgramPage = new JsonObject();
                miniProgramPage.addProperty("title", message.getTitle());
                miniProgramPage.addProperty("appid", message.getMiniProgramAppId());
                miniProgramPage.addProperty("pagepath", message.getMiniProgramPagePath());
                miniProgramPage.addProperty("thumb_media_id", message.getThumbMediaId());
                messageJson.add("miniprogrampage", (JsonElement)miniProgramPage);
                break;
            }
            case "msgmenu": {
                JsonObject msgMenu = new JsonObject();
                JsonArray array = new JsonArray();
                for (String s : message.getMsgMenuList()) {
                    JsonObject innerJson = new JsonObject();
                    String[] split = s.split(",");
                    innerJson.addProperty("id", split[0]);
                    innerJson.addProperty("content", split[1]);
                    array.add((JsonElement)innerJson);
                }
                msgMenu.addProperty("head_content", message.getHeadContent());
                msgMenu.add("list", (JsonElement)array);
                msgMenu.addProperty("tail_content", message.getTailContent());
                messageJson.add("msgmenu", (JsonElement)msgMenu);
                break;
            }
            default: {
                throw new RuntimeException("\u975e\u6cd5\u6d88\u606f\u7c7b\u578b\uff0c\u6682\u4e0d\u652f\u6301");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)message.getKfAccount())) {
            JsonObject newsJsonObject = new JsonObject();
            newsJsonObject.addProperty("kf_account", message.getKfAccount());
            messageJson.add("customservice", (JsonElement)newsJsonObject);
        }
        return messageJson;
    }
}

