/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.URIUtil;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.WxMpSubscribeMsgService;
import me.chanjar.weixin.mp.bean.subscribe.WxMpSubscribeMessage;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;

public class WxMpSubscribeMsgServiceImpl
implements WxMpSubscribeMsgService {
    private final WxMpService wxMpService;

    @Override
    public String subscribeMsgAuthorizationUrl(String redirectURI, int scene, String reserved) {
        WxMpConfigStorage storage = this.wxMpService.getWxMpConfigStorage();
        return String.format(WxMpApiUrl.SubscribeMsg.SUBSCRIBE_MESSAGE_AUTHORIZE_URL.getUrl(storage), storage.getAppId(), scene, storage.getTemplateId(), URIUtil.encodeURIComponent((String)redirectURI), reserved);
    }

    @Override
    public boolean sendSubscribeMessage(WxMpSubscribeMessage message) throws WxErrorException {
        String responseContent;
        if (message.getTemplateId() == null) {
            message.setTemplateId(this.wxMpService.getWxMpConfigStorage().getTemplateId());
        }
        return (responseContent = this.wxMpService.post(WxMpApiUrl.SubscribeMsg.SEND_MESSAGE_URL, message.toJson())) != null;
    }

    public WxMpSubscribeMsgServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }
}

