/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.config.impl;

import me.chanjar.weixin.common.util.locks.JedisDistributedLock;
import me.chanjar.weixin.mp.config.impl.WxMpDefaultConfigImpl;
import me.chanjar.weixin.mp.enums.TicketType;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.util.Pool;

public class WxMpRedisConfigImpl
extends WxMpDefaultConfigImpl {
    private static final String ACCESS_TOKEN_KEY = "wx:access_token:";
    private static final String LOCK_KEY = "wx:lock:";
    private final JedisPool jedisPool;
    private String accessTokenKey;
    private String lockKey;

    public WxMpRedisConfigImpl(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    public void setAppId(String appId) {
        super.setAppId(appId);
        this.accessTokenKey = ACCESS_TOKEN_KEY.concat(appId);
        this.lockKey = ACCESS_TOKEN_KEY.concat(appId).concat(":");
        this.accessTokenLock = new JedisDistributedLock((Pool)this.jedisPool, this.lockKey.concat("accessTokenLock"));
        this.jsapiTicketLock = new JedisDistributedLock((Pool)this.jedisPool, this.lockKey.concat("jsapiTicketLock"));
        this.sdkTicketLock = new JedisDistributedLock((Pool)this.jedisPool, this.lockKey.concat("sdkTicketLock"));
        this.cardApiTicketLock = new JedisDistributedLock((Pool)this.jedisPool, this.lockKey.concat("cardApiTicketLock"));
    }

    private String getTicketRedisKey(TicketType type) {
        return String.format("wx:ticket:key:%s:%s", this.appId, type.getCode());
    }

    @Override
    public String getAccessToken() {
        try (Jedis jedis = this.jedisPool.getResource();){
            String string = jedis.get(this.accessTokenKey);
            return string;
        }
    }

    @Override
    public boolean isAccessTokenExpired() {
        try (Jedis jedis = this.jedisPool.getResource();){
            boolean bl = jedis.ttl(this.accessTokenKey) < 2L;
            return bl;
        }
    }

    @Override
    public synchronized void updateAccessToken(String accessToken, int expiresInSeconds) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.setex(this.accessTokenKey, expiresInSeconds - 200, accessToken);
        }
    }

    @Override
    public void expireAccessToken() {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.expire(this.accessTokenKey, 0);
        }
    }

    @Override
    public String getTicket(TicketType type) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String string = jedis.get(this.getTicketRedisKey(type));
            return string;
        }
    }

    @Override
    public boolean isTicketExpired(TicketType type) {
        try (Jedis jedis = this.jedisPool.getResource();){
            boolean bl = jedis.ttl(this.getTicketRedisKey(type)) < 2L;
            return bl;
        }
    }

    @Override
    public synchronized void updateTicket(TicketType type, String jsapiTicket, int expiresInSeconds) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.setex(this.getTicketRedisKey(type), expiresInSeconds - 200, jsapiTicket);
        }
    }

    @Override
    public void expireTicket(TicketType type) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.expire(this.getTicketRedisKey(type), 0);
        }
    }
}

