/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.config.impl;

import java.util.concurrent.TimeUnit;
import me.chanjar.weixin.common.redis.JedisWxRedisOps;
import me.chanjar.weixin.common.redis.WxRedisOps;
import me.chanjar.weixin.mp.config.impl.WxMpDefaultConfigImpl;
import me.chanjar.weixin.mp.enums.TicketType;
import redis.clients.jedis.JedisPool;

public class WxMpRedisConfigImpl
extends WxMpDefaultConfigImpl {
    private static final long serialVersionUID = -988502871997239733L;
    private static final String ACCESS_TOKEN_KEY_TPL = "%s:access_token:%s";
    private static final String TICKET_KEY_TPL = "%s:ticket:key:%s:%s";
    private static final String LOCK_KEY_TPL = "%s:lock:%s:";
    private final WxRedisOps redisOps;
    private final String keyPrefix;
    private String accessTokenKey;
    private String lockKey;

    public WxMpRedisConfigImpl(JedisPool jedisPool) {
        this((WxRedisOps)new JedisWxRedisOps(jedisPool), "wx");
    }

    public WxMpRedisConfigImpl(WxRedisOps redisOps, String keyPrefix) {
        this.redisOps = redisOps;
        this.keyPrefix = keyPrefix;
    }

    @Override
    public void setAppId(String appId) {
        super.setAppId(appId);
        this.accessTokenKey = String.format(ACCESS_TOKEN_KEY_TPL, this.keyPrefix, appId);
        this.lockKey = String.format(LOCK_KEY_TPL, this.keyPrefix, appId);
        this.accessTokenLock = this.redisOps.getLock(this.lockKey.concat("accessTokenLock"));
        this.jsapiTicketLock = this.redisOps.getLock(this.lockKey.concat("jsapiTicketLock"));
        this.sdkTicketLock = this.redisOps.getLock(this.lockKey.concat("sdkTicketLock"));
        this.cardApiTicketLock = this.redisOps.getLock(this.lockKey.concat("cardApiTicketLock"));
    }

    private String getTicketRedisKey(TicketType type) {
        return String.format(TICKET_KEY_TPL, this.keyPrefix, this.appId, type.getCode());
    }

    @Override
    public String getAccessToken() {
        return this.redisOps.getValue(this.accessTokenKey);
    }

    @Override
    public boolean isAccessTokenExpired() {
        Long expire = this.redisOps.getExpire(this.accessTokenKey);
        return expire == null || expire < 2L;
    }

    @Override
    public synchronized void updateAccessToken(String accessToken, int expiresInSeconds) {
        this.redisOps.setValue(this.accessTokenKey, accessToken, expiresInSeconds - 200, TimeUnit.SECONDS);
    }

    @Override
    public void expireAccessToken() {
        this.redisOps.expire(this.accessTokenKey, 0, TimeUnit.SECONDS);
    }

    @Override
    public String getTicket(TicketType type) {
        return this.redisOps.getValue(this.getTicketRedisKey(type));
    }

    @Override
    public boolean isTicketExpired(TicketType type) {
        return this.redisOps.getExpire(this.getTicketRedisKey(type)) < 2L;
    }

    @Override
    public synchronized void updateTicket(TicketType type, String jsapiTicket, int expiresInSeconds) {
        this.redisOps.setValue(this.getTicketRedisKey(type), jsapiTicket, expiresInSeconds - 200, TimeUnit.SECONDS);
    }

    @Override
    public void expireTicket(TicketType type) {
        this.redisOps.expire(this.getTicketRedisKey(type), 0, TimeUnit.SECONDS);
    }

    public WxRedisOps getRedisOps() {
        return this.redisOps;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public String getAccessTokenKey() {
        return this.accessTokenKey;
    }

    public String getLockKey() {
        return this.lockKey;
    }

    public void setAccessTokenKey(String accessTokenKey) {
        this.accessTokenKey = accessTokenKey;
    }

    public void setLockKey(String lockKey) {
        this.lockKey = lockKey;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxMpRedisConfigImpl)) {
            return false;
        }
        WxMpRedisConfigImpl other = (WxMpRedisConfigImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WxRedisOps this$redisOps = this.getRedisOps();
        WxRedisOps other$redisOps = other.getRedisOps();
        if (this$redisOps == null ? other$redisOps != null : !this$redisOps.equals(other$redisOps)) {
            return false;
        }
        String this$keyPrefix = this.getKeyPrefix();
        String other$keyPrefix = other.getKeyPrefix();
        if (this$keyPrefix == null ? other$keyPrefix != null : !this$keyPrefix.equals(other$keyPrefix)) {
            return false;
        }
        String this$accessTokenKey = this.getAccessTokenKey();
        String other$accessTokenKey = other.getAccessTokenKey();
        if (this$accessTokenKey == null ? other$accessTokenKey != null : !this$accessTokenKey.equals(other$accessTokenKey)) {
            return false;
        }
        String this$lockKey = this.getLockKey();
        String other$lockKey = other.getLockKey();
        return !(this$lockKey == null ? other$lockKey != null : !this$lockKey.equals(other$lockKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WxMpRedisConfigImpl;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WxRedisOps $redisOps = this.getRedisOps();
        result = result * 59 + ($redisOps == null ? 43 : $redisOps.hashCode());
        String $keyPrefix = this.getKeyPrefix();
        result = result * 59 + ($keyPrefix == null ? 43 : $keyPrefix.hashCode());
        String $accessTokenKey = this.getAccessTokenKey();
        result = result * 59 + ($accessTokenKey == null ? 43 : $accessTokenKey.hashCode());
        String $lockKey = this.getLockKey();
        result = result * 59 + ($lockKey == null ? 43 : $lockKey.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "WxMpRedisConfigImpl(redisOps=" + this.getRedisOps() + ", keyPrefix=" + this.getKeyPrefix() + ", accessTokenKey=" + this.getAccessTokenKey() + ", lockKey=" + this.getLockKey() + ")";
    }
}

