/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.bean.WxNetCheckResult;
import me.chanjar.weixin.common.enums.TicketType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.StandardSessionManager;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.common.util.DataUtils;
import me.chanjar.weixin.common.util.RandomUtils;
import me.chanjar.weixin.common.util.crypto.SHA1;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.common.util.http.URIUtil;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.mp.api.WxMpAiOpenService;
import me.chanjar.weixin.mp.api.WxMpCardService;
import me.chanjar.weixin.mp.api.WxMpCommentService;
import me.chanjar.weixin.mp.api.WxMpDataCubeService;
import me.chanjar.weixin.mp.api.WxMpDeviceService;
import me.chanjar.weixin.mp.api.WxMpImgProcService;
import me.chanjar.weixin.mp.api.WxMpKefuService;
import me.chanjar.weixin.mp.api.WxMpMarketingService;
import me.chanjar.weixin.mp.api.WxMpMassMessageService;
import me.chanjar.weixin.mp.api.WxMpMaterialService;
import me.chanjar.weixin.mp.api.WxMpMemberCardService;
import me.chanjar.weixin.mp.api.WxMpMenuService;
import me.chanjar.weixin.mp.api.WxMpMerchantInvoiceService;
import me.chanjar.weixin.mp.api.WxMpOcrService;
import me.chanjar.weixin.mp.api.WxMpQrcodeService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.WxMpShakeService;
import me.chanjar.weixin.mp.api.WxMpStoreService;
import me.chanjar.weixin.mp.api.WxMpSubscribeMsgService;
import me.chanjar.weixin.mp.api.WxMpTemplateMsgService;
import me.chanjar.weixin.mp.api.WxMpUserBlacklistService;
import me.chanjar.weixin.mp.api.WxMpUserService;
import me.chanjar.weixin.mp.api.WxMpUserTagService;
import me.chanjar.weixin.mp.api.WxMpWifiService;
import me.chanjar.weixin.mp.api.impl.WxMpAiOpenServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpCardServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpCommentServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpDataCubeServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpDeviceServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpImgProcServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpKefuServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpMarketingServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpMassMessageServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpMaterialServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpMemberCardServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpMenuServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpMerchantInvoiceServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpOcrServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpQrcodeServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpShakeServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpStoreServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpSubscribeMsgServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpTemplateMsgServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpUserBlacklistServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpUserServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpUserTagServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpWifiServiceImpl;
import me.chanjar.weixin.mp.bean.WxMpSemanticQuery;
import me.chanjar.weixin.mp.bean.result.WxMpCurrentAutoReplyInfo;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.bean.result.WxMpSemanticQueryResult;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;
import me.chanjar.weixin.mp.util.WxMpConfigStorageHolder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWxMpServiceImpl<H, P>
implements WxMpService,
RequestHttp<H, P> {
    private static final Logger log = LoggerFactory.getLogger(BaseWxMpServiceImpl.class);
    private static final JsonParser JSON_PARSER = new JsonParser();
    protected WxSessionManager sessionManager = new StandardSessionManager();
    private WxMpKefuService kefuService = new WxMpKefuServiceImpl(this);
    private WxMpMaterialService materialService = new WxMpMaterialServiceImpl(this);
    private WxMpMenuService menuService = new WxMpMenuServiceImpl(this);
    private WxMpUserService userService = new WxMpUserServiceImpl(this);
    private WxMpUserTagService tagService = new WxMpUserTagServiceImpl(this);
    private WxMpQrcodeService qrCodeService = new WxMpQrcodeServiceImpl(this);
    private WxMpCardService cardService = new WxMpCardServiceImpl(this);
    private WxMpStoreService storeService = new WxMpStoreServiceImpl(this);
    private WxMpDataCubeService dataCubeService = new WxMpDataCubeServiceImpl(this);
    private WxMpUserBlacklistService blackListService = new WxMpUserBlacklistServiceImpl(this);
    private WxMpTemplateMsgService templateMsgService = new WxMpTemplateMsgServiceImpl(this);
    private final WxMpSubscribeMsgService subscribeMsgService = new WxMpSubscribeMsgServiceImpl(this);
    private WxMpDeviceService deviceService = new WxMpDeviceServiceImpl(this);
    private WxMpShakeService shakeService = new WxMpShakeServiceImpl(this);
    private WxMpMemberCardService memberCardService = new WxMpMemberCardServiceImpl(this);
    private WxMpMassMessageService massMessageService = new WxMpMassMessageServiceImpl(this);
    private WxMpAiOpenService aiOpenService = new WxMpAiOpenServiceImpl(this);
    private final WxMpWifiService wifiService = new WxMpWifiServiceImpl(this);
    private WxMpMarketingService marketingService = new WxMpMarketingServiceImpl(this);
    private WxMpCommentService commentService = new WxMpCommentServiceImpl(this);
    private WxMpOcrService ocrService = new WxMpOcrServiceImpl(this);
    private WxMpImgProcService imgProcService = new WxMpImgProcServiceImpl(this);
    private WxMpMerchantInvoiceService merchantInvoiceService = new WxMpMerchantInvoiceServiceImpl(this, this.cardService);
    private Map<String, WxMpConfigStorage> configStorageMap;
    private int retrySleepMillis = 1000;
    private int maxRetryTimes = 5;

    @Override
    public boolean checkSignature(String timestamp, String nonce, String signature) {
        try {
            return SHA1.gen((String[])new String[]{this.getWxMpConfigStorage().getToken(), timestamp, nonce}).equals(signature);
        }
        catch (Exception e) {
            log.error("Checking signature failed, and the reason is :" + e.getMessage());
            return false;
        }
    }

    @Override
    public String getTicket(TicketType type) throws WxErrorException {
        return this.getTicket(type, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTicket(TicketType type, boolean forceRefresh) throws WxErrorException {
        Lock lock = this.getWxMpConfigStorage().getTicketLock(type);
        try {
            lock.lock();
            if (forceRefresh) {
                this.getWxMpConfigStorage().expireTicket(type);
            }
            if (this.getWxMpConfigStorage().isTicketExpired(type)) {
                String responseContent = (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), WxMpApiUrl.Other.GET_TICKET_URL.getUrl(this.getWxMpConfigStorage()) + type.getCode(), null);
                JsonObject tmpJsonObject = JSON_PARSER.parse(responseContent).getAsJsonObject();
                String jsapiTicket = tmpJsonObject.get("ticket").getAsString();
                int expiresInSeconds = tmpJsonObject.get("expires_in").getAsInt();
                this.getWxMpConfigStorage().updateTicket(type, jsapiTicket, expiresInSeconds);
            }
        }
        finally {
            lock.unlock();
        }
        return this.getWxMpConfigStorage().getTicket(type);
    }

    @Override
    public String getJsapiTicket() throws WxErrorException {
        return this.getJsapiTicket(false);
    }

    @Override
    public String getJsapiTicket(boolean forceRefresh) throws WxErrorException {
        return this.getTicket(TicketType.JSAPI, forceRefresh);
    }

    @Override
    public WxJsapiSignature createJsapiSignature(String url) throws WxErrorException {
        long timestamp = System.currentTimeMillis() / 1000L;
        String randomStr = RandomUtils.getRandomStr();
        String jsapiTicket = this.getJsapiTicket(false);
        String signature = SHA1.genWithAmple((String[])new String[]{"jsapi_ticket=" + jsapiTicket, "noncestr=" + randomStr, "timestamp=" + timestamp, "url=" + url});
        WxJsapiSignature jsapiSignature = new WxJsapiSignature();
        jsapiSignature.setAppId(this.getWxMpConfigStorage().getAppId());
        jsapiSignature.setTimestamp(timestamp);
        jsapiSignature.setNonceStr(randomStr);
        jsapiSignature.setUrl(url);
        jsapiSignature.setSignature(signature);
        return jsapiSignature;
    }

    @Override
    public String getAccessToken() throws WxErrorException {
        return this.getAccessToken(false);
    }

    @Override
    public String shortUrl(String longUrl) throws WxErrorException {
        if (longUrl.contains("&access_token=")) {
            throw new WxErrorException(WxError.builder().errorCode(-1).errorMsg("\u8981\u8f6c\u6362\u7684\u7f51\u5740\u4e2d\u5b58\u5728\u975e\u6cd5\u5b57\u7b26\uff5b&access_token=\uff5d\uff0c\u4f1a\u5bfc\u81f4\u5fae\u4fe1\u63a5\u53e3\u62a5\u9519\uff0c\u5c5e\u4e8e\u5fae\u4fe1bug\uff0c\u8bf7\u8c03\u6574\u5730\u5740\uff0c\u5426\u5219\u4e0d\u5efa\u8bae\u4f7f\u7528\u6b64\u65b9\u6cd5\uff01").build());
        }
        JsonObject o = new JsonObject();
        o.addProperty("action", "long2short");
        o.addProperty("long_url", longUrl);
        String responseContent = this.post(WxMpApiUrl.Other.SHORTURL_API_URL, o.toString());
        JsonElement tmpJsonElement = JSON_PARSER.parse(responseContent);
        return tmpJsonElement.getAsJsonObject().get("short_url").getAsString();
    }

    @Override
    public WxMpSemanticQueryResult semanticQuery(WxMpSemanticQuery semanticQuery) throws WxErrorException {
        String responseContent = this.post(WxMpApiUrl.Other.SEMANTIC_SEMPROXY_SEARCH_URL, semanticQuery.toJson());
        return WxMpSemanticQueryResult.fromJson(responseContent);
    }

    @Override
    public String oauth2buildAuthorizationUrl(String redirectURI, String scope, String state) {
        return String.format(WxMpApiUrl.Other.CONNECT_OAUTH2_AUTHORIZE_URL.getUrl(this.getWxMpConfigStorage()), this.getWxMpConfigStorage().getAppId(), URIUtil.encodeURIComponent((String)redirectURI), scope, StringUtils.trimToEmpty((String)state));
    }

    @Override
    public String buildQrConnectUrl(String redirectURI, String scope, String state) {
        return String.format(WxMpApiUrl.Other.QRCONNECT_URL.getUrl(this.getWxMpConfigStorage()), this.getWxMpConfigStorage().getAppId(), URIUtil.encodeURIComponent((String)redirectURI), scope, StringUtils.trimToEmpty((String)state));
    }

    private WxMpOAuth2AccessToken getOAuth2AccessToken(String url) throws WxErrorException {
        try {
            RequestExecutor executor = SimpleGetRequestExecutor.create((RequestHttp)this);
            String responseText = (String)executor.execute(url, null, WxType.MP);
            return WxMpOAuth2AccessToken.fromJson(responseText);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public WxMpOAuth2AccessToken oauth2getAccessToken(String code) throws WxErrorException {
        String url = String.format(WxMpApiUrl.Other.OAUTH2_ACCESS_TOKEN_URL.getUrl(this.getWxMpConfigStorage()), this.getWxMpConfigStorage().getAppId(), this.getWxMpConfigStorage().getSecret(), code);
        return this.getOAuth2AccessToken(url);
    }

    @Override
    public WxMpOAuth2AccessToken oauth2refreshAccessToken(String refreshToken) throws WxErrorException {
        String url = String.format(WxMpApiUrl.Other.OAUTH2_REFRESH_TOKEN_URL.getUrl(this.getWxMpConfigStorage()), this.getWxMpConfigStorage().getAppId(), refreshToken);
        return this.getOAuth2AccessToken(url);
    }

    @Override
    public WxMpUser oauth2getUserInfo(WxMpOAuth2AccessToken token, String lang) throws WxErrorException {
        if (lang == null) {
            lang = "zh_CN";
        }
        String url = String.format(WxMpApiUrl.Other.OAUTH2_USERINFO_URL.getUrl(this.getWxMpConfigStorage()), token.getAccessToken(), token.getOpenId(), lang);
        try {
            RequestExecutor executor = SimpleGetRequestExecutor.create((RequestHttp)this);
            String responseText = (String)executor.execute(url, null, WxType.MP);
            return WxMpUser.fromJson(responseText);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean oauth2validateAccessToken(WxMpOAuth2AccessToken token) {
        String url = String.format(WxMpApiUrl.Other.OAUTH2_VALIDATE_TOKEN_URL.getUrl(this.getWxMpConfigStorage()), token.getAccessToken(), token.getOpenId());
        try {
            SimpleGetRequestExecutor.create((RequestHttp)this).execute(url, null, WxType.MP);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (WxErrorException e) {
            return false;
        }
        return true;
    }

    @Override
    public String[] getCallbackIP() throws WxErrorException {
        String responseContent = this.get(WxMpApiUrl.Other.GET_CALLBACK_IP_URL, null);
        JsonElement tmpJsonElement = JSON_PARSER.parse(responseContent);
        JsonArray ipList = tmpJsonElement.getAsJsonObject().get("ip_list").getAsJsonArray();
        String[] ipArray = new String[ipList.size()];
        for (int i = 0; i < ipList.size(); ++i) {
            ipArray[i] = ipList.get(i).getAsString();
        }
        return ipArray;
    }

    @Override
    public WxNetCheckResult netCheck(String action, String operator) throws WxErrorException {
        JsonObject o = new JsonObject();
        o.addProperty("action", action);
        o.addProperty("check_operator", operator);
        String responseContent = this.post(WxMpApiUrl.Other.NETCHECK_URL, o.toString());
        return WxNetCheckResult.fromJson((String)responseContent);
    }

    @Override
    public WxMpCurrentAutoReplyInfo getCurrentAutoReplyInfo() throws WxErrorException {
        return WxMpCurrentAutoReplyInfo.fromJson(this.get(WxMpApiUrl.Other.GET_CURRENT_AUTOREPLY_INFO_URL, null));
    }

    @Override
    public void clearQuota(String appid) throws WxErrorException {
        JsonObject o = new JsonObject();
        o.addProperty("appid", appid);
        this.post(WxMpApiUrl.Other.CLEAR_QUOTA_URL, o.toString());
    }

    public String get(String url, String queryParam) throws WxErrorException {
        return (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), url, queryParam);
    }

    @Override
    public String get(WxMpApiUrl url, String queryParam) throws WxErrorException {
        return this.get(url.getUrl(this.getWxMpConfigStorage()), queryParam);
    }

    public String post(String url, String postData) throws WxErrorException {
        return (String)this.execute(SimplePostRequestExecutor.create((RequestHttp)this), url, postData);
    }

    @Override
    public String post(WxMpApiUrl url, String postData) throws WxErrorException {
        return this.post(url.getUrl(this.getWxMpConfigStorage()), postData);
    }

    public String post(String url, Object obj) throws WxErrorException {
        return (String)this.execute(SimplePostRequestExecutor.create((RequestHttp)this), url, WxGsonBuilder.create().toJson(obj));
    }

    @Override
    public <T, E> T execute(RequestExecutor<T, E> executor, WxMpApiUrl url, E data) throws WxErrorException {
        return this.execute(executor, url.getUrl(this.getWxMpConfigStorage()), data);
    }

    @Override
    public <T, E> T execute(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        int retryTimes = 0;
        while (true) {
            try {
                return this.executeInternal(executor, uri, data);
            }
            catch (WxErrorException e) {
                if (retryTimes + 1 > this.maxRetryTimes) {
                    log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                    throw new RuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
                }
                WxError error = e.getError();
                if (error.getErrorCode() == -1) {
                    int sleepMillis = this.retrySleepMillis * (1 << retryTimes);
                    try {
                        log.warn("\u5fae\u4fe1\u7cfb\u7edf\u7e41\u5fd9\uff0c{} ms \u540e\u91cd\u8bd5(\u7b2c{}\u6b21)", (Object)sleepMillis, (Object)(retryTimes + 1));
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException e1) {
                        throw new RuntimeException(e1);
                    }
                } else {
                    throw e;
                }
                if (retryTimes++ < this.maxRetryTimes) continue;
                log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                throw new RuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T, E> T executeInternal(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        Object dataForLog = DataUtils.handleDataWithSecret(data);
        if (uri.contains("access_token=")) {
            throw new IllegalArgumentException("uri\u53c2\u6570\u4e2d\u4e0d\u5141\u8bb8\u6709access_token: " + uri);
        }
        String accessToken = this.getAccessToken(false);
        String uriWithAccessToken = uri + (uri.contains("?") ? "&" : "?") + "access_token=" + accessToken;
        try {
            Object result = executor.execute(uriWithAccessToken, data, WxType.MP);
            log.debug("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, result});
            return (T)result;
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (error.getErrorCode() == 42001 || error.getErrorCode() == 40001 || error.getErrorCode() == 40014) {
                Lock lock = this.getWxMpConfigStorage().getAccessTokenLock();
                lock.lock();
                try {
                    if (StringUtils.equals((CharSequence)this.getWxMpConfigStorage().getAccessToken(), (CharSequence)accessToken)) {
                        this.getWxMpConfigStorage().expireAccessToken();
                    }
                }
                catch (Exception ex) {
                    this.getWxMpConfigStorage().expireAccessToken();
                }
                finally {
                    lock.unlock();
                }
                if (this.getWxMpConfigStorage().autoRefreshToken()) {
                    return this.execute(executor, uri, data);
                }
            }
            if (error.getErrorCode() != 0) {
                log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u9519\u8bef\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, error});
                throw new WxErrorException(error, (Throwable)e);
            }
            return null;
        }
        catch (IOException e) {
            log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, e.getMessage()});
            throw new WxErrorException(WxError.builder().errorMsg(e.getMessage()).build(), (Throwable)e);
        }
    }

    @Override
    public WxMpConfigStorage getWxMpConfigStorage() {
        if (this.configStorageMap.size() == 1) {
            return this.configStorageMap.values().iterator().next();
        }
        return this.configStorageMap.get(WxMpConfigStorageHolder.get());
    }

    protected String extractAccessToken(String resultContent) throws WxErrorException {
        WxMpConfigStorage config = this.getWxMpConfigStorage();
        WxError error = WxError.fromJson((String)resultContent, (WxType)WxType.MP);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
        config.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
        return config.getAccessToken();
    }

    @Override
    public void setWxMpConfigStorage(WxMpConfigStorage wxConfigProvider) {
        String defaultMpId = wxConfigProvider.getAppId();
        this.setMultiConfigStorages((Map<String, WxMpConfigStorage>)ImmutableMap.of((Object)defaultMpId, (Object)wxConfigProvider), defaultMpId);
    }

    @Override
    public void setMultiConfigStorages(Map<String, WxMpConfigStorage> configStorages) {
        this.setMultiConfigStorages(configStorages, configStorages.keySet().iterator().next());
    }

    @Override
    public void setMultiConfigStorages(Map<String, WxMpConfigStorage> configStorages, String defaultMpId) {
        this.configStorageMap = Maps.newHashMap(configStorages);
        WxMpConfigStorageHolder.set(defaultMpId);
        this.initHttp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConfigStorage(String mpId, WxMpConfigStorage configStorages) {
        BaseWxMpServiceImpl baseWxMpServiceImpl = this;
        synchronized (baseWxMpServiceImpl) {
            this.configStorageMap.put(mpId, configStorages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfigStorage(String mpId) {
        BaseWxMpServiceImpl baseWxMpServiceImpl = this;
        synchronized (baseWxMpServiceImpl) {
            if (this.configStorageMap.size() == 1) {
                this.configStorageMap.remove(mpId);
                log.warn("\u5df2\u5220\u9664\u6700\u540e\u4e00\u4e2a\u516c\u4f17\u53f7\u914d\u7f6e\uff1a{}\uff0c\u987b\u7acb\u5373\u4f7f\u7528setWxMpConfigStorage\u6216setMultiConfigStorages\u6dfb\u52a0\u914d\u7f6e", (Object)mpId);
                return;
            }
            if (WxMpConfigStorageHolder.get().equals(mpId)) {
                this.configStorageMap.remove(mpId);
                String defaultMpId = this.configStorageMap.keySet().iterator().next();
                WxMpConfigStorageHolder.set(defaultMpId);
                log.warn("\u5df2\u5220\u9664\u9ed8\u8ba4\u516c\u4f17\u53f7\u914d\u7f6e\uff0c\u516c\u4f17\u53f7\u3010{}\u3011\u88ab\u8bbe\u4e3a\u9ed8\u8ba4\u914d\u7f6e", (Object)defaultMpId);
                return;
            }
            this.configStorageMap.remove(mpId);
        }
    }

    @Override
    public WxMpService switchoverTo(String mpId) {
        if (this.configStorageMap.containsKey(mpId)) {
            WxMpConfigStorageHolder.set(mpId);
            return this;
        }
        throw new RuntimeException(String.format("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u3010%s\u3011\u7684\u516c\u4f17\u53f7\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u6838\u5b9e\uff01", mpId));
    }

    @Override
    public boolean switchover(String mpId) {
        if (this.configStorageMap.containsKey(mpId)) {
            WxMpConfigStorageHolder.set(mpId);
            return true;
        }
        log.error("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u3010{}\u3011\u7684\u516c\u4f17\u53f7\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u6838\u5b9e\uff01", (Object)mpId);
        return false;
    }

    @Override
    public void setRetrySleepMillis(int retrySleepMillis) {
        this.retrySleepMillis = retrySleepMillis;
    }

    @Override
    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    @Override
    public WxMpKefuService getKefuService() {
        return this.kefuService;
    }

    @Override
    public WxMpMaterialService getMaterialService() {
        return this.materialService;
    }

    @Override
    public WxMpMenuService getMenuService() {
        return this.menuService;
    }

    @Override
    public WxMpUserService getUserService() {
        return this.userService;
    }

    @Override
    public WxMpUserTagService getUserTagService() {
        return this.tagService;
    }

    @Override
    public WxMpQrcodeService getQrcodeService() {
        return this.qrCodeService;
    }

    @Override
    public WxMpCardService getCardService() {
        return this.cardService;
    }

    @Override
    public WxMpDataCubeService getDataCubeService() {
        return this.dataCubeService;
    }

    @Override
    public WxMpUserBlacklistService getBlackListService() {
        return this.blackListService;
    }

    @Override
    public WxMpStoreService getStoreService() {
        return this.storeService;
    }

    @Override
    public WxMpTemplateMsgService getTemplateMsgService() {
        return this.templateMsgService;
    }

    @Override
    public WxMpSubscribeMsgService getSubscribeMsgService() {
        return this.subscribeMsgService;
    }

    @Override
    public WxMpDeviceService getDeviceService() {
        return this.deviceService;
    }

    @Override
    public WxMpShakeService getShakeService() {
        return this.shakeService;
    }

    @Override
    public WxMpMemberCardService getMemberCardService() {
        return this.memberCardService;
    }

    @Override
    public RequestHttp getRequestHttp() {
        return this;
    }

    @Override
    public WxMpMassMessageService getMassMessageService() {
        return this.massMessageService;
    }

    @Override
    public void setKefuService(WxMpKefuService kefuService) {
        this.kefuService = kefuService;
    }

    @Override
    public void setMaterialService(WxMpMaterialService materialService) {
        this.materialService = materialService;
    }

    @Override
    public void setMenuService(WxMpMenuService menuService) {
        this.menuService = menuService;
    }

    @Override
    public void setUserService(WxMpUserService userService) {
        this.userService = userService;
    }

    @Override
    public void setTagService(WxMpUserTagService tagService) {
        this.tagService = tagService;
    }

    @Override
    public void setQrCodeService(WxMpQrcodeService qrCodeService) {
        this.qrCodeService = qrCodeService;
    }

    @Override
    public void setCardService(WxMpCardService cardService) {
        this.cardService = cardService;
    }

    @Override
    public void setStoreService(WxMpStoreService storeService) {
        this.storeService = storeService;
    }

    @Override
    public void setDataCubeService(WxMpDataCubeService dataCubeService) {
        this.dataCubeService = dataCubeService;
    }

    @Override
    public void setBlackListService(WxMpUserBlacklistService blackListService) {
        this.blackListService = blackListService;
    }

    @Override
    public void setTemplateMsgService(WxMpTemplateMsgService templateMsgService) {
        this.templateMsgService = templateMsgService;
    }

    @Override
    public void setDeviceService(WxMpDeviceService deviceService) {
        this.deviceService = deviceService;
    }

    @Override
    public void setShakeService(WxMpShakeService shakeService) {
        this.shakeService = shakeService;
    }

    @Override
    public void setMemberCardService(WxMpMemberCardService memberCardService) {
        this.memberCardService = memberCardService;
    }

    @Override
    public void setMassMessageService(WxMpMassMessageService massMessageService) {
        this.massMessageService = massMessageService;
    }

    @Override
    public WxMpAiOpenService getAiOpenService() {
        return this.aiOpenService;
    }

    @Override
    public void setAiOpenService(WxMpAiOpenService aiOpenService) {
        this.aiOpenService = aiOpenService;
    }

    @Override
    public WxMpWifiService getWifiService() {
        return this.wifiService;
    }

    @Override
    public WxMpOcrService getOcrService() {
        return this.ocrService;
    }

    @Override
    public WxMpMarketingService getMarketingService() {
        return this.marketingService;
    }

    @Override
    public void setMarketingService(WxMpMarketingService marketingService) {
        this.marketingService = marketingService;
    }

    @Override
    public void setOcrService(WxMpOcrService ocrService) {
        this.ocrService = ocrService;
    }

    @Override
    public WxMpCommentService getCommentService() {
        return this.commentService;
    }

    @Override
    public void setCommentService(WxMpCommentService commentService) {
        this.commentService = commentService;
    }

    @Override
    public WxMpImgProcService getImgProcService() {
        return this.imgProcService;
    }

    @Override
    public void setImgProcService(WxMpImgProcService imgProcService) {
        this.imgProcService = imgProcService;
    }

    public WxMpMerchantInvoiceService getMerchantInvoiceService() {
        return this.merchantInvoiceService;
    }

    public void setMerchantInvoiceService(WxMpMerchantInvoiceService merchantInvoiceService) {
        this.merchantInvoiceService = merchantInvoiceService;
    }
}

