/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import me.chanjar.weixin.common.api.WxImgProcService;
import me.chanjar.weixin.common.bean.imgproc.WxImgProcAiCropResult;
import me.chanjar.weixin.common.bean.imgproc.WxImgProcQrCodeResult;
import me.chanjar.weixin.common.bean.imgproc.WxImgProcSuperResolutionResult;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.requestexecuter.ocr.OcrDiscernRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;
import org.apache.commons.lang3.StringUtils;

public class WxMpImgProcServiceImpl
implements WxImgProcService {
    private final WxMpService wxMpService;

    public WxImgProcQrCodeResult qrCode(String imgUrl) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String result = this.wxMpService.get(String.format(WxMpApiUrl.ImgProc.QRCODE.getUrl(this.wxMpService.getWxMpConfigStorage()), imgUrl), null);
        return WxImgProcQrCodeResult.fromJson((String)result);
    }

    public WxImgProcQrCodeResult qrCode(File imgFile) throws WxErrorException {
        String result = (String)this.wxMpService.execute(OcrDiscernRequestExecutor.create((RequestHttp)this.wxMpService.getRequestHttp()), WxMpApiUrl.ImgProc.FILE_QRCODE.getUrl(this.wxMpService.getWxMpConfigStorage()), imgFile);
        return WxImgProcQrCodeResult.fromJson((String)result);
    }

    public WxImgProcSuperResolutionResult superResolution(String imgUrl) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String result = this.wxMpService.get(String.format(WxMpApiUrl.ImgProc.SUPER_RESOLUTION.getUrl(this.wxMpService.getWxMpConfigStorage()), imgUrl), null);
        return WxImgProcSuperResolutionResult.fromJson((String)result);
    }

    public WxImgProcSuperResolutionResult superResolution(File imgFile) throws WxErrorException {
        String result = (String)this.wxMpService.execute(OcrDiscernRequestExecutor.create((RequestHttp)this.wxMpService.getRequestHttp()), WxMpApiUrl.ImgProc.FILE_SUPER_RESOLUTION.getUrl(this.wxMpService.getWxMpConfigStorage()), imgFile);
        return WxImgProcSuperResolutionResult.fromJson((String)result);
    }

    public WxImgProcAiCropResult aiCrop(String imgUrl) throws WxErrorException {
        return this.aiCrop(imgUrl, "");
    }

    public WxImgProcAiCropResult aiCrop(String imgUrl, String ratios) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (StringUtils.isEmpty((CharSequence)ratios)) {
            ratios = "";
        }
        String result = this.wxMpService.get(String.format(WxMpApiUrl.ImgProc.AI_CROP.getUrl(this.wxMpService.getWxMpConfigStorage()), imgUrl, ratios), null);
        return WxImgProcAiCropResult.fromJson((String)result);
    }

    public WxImgProcAiCropResult aiCrop(File imgFile) throws WxErrorException {
        return this.aiCrop(imgFile, "");
    }

    public WxImgProcAiCropResult aiCrop(File imgFile, String ratios) throws WxErrorException {
        if (StringUtils.isEmpty((CharSequence)ratios)) {
            ratios = "";
        }
        String result = (String)this.wxMpService.execute(OcrDiscernRequestExecutor.create((RequestHttp)this.wxMpService.getRequestHttp()), String.format(WxMpApiUrl.ImgProc.FILE_AI_CROP.getUrl(this.wxMpService.getWxMpConfigStorage()), ratios), imgFile);
        return WxImgProcAiCropResult.fromJson((String)result);
    }

    public WxMpImgProcServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }
}

