/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.WxMpUserTagService;
import me.chanjar.weixin.mp.bean.tag.WxTagListUser;
import me.chanjar.weixin.mp.bean.tag.WxUserTag;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;
import me.chanjar.weixin.mp.util.json.WxMpGsonBuilder;
import org.apache.commons.lang3.StringUtils;

public class WxMpUserTagServiceImpl
implements WxMpUserTagService {
    private final WxMpService wxMpService;

    @Override
    public WxUserTag tagCreate(String name) throws WxErrorException {
        JsonObject json = new JsonObject();
        JsonObject tagJson = new JsonObject();
        tagJson.addProperty("name", name);
        json.add("tag", (JsonElement)tagJson);
        String responseContent = this.wxMpService.post(WxMpApiUrl.UserTag.TAGS_CREATE, json.toString());
        return WxUserTag.fromJson(responseContent);
    }

    @Override
    public List<WxUserTag> tagGet() throws WxErrorException {
        String responseContent = this.wxMpService.get(WxMpApiUrl.UserTag.TAGS_GET, null);
        return WxUserTag.listFromJson(responseContent);
    }

    @Override
    public Boolean tagUpdate(Long id, String name) throws WxErrorException {
        JsonObject json = new JsonObject();
        JsonObject tagJson = new JsonObject();
        tagJson.addProperty("id", (Number)id);
        tagJson.addProperty("name", name);
        json.add("tag", (JsonElement)tagJson);
        String responseContent = this.wxMpService.post(WxMpApiUrl.UserTag.TAGS_UPDATE, json.toString());
        WxError wxError = WxError.fromJson((String)responseContent, (WxType)WxType.MP);
        if (wxError.getErrorCode() == 0) {
            return true;
        }
        throw new WxErrorException(wxError);
    }

    @Override
    public Boolean tagDelete(Long id) throws WxErrorException {
        JsonObject json = new JsonObject();
        JsonObject tagJson = new JsonObject();
        tagJson.addProperty("id", (Number)id);
        json.add("tag", (JsonElement)tagJson);
        String responseContent = this.wxMpService.post(WxMpApiUrl.UserTag.TAGS_DELETE, json.toString());
        WxError wxError = WxError.fromJson((String)responseContent, (WxType)WxType.MP);
        if (wxError.getErrorCode() == 0) {
            return true;
        }
        throw new WxErrorException(wxError);
    }

    @Override
    public WxTagListUser tagListUser(Long tagId, String nextOpenid) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("tagid", (Number)tagId);
        json.addProperty("next_openid", StringUtils.trimToEmpty((String)nextOpenid));
        String responseContent = this.wxMpService.post(WxMpApiUrl.UserTag.TAG_GET, json.toString());
        return WxTagListUser.fromJson(responseContent);
    }

    @Override
    public boolean batchTagging(Long tagId, String[] openids) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("tagid", (Number)tagId);
        JsonArray openidArrayJson = new JsonArray();
        for (String openid : openids) {
            openidArrayJson.add(openid);
        }
        json.add("openid_list", (JsonElement)openidArrayJson);
        String responseContent = this.wxMpService.post(WxMpApiUrl.UserTag.TAGS_MEMBERS_BATCHTAGGING, json.toString());
        WxError wxError = WxError.fromJson((String)responseContent, (WxType)WxType.MP);
        if (wxError.getErrorCode() == 0) {
            return true;
        }
        throw new WxErrorException(wxError);
    }

    @Override
    public boolean batchUntagging(Long tagId, String[] openids) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("tagid", (Number)tagId);
        JsonArray openidArrayJson = new JsonArray();
        for (String openid : openids) {
            openidArrayJson.add(openid);
        }
        json.add("openid_list", (JsonElement)openidArrayJson);
        String responseContent = this.wxMpService.post(WxMpApiUrl.UserTag.TAGS_MEMBERS_BATCHUNTAGGING, json.toString());
        WxError wxError = WxError.fromJson((String)responseContent, (WxType)WxType.MP);
        if (wxError.getErrorCode() == 0) {
            return true;
        }
        throw new WxErrorException(wxError);
    }

    @Override
    public List<Long> userTagList(String openid) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("openid", openid);
        String responseContent = this.wxMpService.post(WxMpApiUrl.UserTag.TAGS_GETIDLIST, json.toString());
        return (List)WxMpGsonBuilder.create().fromJson(GsonParser.parse((String)responseContent).get("tagid_list"), new TypeToken<List<Long>>(){}.getType());
    }

    public WxMpUserTagServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }
}

