/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.config.impl;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.enums.TicketType;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import me.chanjar.weixin.mp.bean.WxMpHostConfig;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.mp.util.json.WxMpGsonBuilder;

public class WxMpDefaultConfigImpl
implements WxMpConfigStorage,
Serializable {
    private static final long serialVersionUID = -6646519023303395185L;
    protected volatile String appId;
    protected volatile String secret;
    protected volatile String token;
    protected volatile String templateId;
    protected volatile String accessToken;
    protected volatile String aesKey;
    protected volatile long expiresTime;
    protected volatile String oauth2redirectUri;
    protected volatile String httpProxyHost;
    protected volatile int httpProxyPort;
    protected volatile String httpProxyUsername;
    protected volatile String httpProxyPassword;
    protected volatile String jsapiTicket;
    protected volatile long jsapiTicketExpiresTime;
    protected volatile String sdkTicket;
    protected volatile long sdkTicketExpiresTime;
    protected volatile String cardApiTicket;
    protected volatile long cardApiTicketExpiresTime;
    protected volatile Lock accessTokenLock = new ReentrantLock();
    protected volatile Lock jsapiTicketLock = new ReentrantLock();
    protected volatile Lock sdkTicketLock = new ReentrantLock();
    protected volatile Lock cardApiTicketLock = new ReentrantLock();
    protected volatile File tmpDirFile;
    protected volatile ApacheHttpClientBuilder apacheHttpClientBuilder;
    private WxMpHostConfig hostConfig = null;

    @Override
    public boolean isAccessTokenExpired() {
        return System.currentTimeMillis() > this.expiresTime;
    }

    @Override
    public synchronized void updateAccessToken(WxAccessToken accessToken) {
        this.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
    }

    @Override
    public synchronized void updateAccessToken(String accessToken, int expiresInSeconds) {
        this.accessToken = accessToken;
        this.expiresTime = System.currentTimeMillis() + (long)(expiresInSeconds - 200) * 1000L;
    }

    @Override
    public void expireAccessToken() {
        this.expiresTime = 0L;
    }

    @Override
    public String getTicket(TicketType type) {
        switch (type) {
            case SDK: {
                return this.sdkTicket;
            }
            case JSAPI: {
                return this.jsapiTicket;
            }
            case WX_CARD: {
                return this.cardApiTicket;
            }
        }
        return null;
    }

    public void setTicket(TicketType type, String ticket) {
        switch (type) {
            case JSAPI: {
                this.jsapiTicket = ticket;
                break;
            }
            case WX_CARD: {
                this.cardApiTicket = ticket;
                break;
            }
            case SDK: {
                this.sdkTicket = ticket;
                break;
            }
        }
    }

    @Override
    public Lock getTicketLock(TicketType type) {
        switch (type) {
            case SDK: {
                return this.sdkTicketLock;
            }
            case JSAPI: {
                return this.jsapiTicketLock;
            }
            case WX_CARD: {
                return this.cardApiTicketLock;
            }
        }
        return null;
    }

    @Override
    public boolean isTicketExpired(TicketType type) {
        switch (type) {
            case SDK: {
                return System.currentTimeMillis() > this.sdkTicketExpiresTime;
            }
            case JSAPI: {
                return System.currentTimeMillis() > this.jsapiTicketExpiresTime;
            }
            case WX_CARD: {
                return System.currentTimeMillis() > this.cardApiTicketExpiresTime;
            }
        }
        return false;
    }

    @Override
    public synchronized void updateTicket(TicketType type, String ticket, int expiresInSeconds) {
        switch (type) {
            case JSAPI: {
                this.jsapiTicket = ticket;
                this.jsapiTicketExpiresTime = System.currentTimeMillis() + (long)(expiresInSeconds - 200) * 1000L;
                break;
            }
            case WX_CARD: {
                this.cardApiTicket = ticket;
                this.cardApiTicketExpiresTime = System.currentTimeMillis() + (long)(expiresInSeconds - 200) * 1000L;
                break;
            }
            case SDK: {
                this.sdkTicket = ticket;
                this.sdkTicketExpiresTime = System.currentTimeMillis() + (long)(expiresInSeconds - 200) * 1000L;
                break;
            }
        }
    }

    @Override
    public void expireTicket(TicketType type) {
        switch (type) {
            case JSAPI: {
                this.jsapiTicketExpiresTime = 0L;
                break;
            }
            case WX_CARD: {
                this.cardApiTicketExpiresTime = 0L;
                break;
            }
            case SDK: {
                this.sdkTicketExpiresTime = 0L;
                break;
            }
        }
    }

    public String toString() {
        return WxMpGsonBuilder.create().toJson((Object)this);
    }

    @Override
    public boolean autoRefreshToken() {
        return true;
    }

    @Override
    public WxMpHostConfig getHostConfig() {
        return this.hostConfig;
    }

    @Override
    public void setHostConfig(WxMpHostConfig hostConfig) {
        this.hostConfig = hostConfig;
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    @Override
    public String getSecret() {
        return this.secret;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getTemplateId() {
        return this.templateId;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public String getAesKey() {
        return this.aesKey;
    }

    @Override
    public long getExpiresTime() {
        return this.expiresTime;
    }

    @Override
    public String getOauth2redirectUri() {
        return this.oauth2redirectUri;
    }

    @Override
    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    @Override
    public int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    @Override
    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    @Override
    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public String getJsapiTicket() {
        return this.jsapiTicket;
    }

    public long getJsapiTicketExpiresTime() {
        return this.jsapiTicketExpiresTime;
    }

    public String getSdkTicket() {
        return this.sdkTicket;
    }

    public long getSdkTicketExpiresTime() {
        return this.sdkTicketExpiresTime;
    }

    public String getCardApiTicket() {
        return this.cardApiTicket;
    }

    public long getCardApiTicketExpiresTime() {
        return this.cardApiTicketExpiresTime;
    }

    @Override
    public Lock getAccessTokenLock() {
        return this.accessTokenLock;
    }

    public Lock getJsapiTicketLock() {
        return this.jsapiTicketLock;
    }

    public Lock getSdkTicketLock() {
        return this.sdkTicketLock;
    }

    public Lock getCardApiTicketLock() {
        return this.cardApiTicketLock;
    }

    @Override
    public File getTmpDirFile() {
        return this.tmpDirFile;
    }

    @Override
    public ApacheHttpClientBuilder getApacheHttpClientBuilder() {
        return this.apacheHttpClientBuilder;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setAesKey(String aesKey) {
        this.aesKey = aesKey;
    }

    public void setExpiresTime(long expiresTime) {
        this.expiresTime = expiresTime;
    }

    public void setOauth2redirectUri(String oauth2redirectUri) {
        this.oauth2redirectUri = oauth2redirectUri;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public void setHttpProxyPort(int httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public void setHttpProxyUsername(String httpProxyUsername) {
        this.httpProxyUsername = httpProxyUsername;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    public void setJsapiTicket(String jsapiTicket) {
        this.jsapiTicket = jsapiTicket;
    }

    public void setJsapiTicketExpiresTime(long jsapiTicketExpiresTime) {
        this.jsapiTicketExpiresTime = jsapiTicketExpiresTime;
    }

    public void setSdkTicket(String sdkTicket) {
        this.sdkTicket = sdkTicket;
    }

    public void setSdkTicketExpiresTime(long sdkTicketExpiresTime) {
        this.sdkTicketExpiresTime = sdkTicketExpiresTime;
    }

    public void setCardApiTicket(String cardApiTicket) {
        this.cardApiTicket = cardApiTicket;
    }

    public void setCardApiTicketExpiresTime(long cardApiTicketExpiresTime) {
        this.cardApiTicketExpiresTime = cardApiTicketExpiresTime;
    }

    public void setAccessTokenLock(Lock accessTokenLock) {
        this.accessTokenLock = accessTokenLock;
    }

    public void setJsapiTicketLock(Lock jsapiTicketLock) {
        this.jsapiTicketLock = jsapiTicketLock;
    }

    public void setSdkTicketLock(Lock sdkTicketLock) {
        this.sdkTicketLock = sdkTicketLock;
    }

    public void setCardApiTicketLock(Lock cardApiTicketLock) {
        this.cardApiTicketLock = cardApiTicketLock;
    }

    public void setTmpDirFile(File tmpDirFile) {
        this.tmpDirFile = tmpDirFile;
    }

    public void setApacheHttpClientBuilder(ApacheHttpClientBuilder apacheHttpClientBuilder) {
        this.apacheHttpClientBuilder = apacheHttpClientBuilder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxMpDefaultConfigImpl)) {
            return false;
        }
        WxMpDefaultConfigImpl other = (WxMpDefaultConfigImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$templateId = this.getTemplateId();
        String other$templateId = other.getTemplateId();
        if (this$templateId == null ? other$templateId != null : !this$templateId.equals(other$templateId)) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        String this$aesKey = this.getAesKey();
        String other$aesKey = other.getAesKey();
        if (this$aesKey == null ? other$aesKey != null : !this$aesKey.equals(other$aesKey)) {
            return false;
        }
        if (this.getExpiresTime() != other.getExpiresTime()) {
            return false;
        }
        String this$oauth2redirectUri = this.getOauth2redirectUri();
        String other$oauth2redirectUri = other.getOauth2redirectUri();
        if (this$oauth2redirectUri == null ? other$oauth2redirectUri != null : !this$oauth2redirectUri.equals(other$oauth2redirectUri)) {
            return false;
        }
        String this$httpProxyHost = this.getHttpProxyHost();
        String other$httpProxyHost = other.getHttpProxyHost();
        if (this$httpProxyHost == null ? other$httpProxyHost != null : !this$httpProxyHost.equals(other$httpProxyHost)) {
            return false;
        }
        if (this.getHttpProxyPort() != other.getHttpProxyPort()) {
            return false;
        }
        String this$httpProxyUsername = this.getHttpProxyUsername();
        String other$httpProxyUsername = other.getHttpProxyUsername();
        if (this$httpProxyUsername == null ? other$httpProxyUsername != null : !this$httpProxyUsername.equals(other$httpProxyUsername)) {
            return false;
        }
        String this$httpProxyPassword = this.getHttpProxyPassword();
        String other$httpProxyPassword = other.getHttpProxyPassword();
        if (this$httpProxyPassword == null ? other$httpProxyPassword != null : !this$httpProxyPassword.equals(other$httpProxyPassword)) {
            return false;
        }
        String this$jsapiTicket = this.getJsapiTicket();
        String other$jsapiTicket = other.getJsapiTicket();
        if (this$jsapiTicket == null ? other$jsapiTicket != null : !this$jsapiTicket.equals(other$jsapiTicket)) {
            return false;
        }
        if (this.getJsapiTicketExpiresTime() != other.getJsapiTicketExpiresTime()) {
            return false;
        }
        String this$sdkTicket = this.getSdkTicket();
        String other$sdkTicket = other.getSdkTicket();
        if (this$sdkTicket == null ? other$sdkTicket != null : !this$sdkTicket.equals(other$sdkTicket)) {
            return false;
        }
        if (this.getSdkTicketExpiresTime() != other.getSdkTicketExpiresTime()) {
            return false;
        }
        String this$cardApiTicket = this.getCardApiTicket();
        String other$cardApiTicket = other.getCardApiTicket();
        if (this$cardApiTicket == null ? other$cardApiTicket != null : !this$cardApiTicket.equals(other$cardApiTicket)) {
            return false;
        }
        if (this.getCardApiTicketExpiresTime() != other.getCardApiTicketExpiresTime()) {
            return false;
        }
        Lock this$accessTokenLock = this.getAccessTokenLock();
        Lock other$accessTokenLock = other.getAccessTokenLock();
        if (this$accessTokenLock == null ? other$accessTokenLock != null : !this$accessTokenLock.equals(other$accessTokenLock)) {
            return false;
        }
        Lock this$jsapiTicketLock = this.getJsapiTicketLock();
        Lock other$jsapiTicketLock = other.getJsapiTicketLock();
        if (this$jsapiTicketLock == null ? other$jsapiTicketLock != null : !this$jsapiTicketLock.equals(other$jsapiTicketLock)) {
            return false;
        }
        Lock this$sdkTicketLock = this.getSdkTicketLock();
        Lock other$sdkTicketLock = other.getSdkTicketLock();
        if (this$sdkTicketLock == null ? other$sdkTicketLock != null : !this$sdkTicketLock.equals(other$sdkTicketLock)) {
            return false;
        }
        Lock this$cardApiTicketLock = this.getCardApiTicketLock();
        Lock other$cardApiTicketLock = other.getCardApiTicketLock();
        if (this$cardApiTicketLock == null ? other$cardApiTicketLock != null : !this$cardApiTicketLock.equals(other$cardApiTicketLock)) {
            return false;
        }
        File this$tmpDirFile = this.getTmpDirFile();
        File other$tmpDirFile = other.getTmpDirFile();
        if (this$tmpDirFile == null ? other$tmpDirFile != null : !((Object)this$tmpDirFile).equals(other$tmpDirFile)) {
            return false;
        }
        ApacheHttpClientBuilder this$apacheHttpClientBuilder = this.getApacheHttpClientBuilder();
        ApacheHttpClientBuilder other$apacheHttpClientBuilder = other.getApacheHttpClientBuilder();
        if (this$apacheHttpClientBuilder == null ? other$apacheHttpClientBuilder != null : !this$apacheHttpClientBuilder.equals(other$apacheHttpClientBuilder)) {
            return false;
        }
        WxMpHostConfig this$hostConfig = this.getHostConfig();
        WxMpHostConfig other$hostConfig = other.getHostConfig();
        return !(this$hostConfig == null ? other$hostConfig != null : !((Object)this$hostConfig).equals(other$hostConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxMpDefaultConfigImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $templateId = this.getTemplateId();
        result = result * 59 + ($templateId == null ? 43 : $templateId.hashCode());
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        String $aesKey = this.getAesKey();
        result = result * 59 + ($aesKey == null ? 43 : $aesKey.hashCode());
        long $expiresTime = this.getExpiresTime();
        result = result * 59 + (int)($expiresTime >>> 32 ^ $expiresTime);
        String $oauth2redirectUri = this.getOauth2redirectUri();
        result = result * 59 + ($oauth2redirectUri == null ? 43 : $oauth2redirectUri.hashCode());
        String $httpProxyHost = this.getHttpProxyHost();
        result = result * 59 + ($httpProxyHost == null ? 43 : $httpProxyHost.hashCode());
        result = result * 59 + this.getHttpProxyPort();
        String $httpProxyUsername = this.getHttpProxyUsername();
        result = result * 59 + ($httpProxyUsername == null ? 43 : $httpProxyUsername.hashCode());
        String $httpProxyPassword = this.getHttpProxyPassword();
        result = result * 59 + ($httpProxyPassword == null ? 43 : $httpProxyPassword.hashCode());
        String $jsapiTicket = this.getJsapiTicket();
        result = result * 59 + ($jsapiTicket == null ? 43 : $jsapiTicket.hashCode());
        long $jsapiTicketExpiresTime = this.getJsapiTicketExpiresTime();
        result = result * 59 + (int)($jsapiTicketExpiresTime >>> 32 ^ $jsapiTicketExpiresTime);
        String $sdkTicket = this.getSdkTicket();
        result = result * 59 + ($sdkTicket == null ? 43 : $sdkTicket.hashCode());
        long $sdkTicketExpiresTime = this.getSdkTicketExpiresTime();
        result = result * 59 + (int)($sdkTicketExpiresTime >>> 32 ^ $sdkTicketExpiresTime);
        String $cardApiTicket = this.getCardApiTicket();
        result = result * 59 + ($cardApiTicket == null ? 43 : $cardApiTicket.hashCode());
        long $cardApiTicketExpiresTime = this.getCardApiTicketExpiresTime();
        result = result * 59 + (int)($cardApiTicketExpiresTime >>> 32 ^ $cardApiTicketExpiresTime);
        Lock $accessTokenLock = this.getAccessTokenLock();
        result = result * 59 + ($accessTokenLock == null ? 43 : $accessTokenLock.hashCode());
        Lock $jsapiTicketLock = this.getJsapiTicketLock();
        result = result * 59 + ($jsapiTicketLock == null ? 43 : $jsapiTicketLock.hashCode());
        Lock $sdkTicketLock = this.getSdkTicketLock();
        result = result * 59 + ($sdkTicketLock == null ? 43 : $sdkTicketLock.hashCode());
        Lock $cardApiTicketLock = this.getCardApiTicketLock();
        result = result * 59 + ($cardApiTicketLock == null ? 43 : $cardApiTicketLock.hashCode());
        File $tmpDirFile = this.getTmpDirFile();
        result = result * 59 + ($tmpDirFile == null ? 43 : ((Object)$tmpDirFile).hashCode());
        ApacheHttpClientBuilder $apacheHttpClientBuilder = this.getApacheHttpClientBuilder();
        result = result * 59 + ($apacheHttpClientBuilder == null ? 43 : $apacheHttpClientBuilder.hashCode());
        WxMpHostConfig $hostConfig = this.getHostConfig();
        result = result * 59 + ($hostConfig == null ? 43 : ((Object)$hostConfig).hashCode());
        return result;
    }
}

