/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpQrcodeService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpQrCodeTicket;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;
import me.chanjar.weixin.mp.util.requestexecuter.qrcode.QrCodeRequestExecutor;
import org.apache.commons.lang3.StringUtils;

public class WxMpQrcodeServiceImpl
implements WxMpQrcodeService {
    private final WxMpService wxMpService;

    @Override
    public WxMpQrCodeTicket qrCodeCreateTmpTicket(int sceneId, Integer expireSeconds) throws WxErrorException {
        if (sceneId == 0) {
            throw new WxErrorException("\u4e34\u65f6\u4e8c\u7ef4\u7801\u573a\u666f\u503c\u4e0d\u80fd\u4e3a0\uff01");
        }
        return this.createQrCode("QR_SCENE", null, sceneId, expireSeconds);
    }

    @Override
    public WxMpQrCodeTicket qrCodeCreateTmpTicket(String sceneStr, Integer expireSeconds) throws WxErrorException {
        if (StringUtils.isBlank((CharSequence)sceneStr)) {
            throw new WxErrorException("\u4e34\u65f6\u4e8c\u7ef4\u7801\u573a\u666f\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.createQrCode("QR_STR_SCENE", sceneStr, null, expireSeconds);
    }

    private WxMpQrCodeTicket createQrCode(String actionName, String sceneStr, Integer sceneId, Integer expireSeconds) throws WxErrorException {
        if (expireSeconds != null && expireSeconds > 2592000) {
            throw new WxErrorException("\u4e34\u65f6\u4e8c\u7ef4\u7801\u6709\u6548\u65f6\u95f4\u6700\u5927\u4e0d\u80fd\u8d85\u8fc72592000\uff08\u537330\u5929\uff09\uff01");
        }
        if (expireSeconds == null) {
            expireSeconds = 30;
        }
        return this.getQrCodeTicket(actionName, sceneStr, sceneId, expireSeconds);
    }

    private WxMpQrCodeTicket getQrCodeTicket(String actionName, String sceneStr, Integer sceneId, Integer expireSeconds) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("action_name", actionName);
        if (expireSeconds != null) {
            json.addProperty("expire_seconds", (Number)expireSeconds);
        }
        JsonObject actionInfo = new JsonObject();
        JsonObject scene = new JsonObject();
        if (sceneStr != null) {
            scene.addProperty("scene_str", sceneStr);
        } else if (sceneId != null) {
            scene.addProperty("scene_id", (Number)sceneId);
        }
        actionInfo.add("scene", (JsonElement)scene);
        json.add("action_info", (JsonElement)actionInfo);
        String responseContent = this.wxMpService.post((WxMpApiUrl)WxMpApiUrl.Qrcode.QRCODE_CREATE, json.toString());
        return WxMpQrCodeTicket.fromJson(responseContent);
    }

    @Override
    public WxMpQrCodeTicket qrCodeCreateLastTicket(int sceneId) throws WxErrorException {
        if (sceneId < 1 || sceneId > 100000) {
            throw new WxErrorException("\u6c38\u4e45\u4e8c\u7ef4\u7801\u7684\u573a\u666f\u503c\u76ee\u524d\u53ea\u652f\u63011--100000\uff01");
        }
        return this.getQrCodeTicket("QR_LIMIT_SCENE", null, sceneId, null);
    }

    @Override
    public WxMpQrCodeTicket qrCodeCreateLastTicket(String sceneStr) throws WxErrorException {
        return this.getQrCodeTicket("QR_LIMIT_STR_SCENE", sceneStr, null, null);
    }

    @Override
    public File qrCodePicture(WxMpQrCodeTicket ticket) throws WxErrorException {
        return this.wxMpService.execute(QrCodeRequestExecutor.create(this.wxMpService.getRequestHttp()), WxMpApiUrl.Qrcode.SHOW_QRCODE, ticket);
    }

    @Override
    public String qrCodePictureUrl(String ticket, boolean needShortUrl) throws WxErrorException {
        try {
            String resultUrl = String.format(WxMpApiUrl.Qrcode.SHOW_QRCODE_WITH_TICKET.getUrl(this.wxMpService.getWxMpConfigStorage()), URLEncoder.encode(ticket, StandardCharsets.UTF_8.name()));
            if (needShortUrl) {
                return this.wxMpService.shortUrl(resultUrl);
            }
            return resultUrl;
        }
        catch (UnsupportedEncodingException e) {
            throw new WxErrorException(e.getMessage());
        }
    }

    @Override
    public String qrCodePictureUrl(String ticket) throws WxErrorException {
        return this.qrCodePictureUrl(ticket, false);
    }

    public WxMpQrcodeServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }
}

