/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.api.impl;

import java.io.IOException;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.open.api.WxOpenComponentService;
import me.chanjar.weixin.open.api.WxOpenConfigStorage;
import me.chanjar.weixin.open.api.WxOpenService;
import me.chanjar.weixin.open.api.impl.WxOpenComponentServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WxOpenServiceAbstractImpl<H, P>
implements WxOpenService,
RequestHttp<H, P> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected WxOpenComponentService wxOpenComponentService = new WxOpenComponentServiceImpl(this);
    private WxOpenConfigStorage wxOpenConfigStorage;

    @Override
    public WxOpenComponentService getWxOpenComponentService() {
        return this.wxOpenComponentService;
    }

    @Override
    public WxOpenConfigStorage getWxOpenConfigStorage() {
        return this.wxOpenConfigStorage;
    }

    @Override
    public void setWxOpenConfigStorage(WxOpenConfigStorage wxOpenConfigStorage) {
        this.wxOpenConfigStorage = wxOpenConfigStorage;
    }

    protected synchronized <T, E> T execute(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        try {
            Object result = executor.execute(uri, data);
            this.log.debug("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{uri, data, result});
            return (T)result;
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (error.getErrorCode() != 0) {
                this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u9519\u8bef\u4fe1\u606f\u3011\uff1a{}", new Object[]{uri, data, error});
                throw new WxErrorException(error, (Throwable)e);
            }
            return null;
        }
        catch (IOException e) {
            this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{uri, data, e.getMessage()});
            throw new RuntimeException(e);
        }
    }
}

