/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.api.impl;

import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.crypto.SHA1;
import me.chanjar.weixin.common.util.http.URIUtil;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.open.api.WxOpenComponentService;
import me.chanjar.weixin.open.api.WxOpenConfigStorage;
import me.chanjar.weixin.open.api.WxOpenFastMaService;
import me.chanjar.weixin.open.api.WxOpenMaService;
import me.chanjar.weixin.open.api.WxOpenService;
import me.chanjar.weixin.open.api.impl.WxOpenFastMaServiceImpl;
import me.chanjar.weixin.open.api.impl.WxOpenMaServiceImpl;
import me.chanjar.weixin.open.api.impl.WxOpenMpServiceImpl;
import me.chanjar.weixin.open.bean.WxOpenAuthorizerAccessToken;
import me.chanjar.weixin.open.bean.WxOpenComponentAccessToken;
import me.chanjar.weixin.open.bean.WxOpenCreateResult;
import me.chanjar.weixin.open.bean.WxOpenMaCodeTemplate;
import me.chanjar.weixin.open.bean.auth.WxOpenAuthorizationInfo;
import me.chanjar.weixin.open.bean.message.WxOpenXmlMessage;
import me.chanjar.weixin.open.bean.result.WxOpenAuthorizerInfoResult;
import me.chanjar.weixin.open.bean.result.WxOpenAuthorizerListResult;
import me.chanjar.weixin.open.bean.result.WxOpenAuthorizerOptionResult;
import me.chanjar.weixin.open.bean.result.WxOpenQueryAuthResult;
import me.chanjar.weixin.open.bean.result.WxOpenResult;
import me.chanjar.weixin.open.util.json.WxOpenGsonBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxOpenComponentServiceImpl
implements WxOpenComponentService {
    private static final JsonParser JSON_PARSER = new JsonParser();
    private static final Map<String, WxOpenMaService> WX_OPEN_MA_SERVICE_MAP = new ConcurrentHashMap<String, WxOpenMaService>();
    private static final Map<String, WxMpService> WX_OPEN_MP_SERVICE_MAP = new ConcurrentHashMap<String, WxMpService>();
    private static final Map<String, WxOpenFastMaService> WX_OPEN_FAST_MA_SERVICE_MAP = new ConcurrentHashMap<String, WxOpenFastMaService>();
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private WxOpenService wxOpenService;

    public WxOpenComponentServiceImpl(WxOpenService wxOpenService) {
        this.wxOpenService = wxOpenService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WxMpService getWxMpServiceByAppid(String appId) {
        Object wxMpService = WX_OPEN_MP_SERVICE_MAP.get(appId);
        if (wxMpService == null) {
            Map<String, WxMpService> map = WX_OPEN_MP_SERVICE_MAP;
            synchronized (map) {
                wxMpService = WX_OPEN_MP_SERVICE_MAP.get(appId);
                if (wxMpService == null) {
                    wxMpService = new WxOpenMpServiceImpl(this, appId, this.getWxOpenConfigStorage().getWxMpConfigStorage(appId));
                    WX_OPEN_MP_SERVICE_MAP.put(appId, (WxMpService)wxMpService);
                }
            }
        }
        return wxMpService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WxOpenMaService getWxMaServiceByAppid(String appId) {
        WxOpenMaService wxOpenMaService = WX_OPEN_MA_SERVICE_MAP.get(appId);
        if (wxOpenMaService == null) {
            Map<String, WxOpenMaService> map = WX_OPEN_MA_SERVICE_MAP;
            synchronized (map) {
                wxOpenMaService = WX_OPEN_MA_SERVICE_MAP.get(appId);
                if (wxOpenMaService == null) {
                    wxOpenMaService = new WxOpenMaServiceImpl(this, appId, this.getWxOpenConfigStorage().getWxMaConfig(appId));
                    WX_OPEN_MA_SERVICE_MAP.put(appId, wxOpenMaService);
                }
            }
        }
        return wxOpenMaService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WxOpenFastMaService getWxFastMaServiceByAppid(String appId) {
        WxOpenFastMaService fastMaService = WX_OPEN_FAST_MA_SERVICE_MAP.get(appId);
        if (fastMaService == null) {
            Map<String, WxOpenFastMaService> map = WX_OPEN_FAST_MA_SERVICE_MAP;
            synchronized (map) {
                fastMaService = WX_OPEN_FAST_MA_SERVICE_MAP.get(appId);
                if (fastMaService == null) {
                    fastMaService = new WxOpenFastMaServiceImpl(this, appId, this.getWxOpenConfigStorage().getWxMaConfig(appId));
                    WX_OPEN_FAST_MA_SERVICE_MAP.put(appId, fastMaService);
                }
            }
        }
        return fastMaService;
    }

    public WxOpenService getWxOpenService() {
        return this.wxOpenService;
    }

    @Override
    public WxOpenConfigStorage getWxOpenConfigStorage() {
        return this.wxOpenService.getWxOpenConfigStorage();
    }

    @Override
    public boolean checkSignature(String timestamp, String nonce, String signature) {
        try {
            return SHA1.gen((String[])new String[]{this.getWxOpenConfigStorage().getComponentToken(), timestamp, nonce}).equals(signature);
        }
        catch (Exception e) {
            this.log.error("Checking signature failed, and the reason is :" + e.getMessage());
            return false;
        }
    }

    @Override
    public String getComponentAccessToken(boolean forceRefresh) throws WxErrorException {
        if (this.getWxOpenConfigStorage().isComponentAccessTokenExpired() || forceRefresh) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("component_appid", this.getWxOpenConfigStorage().getComponentAppId());
            jsonObject.addProperty("component_appsecret", this.getWxOpenConfigStorage().getComponentAppSecret());
            jsonObject.addProperty("component_verify_ticket", this.getWxOpenConfigStorage().getComponentVerifyTicket());
            String responseContent = this.getWxOpenService().post("https://api.weixin.qq.com/cgi-bin/component/api_component_token", jsonObject.toString());
            WxOpenComponentAccessToken componentAccessToken = WxOpenComponentAccessToken.fromJson(responseContent);
            this.getWxOpenConfigStorage().updateComponentAccessToken(componentAccessToken);
        }
        return this.getWxOpenConfigStorage().getComponentAccessToken();
    }

    @Override
    public String post(String uri, String postData) throws WxErrorException {
        return this.post(uri, postData, "component_access_token");
    }

    @Override
    public String post(String uri, String postData, String accessTokenKey) throws WxErrorException {
        String componentAccessToken = this.getComponentAccessToken(false);
        String uriWithComponentAccessToken = uri + (uri.contains("?") ? "&" : "?") + accessTokenKey + "=" + componentAccessToken;
        try {
            return this.getWxOpenService().post(uriWithComponentAccessToken, postData);
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (error.getErrorCode() == 42001 || error.getErrorCode() == 40001 || error.getErrorCode() == 40014) {
                this.getWxOpenConfigStorage().expireComponentAccessToken();
                if (this.getWxOpenConfigStorage().autoRefreshToken()) {
                    return this.post(uri, postData, accessTokenKey);
                }
            }
            if (error.getErrorCode() != 0) {
                throw new WxErrorException(error, (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public String get(String uri) throws WxErrorException {
        return this.get(uri, "component_access_token");
    }

    @Override
    public String get(String uri, String accessTokenKey) throws WxErrorException {
        String componentAccessToken = this.getComponentAccessToken(false);
        String uriWithComponentAccessToken = uri + (uri.contains("?") ? "&" : "?") + accessTokenKey + "=" + componentAccessToken;
        try {
            return this.getWxOpenService().get(uriWithComponentAccessToken, null);
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (error.getErrorCode() == 42001 || error.getErrorCode() == 40001 || error.getErrorCode() == 40014) {
                this.getWxOpenConfigStorage().expireComponentAccessToken();
                if (this.getWxOpenConfigStorage().autoRefreshToken()) {
                    return this.get(uri, accessTokenKey);
                }
            }
            if (error.getErrorCode() != 0) {
                throw new WxErrorException(error, (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public String getPreAuthUrl(String redirectUri) throws WxErrorException {
        return this.getPreAuthUrl(redirectUri, null, null);
    }

    @Override
    public String getPreAuthUrl(String redirectURI, String authType, String bizAppid) throws WxErrorException {
        return this.createPreAuthUrl(redirectURI, authType, bizAppid, false);
    }

    @Override
    public String getMobilePreAuthUrl(String redirectURI) throws WxErrorException {
        return this.getMobilePreAuthUrl(redirectURI, null, null);
    }

    @Override
    public String getMobilePreAuthUrl(String redirectURI, String authType, String bizAppid) throws WxErrorException {
        return this.createPreAuthUrl(redirectURI, authType, bizAppid, true);
    }

    private String createPreAuthUrl(String redirectURI, String authType, String bizAppid, boolean isMobile) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("component_appid", this.getWxOpenConfigStorage().getComponentAppId());
        String responseContent = this.post("https://api.weixin.qq.com/cgi-bin/component/api_create_preauthcode", jsonObject.toString());
        jsonObject = (JsonObject)WxGsonBuilder.create().fromJson(responseContent, JsonObject.class);
        StringBuilder preAuthUrl = new StringBuilder(String.format(isMobile ? "https://mp.weixin.qq.com/safe/bindcomponent?action=bindcomponent&no_scan=1&auth_type=3&component_appid=%s&pre_auth_code=%s&redirect_uri=%s&auth_type=xxx&biz_appid=xxx#wechat_redirect" : "https://mp.weixin.qq.com/cgi-bin/componentloginpage?component_appid=%s&pre_auth_code=%s&redirect_uri=%s&auth_type=xxx&biz_appid=xxx", this.getWxOpenConfigStorage().getComponentAppId(), jsonObject.get("pre_auth_code").getAsString(), URIUtil.encodeURIComponent((String)redirectURI)));
        String preAuthUrlStr = preAuthUrl.toString();
        preAuthUrlStr = StringUtils.isNotEmpty((CharSequence)authType) ? preAuthUrlStr.replace("&auth_type=xxx", "&auth_type=" + authType) : preAuthUrlStr.replace("&auth_type=xxx", "");
        preAuthUrlStr = StringUtils.isNotEmpty((CharSequence)bizAppid) ? preAuthUrlStr.replace("&biz_appid=xxx", "&biz_appid=" + bizAppid) : preAuthUrlStr.replace("&biz_appid=xxx", "");
        return preAuthUrlStr;
    }

    @Override
    public String route(WxOpenXmlMessage wxMessage) throws WxErrorException {
        if (wxMessage == null) {
            throw new NullPointerException("message is empty");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)wxMessage.getInfoType(), (CharSequence)"component_verify_ticket")) {
            this.getWxOpenConfigStorage().setComponentVerifyTicket(wxMessage.getComponentVerifyTicket());
            return "success";
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)wxMessage.getInfoType(), (CharSequence[])new CharSequence[]{"authorized", "updateauthorized"})) {
            WxOpenQueryAuthResult queryAuth = this.wxOpenService.getWxOpenComponentService().getQueryAuth(wxMessage.getAuthorizationCode());
            if (queryAuth == null || queryAuth.getAuthorizationInfo() == null || queryAuth.getAuthorizationInfo().getAuthorizerAppid() == null) {
                throw new NullPointerException("getQueryAuth");
            }
            return "success";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)wxMessage.getInfoType(), (CharSequence)"notify_third_fasteregister") && wxMessage.getStatus() == 0) {
            WxOpenQueryAuthResult queryAuth = this.wxOpenService.getWxOpenComponentService().getQueryAuth(wxMessage.getAuthCode());
            if (queryAuth == null || queryAuth.getAuthorizationInfo() == null || queryAuth.getAuthorizationInfo().getAuthorizerAppid() == null) {
                throw new NullPointerException("getQueryAuth");
            }
            return "success";
        }
        return "";
    }

    @Override
    public WxOpenQueryAuthResult getQueryAuth(String authorizationCode) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("component_appid", this.getWxOpenConfigStorage().getComponentAppId());
        jsonObject.addProperty("authorization_code", authorizationCode);
        String responseContent = this.post("https://api.weixin.qq.com/cgi-bin/component/api_query_auth", jsonObject.toString());
        WxOpenQueryAuthResult queryAuth = (WxOpenQueryAuthResult)WxOpenGsonBuilder.create().fromJson(responseContent, WxOpenQueryAuthResult.class);
        if (queryAuth == null || queryAuth.getAuthorizationInfo() == null) {
            return queryAuth;
        }
        WxOpenAuthorizationInfo authorizationInfo = queryAuth.getAuthorizationInfo();
        if (authorizationInfo.getAuthorizerAccessToken() != null) {
            this.getWxOpenConfigStorage().updateAuthorizerAccessToken(authorizationInfo.getAuthorizerAppid(), authorizationInfo.getAuthorizerAccessToken(), authorizationInfo.getExpiresIn());
        }
        if (authorizationInfo.getAuthorizerRefreshToken() != null) {
            this.getWxOpenConfigStorage().setAuthorizerRefreshToken(authorizationInfo.getAuthorizerAppid(), authorizationInfo.getAuthorizerRefreshToken());
        }
        return queryAuth;
    }

    @Override
    public WxOpenAuthorizerInfoResult getAuthorizerInfo(String authorizerAppid) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("component_appid", this.getWxOpenConfigStorage().getComponentAppId());
        jsonObject.addProperty("authorizer_appid", authorizerAppid);
        String responseContent = this.post("https://api.weixin.qq.com/cgi-bin/component/api_get_authorizer_info", jsonObject.toString());
        return (WxOpenAuthorizerInfoResult)WxOpenGsonBuilder.create().fromJson(responseContent, WxOpenAuthorizerInfoResult.class);
    }

    @Override
    public WxOpenAuthorizerListResult getAuthorizerList(int begin, int len) throws WxErrorException {
        String url = String.format("https://api.weixin.qq.com/cgi-bin/component/api_get_authorizer_list?component_access_token=%s", this.getComponentAccessToken(false));
        begin = begin < 0 ? 0 : begin;
        len = len == 0 ? 10 : len;
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("component_appid", this.getWxOpenConfigStorage().getComponentAppId());
        jsonObject.addProperty("offset", (Number)begin);
        jsonObject.addProperty("count", (Number)len);
        String responseContent = this.post(url, jsonObject.toString());
        WxOpenAuthorizerListResult ret = (WxOpenAuthorizerListResult)WxOpenGsonBuilder.create().fromJson(responseContent, WxOpenAuthorizerListResult.class);
        if (ret != null && ret.getList() != null) {
            for (Map<String, String> data : ret.getList()) {
                String authorizerAppid = data.get("authorizer_appid");
                String refreshToken = data.get("refresh_token");
                if (authorizerAppid == null || refreshToken == null) continue;
                this.getWxOpenConfigStorage().setAuthorizerRefreshToken(authorizerAppid, refreshToken);
            }
        }
        return ret;
    }

    @Override
    public WxOpenAuthorizerOptionResult getAuthorizerOption(String authorizerAppid, String optionName) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("component_appid", this.getWxOpenConfigStorage().getComponentAppId());
        jsonObject.addProperty("authorizer_appid", authorizerAppid);
        jsonObject.addProperty("option_name", optionName);
        String responseContent = this.post("https://api.weixin.qq.com/cgi-bin/component/api_get_authorizer_option", jsonObject.toString());
        return (WxOpenAuthorizerOptionResult)WxOpenGsonBuilder.create().fromJson(responseContent, WxOpenAuthorizerOptionResult.class);
    }

    @Override
    public void setAuthorizerOption(String authorizerAppid, String optionName, String optionValue) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("component_appid", this.getWxOpenConfigStorage().getComponentAppId());
        jsonObject.addProperty("authorizer_appid", authorizerAppid);
        jsonObject.addProperty("option_name", optionName);
        jsonObject.addProperty("option_value", optionValue);
        this.post("https://api.weixin.qq.com/cgi-bin/component/api_set_authorizer_option", jsonObject.toString());
    }

    @Override
    public String getAuthorizerAccessToken(String appId, boolean forceRefresh) throws WxErrorException {
        if (this.getWxOpenConfigStorage().isAuthorizerAccessTokenExpired(appId) || forceRefresh) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("component_appid", this.getWxOpenConfigStorage().getComponentAppId());
            jsonObject.addProperty("authorizer_appid", appId);
            jsonObject.addProperty("authorizer_refresh_token", this.getWxOpenConfigStorage().getAuthorizerRefreshToken(appId));
            String responseContent = this.post("https://api.weixin.qq.com/cgi-bin/component/api_authorizer_token", jsonObject.toString());
            WxOpenAuthorizerAccessToken wxOpenAuthorizerAccessToken = WxOpenAuthorizerAccessToken.fromJson(responseContent);
            this.getWxOpenConfigStorage().updateAuthorizerAccessToken(appId, wxOpenAuthorizerAccessToken);
        }
        return this.getWxOpenConfigStorage().getAuthorizerAccessToken(appId);
    }

    @Override
    public WxMpOAuth2AccessToken oauth2getAccessToken(String appId, String code) throws WxErrorException {
        String url = String.format("https://api.weixin.qq.com/sns/oauth2/component/access_token?appid=%s&code=%s&grant_type=authorization_code&component_appid=%s", appId, code, this.getWxOpenConfigStorage().getComponentAppId());
        String responseContent = this.get(url);
        return WxMpOAuth2AccessToken.fromJson((String)responseContent);
    }

    @Override
    public boolean checkSignature(String appid, String timestamp, String nonce, String signature) {
        return false;
    }

    @Override
    public WxMpOAuth2AccessToken oauth2refreshAccessToken(String appId, String refreshToken) throws WxErrorException {
        String url = String.format("https://api.weixin.qq.com/sns/oauth2/component/refresh_token?appid=%s&grant_type=refresh_token&refresh_token=%s&component_appid=%s", appId, refreshToken, this.getWxOpenConfigStorage().getComponentAppId());
        String responseContent = this.get(url);
        return WxMpOAuth2AccessToken.fromJson((String)responseContent);
    }

    @Override
    public String oauth2buildAuthorizationUrl(String appId, String redirectURI, String scope, String state) {
        return String.format("https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=%s&component_appid=%s#wechat_redirect", appId, URIUtil.encodeURIComponent((String)redirectURI), scope, StringUtils.trimToEmpty((String)state), this.getWxOpenConfigStorage().getComponentAppId());
    }

    @Override
    public WxMaJscode2SessionResult miniappJscode2Session(String appId, String jsCode) throws WxErrorException {
        String url = String.format("https://api.weixin.qq.com/sns/component/jscode2session?appid=%s&js_code=%s&grant_type=authorization_code&component_appid=%s", appId, jsCode, this.getWxOpenConfigStorage().getComponentAppId());
        String responseContent = this.get(url);
        return WxMaJscode2SessionResult.fromJson((String)responseContent);
    }

    @Override
    public List<WxOpenMaCodeTemplate> getTemplateDraftList() throws WxErrorException {
        String responseContent = this.get("https://api.weixin.qq.com/wxa/gettemplatedraftlist", "access_token");
        JsonObject response = JSON_PARSER.parse(StringUtils.defaultString((String)responseContent, (String)"{}")).getAsJsonObject();
        boolean hasDraftList = response.has("draft_list");
        if (hasDraftList) {
            return (List)WxOpenGsonBuilder.create().fromJson((JsonElement)response.getAsJsonArray("draft_list"), new TypeToken<List<WxOpenMaCodeTemplate>>(){}.getType());
        }
        return null;
    }

    @Override
    public List<WxOpenMaCodeTemplate> getTemplateList() throws WxErrorException {
        String responseContent = this.get("https://api.weixin.qq.com/wxa/gettemplatelist", "access_token");
        JsonObject response = JSON_PARSER.parse(StringUtils.defaultString((String)responseContent, (String)"{}")).getAsJsonObject();
        boolean hasDraftList = response.has("template_list");
        if (hasDraftList) {
            return (List)WxOpenGsonBuilder.create().fromJson((JsonElement)response.getAsJsonArray("template_list"), new TypeToken<List<WxOpenMaCodeTemplate>>(){}.getType());
        }
        return null;
    }

    @Override
    public void addToTemplate(long draftId) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("draft_id", (Number)draftId);
        this.post("https://api.weixin.qq.com/wxa/addtotemplate", param.toString(), "access_token");
    }

    @Override
    public void deleteTemplate(long templateId) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("template_id", (Number)templateId);
        this.post("https://api.weixin.qq.com/wxa/deletetemplate", param.toString(), "access_token");
    }

    @Override
    public WxOpenCreateResult createOpenAccount(String appId) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("appid", appId);
        String json = this.post("https://api.weixin.qq.com/cgi-bin/open/create", param.toString(), "access_token");
        return WxOpenCreateResult.fromJson(json);
    }

    @Override
    public WxOpenResult fastRegisterWeapp(String name, String code, String codeType, String legalPersonaWechat, String legalPersonaName, String componentPhone) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", name);
        jsonObject.addProperty("code", code);
        jsonObject.addProperty("code_type", codeType);
        jsonObject.addProperty("legal_persona_wechat", legalPersonaWechat);
        jsonObject.addProperty("legal_persona_name", legalPersonaName);
        jsonObject.addProperty("component_phone", componentPhone);
        String response = this.post("https://api.weixin.qq.com/cgi-bin/component/fastregisterweapp?action=create", jsonObject.toString(), "component_access_token");
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenResult fastRegisterWeappSearch(String name, String legalPersonaWechat, String legalPersonaName) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", name);
        jsonObject.addProperty("legal_persona_wechat", legalPersonaWechat);
        jsonObject.addProperty("legal_persona_name", legalPersonaName);
        String response = this.post("https://api.weixin.qq.com/cgi-bin/component/fastregisterweapp?action=search", jsonObject.toString(), "component_access_token");
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }
}

