/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.api.impl;

import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.open.api.WxOpenComponentService;

public class WxOpenMpServiceImpl
extends WxMpServiceImpl {
    private WxOpenComponentService wxOpenComponentService;
    private WxMpConfigStorage wxMpConfigStorage;
    private String appId;

    public WxOpenMpServiceImpl(WxOpenComponentService wxOpenComponentService, String appId, WxMpConfigStorage wxMpConfigStorage) {
        this.wxOpenComponentService = wxOpenComponentService;
        this.appId = appId;
        this.wxMpConfigStorage = wxMpConfigStorage;
        this.initHttp();
    }

    public WxMpConfigStorage getWxMpConfigStorage() {
        return this.wxMpConfigStorage;
    }

    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        return this.wxOpenComponentService.getAuthorizerAccessToken(this.appId, forceRefresh);
    }

    public WxMpOAuth2AccessToken oauth2getAccessToken(String code) throws WxErrorException {
        return this.wxOpenComponentService.oauth2getAccessToken(this.appId, code);
    }

    public WxMpOAuth2AccessToken oauth2refreshAccessToken(String refreshToken) throws WxErrorException {
        return this.wxOpenComponentService.oauth2refreshAccessToken(this.appId, refreshToken);
    }

    public String oauth2buildAuthorizationUrl(String redirectURI, String scope, String state) {
        return this.wxOpenComponentService.oauth2buildAuthorizationUrl(this.appId, redirectURI, scope, state);
    }
}

