/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.impl.WxPayServiceAbstractImpl;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.SSLContext;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.ProxyInfo;
import jodd.http.net.SSLSocketHttpConnectionProvider;
import jodd.http.net.SocketHttpConnectionProvider;
import org.apache.commons.lang3.StringUtils;

public class WxPayServiceJoddHttpImpl
extends WxPayServiceAbstractImpl {
    @Override
    protected String post(String url, String requestStr, boolean useKey) throws WxPayException {
        try {
            SSLSocketHttpConnectionProvider provider;
            HttpRequest request = (HttpRequest)HttpRequest.post((String)url).timeout(this.config.getHttpTimeout()).connectionTimeout(this.config.getHttpConnectionTimeout()).bodyText(requestStr);
            if (useKey) {
                SSLContext sslContext = this.getConfig().getSslContext();
                if (null == sslContext) {
                    sslContext = this.getConfig().initSSLContext();
                }
                provider = new SSLSocketHttpConnectionProvider(sslContext);
                request.withConnectionProvider((HttpConnectionProvider)provider);
            }
            if (StringUtils.isNotBlank((CharSequence)this.config.getHttpProxyHost()) && this.config.getHttpProxyPort() > 0) {
                ProxyInfo httpProxy = new ProxyInfo(ProxyInfo.ProxyType.HTTP, this.config.getHttpProxyHost(), this.config.getHttpProxyPort().intValue(), this.config.getHttpProxyUsername(), this.config.getHttpProxyPassword());
                provider = request.connectionProvider();
                if (null == provider) {
                    provider = new SocketHttpConnectionProvider();
                }
                provider.useProxy(httpProxy);
                request.withConnectionProvider((HttpConnectionProvider)provider);
            }
            String responseString = this.getResponseString(request.send());
            this.log.info("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{url, requestStr, responseString});
            return responseString;
        }
        catch (Exception e) {
            this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{url, requestStr, e.getMessage()});
            throw new WxPayException(e.getMessage(), e);
        }
    }

    private String getResponseString(HttpResponse response) throws WxPayException {
        try {
            this.log.debug("\u3010\u5fae\u4fe1\u670d\u52a1\u5668\u54cd\u5e94\u5934\u4fe1\u606f\u3011\uff1a\n{}", (Object)response.toString(false));
        }
        catch (NullPointerException e) {
            throw new WxPayException("response.toString() \u5c45\u7136\u629b\u51fa\u7a7a\u6307\u9488\u5f02\u5e38\u4e86", e);
        }
        String responseString = response.bodyText();
        if (StringUtils.isBlank((CharSequence)responseString)) {
            throw new WxPayException("\u54cd\u5e94\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)response.charset())) {
            responseString = new String(responseString.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        }
        return responseString;
    }
}

