/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.result;

import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import org.w3c.dom.Document;

@XStreamAlias(value="xml")
public class WxPaySendRedpackResult
extends BaseWxPayResult
implements Serializable {
    private static final long serialVersionUID = -4837415036337132073L;
    private static final String PROCESSING = "PROCESSING";
    @XStreamAlias(value="mch_billno")
    private String mchBillNo;
    @XStreamAlias(value="wxappid")
    private String wxAppId;
    @XStreamAlias(value="re_openid")
    private String reOpenid;
    @XStreamAlias(value="total_amount")
    private Integer totalAmount;
    @XStreamAlias(value="send_time")
    private String sendTime;
    @XStreamAlias(value="send_listid")
    private String sendListId;

    @Override
    protected void loadXml(Document d) {
        this.mchBillNo = WxPaySendRedpackResult.readXmlString(d, "mch_billno");
        this.wxAppId = WxPaySendRedpackResult.readXmlString(d, "wxappid");
        this.reOpenid = WxPaySendRedpackResult.readXmlString(d, "re_openid");
        this.totalAmount = WxPaySendRedpackResult.readXmlInteger(d, "total_amount");
        this.sendTime = WxPaySendRedpackResult.readXmlString(d, "send_time");
        this.sendListId = WxPaySendRedpackResult.readXmlString(d, "send_listid");
    }

    @Override
    public void checkResult(WxPayService wxPayService, String signType, boolean checkSuccess) throws WxPayException {
        block2: {
            try {
                super.checkResult(wxPayService, signType, checkSuccess);
            }
            catch (WxPayException e) {
                if (PROCESSING.equals(e.getErrCode())) break block2;
                throw e;
            }
        }
    }

    public String getMchBillNo() {
        return this.mchBillNo;
    }

    public String getWxAppId() {
        return this.wxAppId;
    }

    public String getReOpenid() {
        return this.reOpenid;
    }

    public Integer getTotalAmount() {
        return this.totalAmount;
    }

    public String getSendTime() {
        return this.sendTime;
    }

    public String getSendListId() {
        return this.sendListId;
    }

    public void setMchBillNo(String mchBillNo) {
        this.mchBillNo = mchBillNo;
    }

    public void setWxAppId(String wxAppId) {
        this.wxAppId = wxAppId;
    }

    public void setReOpenid(String reOpenid) {
        this.reOpenid = reOpenid;
    }

    public void setTotalAmount(Integer totalAmount) {
        this.totalAmount = totalAmount;
    }

    public void setSendTime(String sendTime) {
        this.sendTime = sendTime;
    }

    public void setSendListId(String sendListId) {
        this.sendListId = sendListId;
    }

    @Override
    public String toString() {
        return "WxPaySendRedpackResult(mchBillNo=" + this.getMchBillNo() + ", wxAppId=" + this.getWxAppId() + ", reOpenid=" + this.getReOpenid() + ", totalAmount=" + this.getTotalAmount() + ", sendTime=" + this.getSendTime() + ", sendListId=" + this.getSendListId() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxPaySendRedpackResult)) {
            return false;
        }
        WxPaySendRedpackResult other = (WxPaySendRedpackResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$mchBillNo = this.getMchBillNo();
        String other$mchBillNo = other.getMchBillNo();
        if (this$mchBillNo == null ? other$mchBillNo != null : !this$mchBillNo.equals(other$mchBillNo)) {
            return false;
        }
        String this$wxAppId = this.getWxAppId();
        String other$wxAppId = other.getWxAppId();
        if (this$wxAppId == null ? other$wxAppId != null : !this$wxAppId.equals(other$wxAppId)) {
            return false;
        }
        String this$reOpenid = this.getReOpenid();
        String other$reOpenid = other.getReOpenid();
        if (this$reOpenid == null ? other$reOpenid != null : !this$reOpenid.equals(other$reOpenid)) {
            return false;
        }
        Integer this$totalAmount = this.getTotalAmount();
        Integer other$totalAmount = other.getTotalAmount();
        if (this$totalAmount == null ? other$totalAmount != null : !((Object)this$totalAmount).equals(other$totalAmount)) {
            return false;
        }
        String this$sendTime = this.getSendTime();
        String other$sendTime = other.getSendTime();
        if (this$sendTime == null ? other$sendTime != null : !this$sendTime.equals(other$sendTime)) {
            return false;
        }
        String this$sendListId = this.getSendListId();
        String other$sendListId = other.getSendListId();
        return !(this$sendListId == null ? other$sendListId != null : !this$sendListId.equals(other$sendListId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WxPaySendRedpackResult;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $mchBillNo = this.getMchBillNo();
        result = result * 59 + ($mchBillNo == null ? 43 : $mchBillNo.hashCode());
        String $wxAppId = this.getWxAppId();
        result = result * 59 + ($wxAppId == null ? 43 : $wxAppId.hashCode());
        String $reOpenid = this.getReOpenid();
        result = result * 59 + ($reOpenid == null ? 43 : $reOpenid.hashCode());
        Integer $totalAmount = this.getTotalAmount();
        result = result * 59 + ($totalAmount == null ? 43 : ((Object)$totalAmount).hashCode());
        String $sendTime = this.getSendTime();
        result = result * 59 + ($sendTime == null ? 43 : $sendTime.hashCode());
        String $sendListId = this.getSendListId();
        result = result * 59 + ($sendListId == null ? 43 : $sendListId.hashCode());
        return result;
    }
}

