/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.result;

import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.util.SignUtils;
import com.github.binarywang.wxpay.util.XmlConfig;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.common.util.xml.XStreamInitializer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseWxPayResult {
    @XStreamAlias(value="return_code")
    protected String returnCode;
    @XStreamAlias(value="return_msg")
    protected String returnMsg;
    @XStreamAlias(value="result_code")
    private String resultCode;
    @XStreamAlias(value="err_code")
    private String errCode;
    @XStreamAlias(value="error_code")
    private String errorCode;
    @XStreamAlias(value="err_code_des")
    private String errCodeDes;
    @XStreamAlias(value="appid")
    private String appid;
    @XStreamAlias(value="mch_id")
    private String mchId;
    @XStreamAlias(value="sub_appid")
    private String subAppId;
    @XStreamAlias(value="sub_mch_id")
    private String subMchId;
    @XStreamAlias(value="nonce_str")
    private String nonceStr;
    @XStreamAlias(value="sign")
    private String sign;
    private String xmlString;
    private transient Document xmlDoc;

    public static String fenToYuan(Integer fen) {
        return BigDecimal.valueOf(Double.valueOf(fen.intValue()) / 100.0).setScale(2, 4).toPlainString();
    }

    public static <T extends BaseWxPayResult> T fromXML(String xmlString, Class<T> clz) {
        if (XmlConfig.fastMode) {
            try {
                BaseWxPayResult t = (BaseWxPayResult)clz.newInstance();
                t.setXmlString(xmlString);
                Document doc = t.getXmlDoc();
                t.loadBasicXML(doc);
                t.loadXml(doc);
                return (T)t;
            }
            catch (Exception e) {
                throw new WxRuntimeException("parse xml error", (Throwable)e);
            }
        }
        XStream xstream = XStreamInitializer.getInstance();
        xstream.processAnnotations(clz);
        xstream.setClassLoader(BaseWxPayResult.class.getClassLoader());
        BaseWxPayResult result = (BaseWxPayResult)xstream.fromXML(xmlString);
        result.setXmlString(xmlString);
        return (T)result;
    }

    protected abstract void loadXml(Document var1);

    private void loadBasicXML(Document d) {
        this.returnCode = BaseWxPayResult.readXmlString(d, "return_code");
        this.returnMsg = BaseWxPayResult.readXmlString(d, "return_msg");
        this.resultCode = BaseWxPayResult.readXmlString(d, "result_code");
        this.errCode = BaseWxPayResult.readXmlString(d, "err_code");
        this.errorCode = BaseWxPayResult.readXmlString(d, "error_code");
        this.errCodeDes = BaseWxPayResult.readXmlString(d, "err_code_des");
        this.appid = BaseWxPayResult.readXmlString(d, "appid");
        this.mchId = BaseWxPayResult.readXmlString(d, "mch_id");
        this.subAppId = BaseWxPayResult.readXmlString(d, "sub_appid");
        this.subMchId = BaseWxPayResult.readXmlString(d, "sub_mch_id");
        this.nonceStr = BaseWxPayResult.readXmlString(d, "nonce_str");
        this.sign = BaseWxPayResult.readXmlString(d, "sign");
    }

    protected static Integer readXmlInteger(Node d, String tagName) {
        String content = BaseWxPayResult.readXmlString(d, tagName);
        if (content == null || content.trim().length() == 0) {
            return null;
        }
        return Integer.parseInt(content);
    }

    protected static String readXmlString(Node d, String tagName) {
        if (!d.hasChildNodes()) {
            return null;
        }
        NodeList childNodes = d.getChildNodes();
        int j = childNodes.getLength();
        for (int i = 0; i < j; ++i) {
            Node node = childNodes.item(i);
            if (!tagName.equals(node.getNodeName())) continue;
            if (!node.hasChildNodes()) {
                return null;
            }
            return node.getFirstChild().getNodeValue();
        }
        return null;
    }

    public static String readXmlString(Document d, String tagName) {
        NodeList elements = d.getElementsByTagName(tagName);
        if (elements == null || elements.getLength() == 0) {
            return null;
        }
        Node node = elements.item(0).getFirstChild();
        if (node == null) {
            return null;
        }
        return node.getNodeValue();
    }

    protected static Integer readXmlInteger(Document d, String tagName) {
        String content = BaseWxPayResult.readXmlString(d, tagName);
        if (content == null || content.trim().length() == 0) {
            return null;
        }
        return Integer.parseInt(content);
    }

    protected static Long readXmlLong(Document d, String tagName) {
        String content = BaseWxPayResult.readXmlString(d, tagName);
        if (content == null || content.trim().length() == 0) {
            return null;
        }
        return Long.parseLong(content);
    }

    protected Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    public String toString() {
        return WxGsonBuilder.create().toJson((Object)this);
    }

    public Map<String, String> toMap() {
        if (StringUtils.isBlank((CharSequence)this.xmlString)) {
            throw new WxRuntimeException("xml\u6570\u636e\u6709\u95ee\u9898\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        HashMap result = Maps.newHashMap();
        Document doc = this.getXmlDoc();
        try {
            NodeList list = (NodeList)XPathFactory.newInstance().newXPath().compile("/xml/*").evaluate(doc, XPathConstants.NODESET);
            int len = list.getLength();
            for (int i = 0; i < len; ++i) {
                result.put(list.item(i).getNodeName(), list.item(i).getTextContent());
            }
        }
        catch (XPathExpressionException e) {
            throw new WxRuntimeException("\u975e\u6cd5\u7684xml\u6587\u672c\u5185\u5bb9\uff1a" + this.xmlString);
        }
        return result;
    }

    private Document getXmlDoc() {
        if (this.xmlDoc != null) {
            return this.xmlDoc;
        }
        this.xmlDoc = this.openXML(this.xmlString);
        return this.xmlDoc;
    }

    protected Document openXML(String content) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setExpandEntityReferences(false);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            return factory.newDocumentBuilder().parse(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            throw new WxRuntimeException("\u975e\u6cd5\u7684xml\u6587\u672c\u5185\u5bb9\uff1a\n" + this.xmlString, (Throwable)e);
        }
    }

    protected String getXmlValue(String ... path) {
        Document doc = this.getXmlDoc();
        String expression = String.format("/%s//text()", Joiner.on((String)"/").join((Object[])path));
        try {
            return (String)XPathFactory.newInstance().newXPath().compile(expression).evaluate(doc, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            throw new WxRuntimeException("\u672a\u627e\u5230\u76f8\u5e94\u8def\u5f84\u7684\u6587\u672c\uff1a" + expression);
        }
    }

    protected Integer getXmlValueAsInt(String ... path) {
        String result = this.getXmlValue(path);
        if (StringUtils.isBlank((CharSequence)result)) {
            return null;
        }
        return Integer.valueOf(result);
    }

    public void checkResult(WxPayService wxPayService, String signType, boolean checkSuccess) throws WxPayException {
        ArrayList successStrings;
        Map<String, String> map = this.toMap();
        if (this.getSign() != null && !SignUtils.checkSign(map, signType, wxPayService.getConfig().getMchKey())) {
            this.getLogger().debug("\u6821\u9a8c\u7ed3\u679c\u7b7e\u540d\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}", map);
            throw new WxPayException("\u53c2\u6570\u683c\u5f0f\u6821\u9a8c\u9519\u8bef\uff01");
        }
        if (!(!checkSuccess || (successStrings = Lists.newArrayList((Object[])new String[]{"SUCCESS", ""})).contains(StringUtils.trimToEmpty((String)this.getReturnCode()).toUpperCase()) && successStrings.contains(StringUtils.trimToEmpty((String)this.getResultCode()).toUpperCase()))) {
            StringBuilder errorMsg = new StringBuilder();
            if (this.getReturnCode() != null) {
                errorMsg.append("\u8fd4\u56de\u4ee3\u7801\uff1a").append(this.getReturnCode());
            }
            if (this.getReturnMsg() != null) {
                errorMsg.append("\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a").append(this.getReturnMsg());
            }
            if (this.getResultCode() != null) {
                errorMsg.append("\uff0c\u7ed3\u679c\u4ee3\u7801\uff1a").append(this.getResultCode());
            }
            if (this.getErrCode() != null) {
                errorMsg.append("\uff0c\u9519\u8bef\u4ee3\u7801\uff1a").append(this.getErrCode());
            }
            if (this.getErrorCode() != null) {
                errorMsg.append("\uff0c\u9519\u8bef\u4ee3\u7801\uff1a").append(this.getErrorCode());
            }
            if (this.getErrCodeDes() != null) {
                errorMsg.append("\uff0c\u9519\u8bef\u8be6\u60c5\uff1a").append(this.getErrCodeDes());
            }
            this.getLogger().error("\n\u7ed3\u679c\u4e1a\u52a1\u4ee3\u7801\u5f02\u5e38\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{},\n{}", map, (Object)errorMsg.toString());
            throw WxPayException.from(this);
        }
    }

    public String getReturnCode() {
        return this.returnCode;
    }

    public String getReturnMsg() {
        return this.returnMsg;
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrCodeDes() {
        return this.errCodeDes;
    }

    public String getAppid() {
        return this.appid;
    }

    public String getMchId() {
        return this.mchId;
    }

    public String getSubAppId() {
        return this.subAppId;
    }

    public String getSubMchId() {
        return this.subMchId;
    }

    public String getNonceStr() {
        return this.nonceStr;
    }

    public String getSign() {
        return this.sign;
    }

    public String getXmlString() {
        return this.xmlString;
    }

    public void setReturnCode(String returnCode) {
        this.returnCode = returnCode;
    }

    public void setReturnMsg(String returnMsg) {
        this.returnMsg = returnMsg;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrCodeDes(String errCodeDes) {
        this.errCodeDes = errCodeDes;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public void setSubAppId(String subAppId) {
        this.subAppId = subAppId;
    }

    public void setSubMchId(String subMchId) {
        this.subMchId = subMchId;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public void setXmlString(String xmlString) {
        this.xmlString = xmlString;
    }

    public void setXmlDoc(Document xmlDoc) {
        this.xmlDoc = xmlDoc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseWxPayResult)) {
            return false;
        }
        BaseWxPayResult other = (BaseWxPayResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$returnCode = this.getReturnCode();
        String other$returnCode = other.getReturnCode();
        if (this$returnCode == null ? other$returnCode != null : !this$returnCode.equals(other$returnCode)) {
            return false;
        }
        String this$returnMsg = this.getReturnMsg();
        String other$returnMsg = other.getReturnMsg();
        if (this$returnMsg == null ? other$returnMsg != null : !this$returnMsg.equals(other$returnMsg)) {
            return false;
        }
        String this$resultCode = this.getResultCode();
        String other$resultCode = other.getResultCode();
        if (this$resultCode == null ? other$resultCode != null : !this$resultCode.equals(other$resultCode)) {
            return false;
        }
        String this$errCode = this.getErrCode();
        String other$errCode = other.getErrCode();
        if (this$errCode == null ? other$errCode != null : !this$errCode.equals(other$errCode)) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        String this$errCodeDes = this.getErrCodeDes();
        String other$errCodeDes = other.getErrCodeDes();
        if (this$errCodeDes == null ? other$errCodeDes != null : !this$errCodeDes.equals(other$errCodeDes)) {
            return false;
        }
        String this$appid = this.getAppid();
        String other$appid = other.getAppid();
        if (this$appid == null ? other$appid != null : !this$appid.equals(other$appid)) {
            return false;
        }
        String this$mchId = this.getMchId();
        String other$mchId = other.getMchId();
        if (this$mchId == null ? other$mchId != null : !this$mchId.equals(other$mchId)) {
            return false;
        }
        String this$subAppId = this.getSubAppId();
        String other$subAppId = other.getSubAppId();
        if (this$subAppId == null ? other$subAppId != null : !this$subAppId.equals(other$subAppId)) {
            return false;
        }
        String this$subMchId = this.getSubMchId();
        String other$subMchId = other.getSubMchId();
        if (this$subMchId == null ? other$subMchId != null : !this$subMchId.equals(other$subMchId)) {
            return false;
        }
        String this$nonceStr = this.getNonceStr();
        String other$nonceStr = other.getNonceStr();
        if (this$nonceStr == null ? other$nonceStr != null : !this$nonceStr.equals(other$nonceStr)) {
            return false;
        }
        String this$sign = this.getSign();
        String other$sign = other.getSign();
        if (this$sign == null ? other$sign != null : !this$sign.equals(other$sign)) {
            return false;
        }
        String this$xmlString = this.getXmlString();
        String other$xmlString = other.getXmlString();
        return !(this$xmlString == null ? other$xmlString != null : !this$xmlString.equals(other$xmlString));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseWxPayResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $returnCode = this.getReturnCode();
        result = result * 59 + ($returnCode == null ? 43 : $returnCode.hashCode());
        String $returnMsg = this.getReturnMsg();
        result = result * 59 + ($returnMsg == null ? 43 : $returnMsg.hashCode());
        String $resultCode = this.getResultCode();
        result = result * 59 + ($resultCode == null ? 43 : $resultCode.hashCode());
        String $errCode = this.getErrCode();
        result = result * 59 + ($errCode == null ? 43 : $errCode.hashCode());
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        String $errCodeDes = this.getErrCodeDes();
        result = result * 59 + ($errCodeDes == null ? 43 : $errCodeDes.hashCode());
        String $appid = this.getAppid();
        result = result * 59 + ($appid == null ? 43 : $appid.hashCode());
        String $mchId = this.getMchId();
        result = result * 59 + ($mchId == null ? 43 : $mchId.hashCode());
        String $subAppId = this.getSubAppId();
        result = result * 59 + ($subAppId == null ? 43 : $subAppId.hashCode());
        String $subMchId = this.getSubMchId();
        result = result * 59 + ($subMchId == null ? 43 : $subMchId.hashCode());
        String $nonceStr = this.getNonceStr();
        result = result * 59 + ($nonceStr == null ? 43 : $nonceStr.hashCode());
        String $sign = this.getSign();
        result = result * 59 + ($sign == null ? 43 : $sign.hashCode());
        String $xmlString = this.getXmlString();
        result = result * 59 + ($xmlString == null ? 43 : $xmlString.hashCode());
        return result;
    }
}

