/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.complaint.ComplaintDetailRequest;
import com.github.binarywang.wxpay.bean.complaint.ComplaintDetailResult;
import com.github.binarywang.wxpay.bean.complaint.ComplaintNotifyUrlRequest;
import com.github.binarywang.wxpay.bean.complaint.ComplaintNotifyUrlResult;
import com.github.binarywang.wxpay.bean.complaint.ComplaintRequest;
import com.github.binarywang.wxpay.bean.complaint.ComplaintResult;
import com.github.binarywang.wxpay.bean.complaint.CompleteRequest;
import com.github.binarywang.wxpay.bean.complaint.NegotiationHistoryRequest;
import com.github.binarywang.wxpay.bean.complaint.NegotiationHistoryResult;
import com.github.binarywang.wxpay.bean.complaint.ResponseRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.ComplaintService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.v3.util.RsaCryptoUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import javax.crypto.BadPaddingException;

public class ComplaintServiceImpl
implements ComplaintService {
    private static final Gson GSON = new GsonBuilder().create();
    private final WxPayService payService;

    @Override
    public ComplaintResult queryComplaints(ComplaintRequest request) throws WxPayException, BadPaddingException {
        String url = String.format("%s/v3/merchant-service/complaints-v2?limit=%d&offset=%d&begin_date=%s&end_date=%s&complainted_mchid=%s", this.payService.getPayBaseUrl(), request.getLimit(), request.getOffset(), request.getBeginDate(), request.getEndDate(), request.getComplaintedMchid());
        String response = this.payService.getV3(url);
        ComplaintResult complaintResult = (ComplaintResult)GSON.fromJson(response, ComplaintResult.class);
        List<ComplaintDetailResult> data = complaintResult.getData();
        for (ComplaintDetailResult complaintDetailResult : data) {
            if (complaintDetailResult.getPayerPhone() == null) continue;
            String payerPhone = RsaCryptoUtil.decryptOAEP(complaintDetailResult.getPayerPhone(), this.payService.getConfig().getPrivateKey());
            complaintDetailResult.setPayerPhone(payerPhone);
        }
        return complaintResult;
    }

    @Override
    public ComplaintDetailResult getComplaint(ComplaintDetailRequest request) throws WxPayException, BadPaddingException {
        String url = String.format("%s/v3/merchant-service/complaints-v2/%s", this.payService.getPayBaseUrl(), request.getComplaintId());
        String response = this.payService.getV3(url);
        ComplaintDetailResult result = (ComplaintDetailResult)GSON.fromJson(response, ComplaintDetailResult.class);
        if (result.getPayerPhone() != null) {
            String payerPhone = RsaCryptoUtil.decryptOAEP(result.getPayerPhone(), this.payService.getConfig().getPrivateKey());
            result.setPayerPhone(payerPhone);
        }
        return result;
    }

    @Override
    public NegotiationHistoryResult queryNegotiationHistorys(NegotiationHistoryRequest request) throws WxPayException {
        String url = String.format("%s/v3/merchant-service/complaints-v2/%s/negotiation-historys?limit=%d&offset=%d", this.payService.getPayBaseUrl(), request.getComplaintId(), request.getLimit(), request.getOffset());
        String response = this.payService.getV3(url);
        return (NegotiationHistoryResult)GSON.fromJson(response, NegotiationHistoryResult.class);
    }

    @Override
    public ComplaintNotifyUrlResult addComplaintNotifyUrl(ComplaintNotifyUrlRequest request) throws WxPayException {
        String url = String.format("%s/v3/merchant-service/complaint-notifications", this.payService.getPayBaseUrl());
        String response = this.payService.postV3(url, GSON.toJson((Object)request));
        return (ComplaintNotifyUrlResult)GSON.fromJson(response, ComplaintNotifyUrlResult.class);
    }

    @Override
    public ComplaintNotifyUrlResult getComplaintNotifyUrl() throws WxPayException {
        String url = String.format("%s/v3/merchant-service/complaint-notifications", this.payService.getPayBaseUrl());
        String response = this.payService.getV3(url);
        return (ComplaintNotifyUrlResult)GSON.fromJson(response, ComplaintNotifyUrlResult.class);
    }

    @Override
    public ComplaintNotifyUrlResult updateComplaintNotifyUrl(ComplaintNotifyUrlRequest request) throws WxPayException {
        String url = String.format("%s/v3/merchant-service/complaint-notifications", this.payService.getPayBaseUrl());
        String response = this.payService.putV3(url, GSON.toJson((Object)request));
        return (ComplaintNotifyUrlResult)GSON.fromJson(response, ComplaintNotifyUrlResult.class);
    }

    @Override
    public void deleteComplaintNotifyUrl() throws WxPayException {
        String url = String.format("%s/v3/merchant-service/complaint-notifications", this.payService.getPayBaseUrl());
        this.payService.deleteV3(url);
    }

    @Override
    public void submitResponse(ResponseRequest request) throws WxPayException {
        String url = String.format("%s/v3/merchant-service/complaints-v2/%s/response", this.payService.getPayBaseUrl(), request.getComplaintId());
        request.setComplaintId(null);
        this.payService.postV3(url, GSON.toJson((Object)request));
    }

    @Override
    public void complete(CompleteRequest request) throws WxPayException {
        String url = String.format("%s/v3/merchant-service/complaints-v2/%s/complete", this.payService.getPayBaseUrl(), request.getComplaintId());
        request.setComplaintId(null);
        this.payService.postV3(url, GSON.toJson((Object)request));
    }

    public ComplaintServiceImpl(WxPayService payService) {
        this.payService = payService;
    }
}

