/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.DbxAppInfo;
import com.dropbox.core.json.JsonReadException;
import com.dropbox.core.json.JsonReader;
import com.dropbox.core.util.StringUtil;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public final class DbxAuthFinish {
    private final String accessToken;
    private final String userId;
    private final String urlState;
    public static final JsonReader<DbxAuthFinish> Reader = new JsonReader<DbxAuthFinish>(){

        @Override
        public DbxAuthFinish read(JsonParser parser) throws IOException, JsonReadException {
            JsonLocation top = JsonReader.expectObjectStart(parser);
            String accessToken = null;
            String tokenType = null;
            String userId = null;
            while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                String fieldName = parser.getCurrentName();
                JsonReader.nextToken(parser);
                try {
                    if (fieldName.equals("token_type")) {
                        tokenType = BearerTokenTypeReader.readField(parser, fieldName, tokenType);
                        continue;
                    }
                    if (fieldName.equals("access_token")) {
                        accessToken = AccessTokenReader.readField(parser, fieldName, accessToken);
                        continue;
                    }
                    if (fieldName.equals("uid")) {
                        userId = JsonReader.StringReader.readField(parser, fieldName, userId);
                        continue;
                    }
                    JsonReader.skipValue(parser);
                }
                catch (JsonReadException ex) {
                    throw ex.addFieldContext(fieldName);
                }
            }
            JsonReader.expectObjectEnd(parser);
            if (tokenType == null) {
                throw new JsonReadException("missing field \"token_type\"", top);
            }
            if (accessToken == null) {
                throw new JsonReadException("missing field \"access_token\"", top);
            }
            if (userId == null) {
                throw new JsonReadException("missing field \"uid\"", top);
            }
            return new DbxAuthFinish(accessToken, userId, null);
        }
    };
    public static final JsonReader<String> BearerTokenTypeReader = new JsonReader<String>(){

        @Override
        public String read(JsonParser parser) throws IOException, JsonReadException {
            try {
                String v = parser.getText();
                if (!v.equals("Bearer") && !v.equals("bearer")) {
                    throw new JsonReadException("expecting \"Bearer\": got " + StringUtil.jq(v), parser.getTokenLocation());
                }
                parser.nextToken();
                return v;
            }
            catch (JsonParseException ex) {
                throw JsonReadException.fromJackson(ex);
            }
        }
    };
    public static final JsonReader<String> AccessTokenReader = new JsonReader<String>(){

        @Override
        public String read(JsonParser parser) throws IOException, JsonReadException {
            try {
                String v = parser.getText();
                String error = DbxAppInfo.getTokenPartError(v);
                if (error != null) {
                    throw new JsonReadException(error, parser.getTokenLocation());
                }
                parser.nextToken();
                return v;
            }
            catch (JsonParseException ex) {
                throw JsonReadException.fromJackson(ex);
            }
        }
    };

    public DbxAuthFinish(String accessToken, String userId, String urlState) {
        this.accessToken = accessToken;
        this.userId = userId;
        this.urlState = urlState;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUrlState() {
        return this.urlState;
    }
}

