/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.json;

import com.dropbox.core.json.CompositeJsonDeserializer;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;

public abstract class StructJsonDeserializer<T>
extends CompositeJsonDeserializer<T> {
    private static final long serialVersionUID = 0L;
    private final boolean unwrapping;

    protected StructJsonDeserializer(Class<T> clazz, Class<?> ... subtypeClasses) {
        this(clazz, false, subtypeClasses);
    }

    protected StructJsonDeserializer(Class<T> clazz, boolean unwrapping, Class<?> ... subtypeClasses) {
        super(clazz, subtypeClasses);
        this.unwrapping = unwrapping;
    }

    @Override
    public JsonDeserializer<T> unwrappingDeserializer(NameTransformer unwrapper) {
        return this.asUnwrapping();
    }

    protected JsonDeserializer<T> asUnwrapping() {
        throw new IllegalStateException(this.getClass().toString() + " does not support unwrapping.");
    }

    @Override
    public final T deserialize(JsonParser p, DeserializationContext ctx) throws IOException, JsonParseException {
        if (!this.unwrapping) {
            StructJsonDeserializer.expectObjectStart(p);
        }
        T instance = this.deserializeFields(p, ctx);
        if (!this.unwrapping) {
            StructJsonDeserializer.expectObjectEnd(p);
        }
        return instance;
    }

    protected abstract T deserializeFields(JsonParser var1, DeserializationContext var2) throws IOException, JsonParseException;
}

