/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;

public abstract class StructJsonSerializer<T>
extends StdSerializer<T> {
    private static final long serialVersionUID = 0L;
    private final boolean unwrapping;

    protected StructJsonSerializer(Class<T> clazz) {
        this(clazz, false);
    }

    protected StructJsonSerializer(Class<T> clazz, boolean unwrapping) {
        super(clazz);
        this.unwrapping = unwrapping;
    }

    @Override
    public boolean isUnwrappingSerializer() {
        return this.unwrapping;
    }

    @Override
    public JsonSerializer<T> unwrappingSerializer(NameTransformer unwrapper) {
        return this.asUnwrapping();
    }

    protected JsonSerializer<T> asUnwrapping() {
        throw new IllegalStateException(this.getClass().toString() + " does not support unwrapping.");
    }

    @Override
    public final void serialize(T value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (!this.unwrapping) {
            g.writeStartObject();
        }
        this.serializeFields(value, g, provider);
        if (!this.unwrapping) {
            g.writeEndObject();
        }
    }

    protected abstract void serializeFields(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException, JsonProcessingException;
}

