/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.json;

import com.dropbox.core.json.CompositeJsonDeserializer;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class UnionJsonDeserializer<V, T extends Enum<T>>
extends CompositeJsonDeserializer<V> {
    private static final long serialVersionUID = 0L;
    private final Map<String, T> _tagMapping;
    private final T _catchAll;

    protected UnionJsonDeserializer(Class<V> clazz, Map<String, T> tagMapping, T catchAll, Class<?> ... unwrappableFieldClasses) {
        super(clazz, unwrappableFieldClasses);
        if (tagMapping == null) {
            throw new NullPointerException("tagMapping");
        }
        this._tagMapping = Collections.unmodifiableMap(new HashMap<String, T>(tagMapping));
        this._catchAll = catchAll;
    }

    protected abstract V deserialize(T var1, JsonParser var2, DeserializationContext var3) throws IOException, JsonParseException;

    @Override
    public V deserialize(JsonParser p, DeserializationContext ctx) throws IOException, JsonParseException {
        V value;
        if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
            T tag = this.parseTag(p, p.getText());
            value = this.deserialize(tag, p, ctx);
        } else {
            UnionJsonDeserializer.expectObjectStart(p);
            T tag = this.parseTag(p, UnionJsonDeserializer.readTag(p));
            value = this.deserialize(tag, p, ctx);
            UnionJsonDeserializer.expectObjectEnd(p);
        }
        return value;
    }

    private T parseTag(JsonParser p, String value) throws IOException, JsonParseException {
        Enum tag = (Enum)this._tagMapping.get(value);
        if (tag == null) {
            if (this._catchAll == null) {
                throw new JsonParseException(p, "Unanticipated tag " + value + " without catch-all");
            }
            tag = this._catchAll;
        }
        return (T)tag;
    }
}

