/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class GpsCoordinates {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final double latitude;
    protected final double longitude;

    public GpsCoordinates(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.latitude, this.longitude});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            GpsCoordinates other = (GpsCoordinates)obj;
            return this.latitude == other.latitude && this.longitude == other.longitude;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<GpsCoordinates> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(GpsCoordinates.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(GpsCoordinates.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<GpsCoordinates> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public GpsCoordinates deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            Double latitude = null;
            Double longitude = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("latitude".equals(_field)) {
                    latitude = _p.getDoubleValue();
                    _p.nextToken();
                    continue;
                }
                if ("longitude".equals(_field)) {
                    longitude = _p.getDoubleValue();
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (latitude == null) {
                throw new JsonParseException(_p, "Required field \"latitude\" is missing.");
            }
            if (longitude == null) {
                throw new JsonParseException(_p, "Required field \"longitude\" is missing.");
            }
            return new GpsCoordinates(latitude, longitude);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<GpsCoordinates> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(GpsCoordinates.class);
        }

        public Serializer(boolean unwrapping) {
            super(GpsCoordinates.class, unwrapping);
        }

        @Override
        protected JsonSerializer<GpsCoordinates> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(GpsCoordinates value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("latitude", value.latitude);
            g.writeObjectField("longitude", value.longitude);
        }
    }
}

